﻿package pl.fabrykagier.edufarma {
	
	import pl.fabrykagier.edufarma.Product;
	
	import flash.events.MouseEvent;
	import flash.events.Event;
	import flash.display.MovieClip;
	import flash.text.TextFormat;
	import flash.text.TextField;
	import fl.controls.TextArea;
	import flash.net.drm.VoucherAccessInfo;
	
	public class AITest extends MovieClip{

		public function AITest() 
		{
			_productsList = new Vector.<Product>();
			_shopsList = new Vector.<Shop>();
			_playerList = new Vector.<Player>();
			
			shopContainer = new MovieClip();
			playerContainer = new MovieClip();
			
			addEventListener(Event.ADDED_TO_STAGE, onAddedHandler);
		}
		
		private function onAddedHandler(event:Event):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, onAddedHandler);

			this["nProduct"].buttonMode = true;
			this["nProduct"].addEventListener(MouseEvent.CLICK, newProductHandler);
			
			this["nShop"].buttonMode = true;
			this["nShop"].addEventListener(MouseEvent.CLICK, newShopHandler);
			
			this["nPlayer"].buttonMode = true;
			this["nPlayer"].addEventListener(MouseEvent.CLICK, newPlayerHandler);
			
			this["sym"].buttonMode = true;
			this["sym"].addEventListener(MouseEvent.CLICK, symHandler);
			
			var product1:Product = new Product("Owoce","");
			var product2:Product = new Product("Jaja","");
			var product3:Product = new Product("Mleko","");
			var product4:Product = new Product("Warzywa","");
			var product5:Product = new Product("Warzywa Szklar.","");
			var product6:Product = new Product("Mąka","");
			var product7:Product = new Product("Ziarno słonecznika","");
			var product8:Product = new Product("Wieprzowina","");
			
			var shop1:Shop = new Shop("Warzywniak");
			shop1.addProduct("Owoce","",150,4.8);
			shop1.addProduct("Jaja","",138,3.2);
			shop1.addProduct("Mleko","",138,4.8);
			shop1.addProduct("Warzywa","",126,4.8);
			shop1.addProduct("Warzywa Szklar.","",141,6.4);
			shop1.addProduct("Mąka","",180,3.2);
			shop1.addProduct("Ziarno słonecznika","",138,2.9);
			addShop(shop1);
			
			var shop2:Shop = new Shop("Sklep Mięsny");
			shop2.addProduct("Wieprzowina","",102,6.4);
			addShop(shop2);
			
			var shop3:Shop = new Shop("Dyskont Brutto");
			shop3.addProduct("Owoce","",200,4.8);
			shop3.addProduct("Jaja","",150,3.2);
			shop3.addProduct("Mleko","",152,4.8);
			shop3.addProduct("Warzywa","",142,4.8);
			shop3.addProduct("Warzywa Szklar.","",158,6.4);
			shop3.addProduct("Mąka","",198,3.2);
			shop3.addProduct("Ziarno słonecznika","",150,2.9);
			shop3.addProduct("Wieprzowina","",172,6.4);
			addShop(shop3);
			
			var shop4:Shop = new Shop("Hipermarket Normal");
			shop4.addProduct("Owoce","",300,4.8);
			shop4.addProduct("Jaja","",201,3.2);
			shop4.addProduct("Mleko","",204,4.8);
			shop4.addProduct("Warzywa","",195,4.8);
			shop4.addProduct("Warzywa Szklar.","",219,6.4);
			shop4.addProduct("Mąka","",267,3.2);
			shop4.addProduct("Ziarno słonecznika","",201,2.9);
			shop4.addProduct("Wieprzowina","",234,6.4);
			addShop(shop4);
			
			var shop5:Shop = new Shop("Hipermarket Full");
			shop5.addProduct("Owoce","",200,4.8);
			shop5.addProduct("Warzywa","",102,4.8);
			shop5.addProduct("Wieprzowina","",124,6.4);
			addShop(shop5);
			
			var player1:Player = new Player("Gracz 1");
			player1.addProduct("Owoce","",400,2.4);
			player1.addProduct("Jaja","",320,2.2);
			player1.addProduct("Mleko","",730,3.1);
			player1.addProduct("Warzywa","",400,3.0);
			player1.addProduct("Warzywa Szklar.","",320,4.0);
			player1.addProduct("Mąka","",80,2.0);
			player1.addProduct("Ziarno słonecznika","",50,1.8);
			player1.addProduct("Wieprzowina","",210,3.7);
			addPlayer(player1);
			
			var player2:Player = new Player("Gracz 2");
			player2.addProduct("Owoce","",320,2.1);
			player2.addProduct("Mąka","",120,1.9);
			player2.addProduct("Wieprzowina","",240,3.9);
			addPlayer(player2);
			
			var player3:Player = new Player("Gracz 3");
			player3.addProduct("Owoce","",50,2.7);
			player3.addProduct("Jaja","",120,1.9);
			player3.addProduct("Mąka","",320,2.0);
			addPlayer(player3);
			
			var player4:Player = new Player("Gracz 4");
			player4.addProduct("Owoce","",130,2.4);
			player4.addProduct("Jaja","",170,2.3);
			player4.addProduct("Warzywa","",120,3.2);
			player4.addProduct("Warzywa Szklar.","",320,3.6);
			player4.addProduct("Mąka","",100,2.0);
			player4.addProduct("Ziarno słonecznika","",50,1.8);
			player4.addProduct("Wieprzowina","",110,3.4);
			addPlayer(player4);
			
			var player5:Player = new Player("Gracz 5");
			player5.addProduct("Jaja","",220,3.1);
			player5.addProduct("Warzywa","",150,3.1);
			player5.addProduct("Mąka","",110,2.2);
			player5.addProduct("Ziarno słonecznika","",320,1.6);
			player5.addProduct("Wieprzowina","",310,3.9);
			addPlayer(player5);
			
			var player6:Player = new Player("Gracz 6");
			player6.addProduct("Owoce","",490,2.5);
			player6.addProduct("Jaja","",210,1.8);
			player6.addProduct("Warzywa","",120,3.0);
			player6.addProduct("Mąka","",420,3.2);
			player6.addProduct("Wieprzowina","",90,4.0);
			addPlayer(player6);
			
		}
		
		private function newShopHandler(event:MouseEvent):void
		{
			addChild(new NewShopPopup());
		}
		
		private function newProductHandler(event:MouseEvent):void
		{
			addChild(new NewProductPopup());
		}
		
		private function newPlayerHandler(event:MouseEvent):void
		{
			addChild(new NewPlayerPopup());
		}
		
		public function addProduct(product:Product):void
		{
			_productsList.push(product);
			logData("Nowy produkt został dodany - nazwa: "+product.name+" grupa: "+product.group);
		}
		
		public function addShop(shop:Shop):void
		{
			_shopsList.push(shop);
			refreshShopList();
		}
		
		public function addPlayer(player:Player):void
		{
			_playerList.push(player);
			refreshPlayersList();
		}
		
		public function get productsList():Vector.<Product>
		{
			return _productsList;
		}
		
		private function refreshPlayersList():void
		{
			if(playerContainer && playerContainer.parent)
				removeChild(playerContainer);
			
			//trace("show player")
			
			playerContainer = new MovieClip();
			
			var myFormat:TextFormat = new TextFormat();  
  			
 			myFormat.color = 0x000000 
			myFormat.size = 14; 
			
			playerContainer.x = 200;
			playerContainer.y = 40;
			
			var position:int = 0;
			
			for each(var player:Player in _playerList)
			{
				var tf:TextField = new TextField();
				tf.text = player.name;
				tf.setTextFormat(myFormat);
				tf.y = position;
				tf.selectable = false;
				tf.addEventListener(MouseEvent.CLICK, removePlayer);
				playerContainer.addChild(tf);
				
				position += 17;
			}
			
			addChild(playerContainer);
		}
		
		private function refreshShopList():void
		{
			
			if(shopContainer && shopContainer.parent)
				removeChild(shopContainer);
			
			shopContainer = new MovieClip();
			
			var myFormat:TextFormat = new TextFormat();  
  			
 			myFormat.color = 0x000000 
			myFormat.size = 14; 
			
			shopContainer.x = 10;
			shopContainer.y = 40;
			
			var position:int = 0;
			
			for each(var shop:Shop in _shopsList)
			{
				var tf:TextField = new TextField();
				tf.text = shop.name;
				tf.setTextFormat(myFormat);
				tf.y = position;
				tf.selectable = false;
				tf.addEventListener(MouseEvent.CLICK, removeShop);
				shopContainer.addChild(tf);
				
				position += 17;
			}
			
			addChild(shopContainer);
		}
		
		private function removeShop(event:MouseEvent):void
		{
			trace(event.target.text);
			
			for each(var shop:Shop in _shopsList)
			{
				if(shop.name == event.target.text)
				{
					_shopsList.splice(_shopsList.indexOf(shop),1);
					refreshShopList();
					return;
				}
			}
			
		}
		
		private function removePlayer(event:MouseEvent):void
		{
			trace(event.target.text);
			
			for each(var player:Player in _playerList)
			{
				if(player.name == event.target.text)
				{
					_playerList.splice(_playerList.indexOf(player),1);
					refreshPlayersList();
					return;
				}
			}
			
		}
		
		public function logData(data:String):void
		{
			if(data == "clear")
				TextArea(symLog).text = "";
			else
				TextArea(symLog).appendText(data+"\n");
		}
		
		private function symHandler(event:MouseEvent):void
		{
			var ai:AI = new AI(_shopsList,_playerList,logData);
			//ai.symRound();
		}
		
		private var shopContainer:MovieClip;
		private var playerContainer:MovieClip;
		private var _productsList:Vector.<Product>;
		private var _shopsList:Vector.<Shop>;
		private var _playerList:Vector.<Player>;

	}
	
}