﻿package 
{
	import flash.media.Sound;
	import flash.display.Loader;
	import flash.text.TextField;

	import mx.events.FlexEvent;

	import flash.events.ProgressEvent;

	import mx.preloaders.IPreloaderDisplay;
	
	import flash.events.Event;
	import flash.display.MovieClip;
	import flash.display.Sprite;

	[SWF(backgroundColor="#FFFFFF",frameRate="30",width="800",height="600")]
	public class Preloader extends Sprite implements IPreloaderDisplay {

		protected var _preloader : Sprite;
		protected var preloaderBox : MovieClip;

		
		public function Preloader() 
		{
			this.addEventListener(Event.ADDED_TO_STAGE, onAddedHandler);
		}
		
		private function onAddedHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, onAddedHandler);
		}

		//---------------------------- init ----------------------------
		/**
		 * Sets object to preload and specify the event listeners.
		 *  @param preloader object to preload
		 */
		public function set preloader(preloader : Sprite) : void 
		{
			_preloader = preloader;
			// Listen for the relevant events
			_preloader.addEventListener(ProgressEvent.PROGRESS, progressHandler); 
			_preloader.addEventListener(Event.COMPLETE, completeHandler);
    
			_preloader.addEventListener(FlexEvent.INIT_PROGRESS, initProgressHandler);
			_preloader.addEventListener(FlexEvent.INIT_COMPLETE, initCompleteHandler);
		}

		/**
		 *  Initialize graphic
		 */ 
		public function initialize() : void 
		{
			//add preloader graph
			preloaderBox = new PreloaderBox();
			preloaderBox.x = 0;
			preloaderBox.y = 0;
			addChild(preloaderBox);
		}   

		//---------------------------- event handlers ----------------------------
		/**
		 *  progress update handler
		 */
		private function progressHandler(event : ProgressEvent) : void 
		{	
			//progress event
			var percents : int = Math.floor(event.bytesLoaded / event.bytesTotal * 100);
			//TextField(preloaderBox["preloaderText"]).text = percents.toString() + "%";
			if (preloaderBox["preloaderContainer"]) MovieClip(preloaderBox["preloaderContainer"]).gotoAndStop(percents);
			if (preloaderBox["preloaderContainer"]) TextField(MovieClip(preloaderBox["preloaderContainer"])["preloaderText"]).text = percents.toString() + "%";
			stage.showDefaultContextMenu = false;
		}

		/**
		 * download complete handler
		 */
		private function completeHandler(event : Event) : void 
		{
		}

		/**
		 * aplication init progress
		 */
		private function initProgressHandler(event : Event) : void 
		{
		}

		/**
		 * aplication init complete handler
		 * dispatches Event.COMPLETE indicating that the SystemManager 
		 * is ready to remove the Preloader and to add the application to the display list.
		 */
		private function initCompleteHandler(event : Event) : void 
		{
				
			_preloader.removeEventListener(ProgressEvent.PROGRESS, progressHandler); 
			_preloader.removeEventListener(Event.COMPLETE, completeHandler);
			
			_preloader.removeEventListener(FlexEvent.INIT_PROGRESS, initProgressHandler);
			_preloader.removeEventListener(FlexEvent.INIT_COMPLETE, initCompleteHandler);
			
			preloaderBox.addEventListener("preloader_end", onEndHandler);
			preloaderBox.gotoAndPlay("preloaderOut");
		}
		
		private function onEndHandler(e:Event):void 
		{
			preloaderBox.removeEventListener("preloader_end", onEndHandler);
			dispatchEvent(new Event(Event.COMPLETE));
		}


		public function get backgroundColor() : uint 
		{
			return 0;
		}

		public function set backgroundColor(value : uint) : void 
		{
		}

		public function get backgroundAlpha() : Number 
		{
			return 0;
		}

		public function set backgroundAlpha(value : Number) : void 
		{
		}

		public function get backgroundImage() : Object 
		{
			return undefined;
		}

		public function set backgroundImage(value : Object) : void 
		{
		}

		public function get backgroundSize() : String 
		{
			return "";
		}

		public function set backgroundSize(value : String) : void 
		{
		}

		public function get stageWidth() : Number 
		{
			return 800;//game width
		}

		public function set stageWidth(value : Number) : void 
		{
		}

		public function get stageHeight() : Number 
		{
			return 600;//game height
		}

		public function set stageHeight(value : Number) : void 
		{
		}
	}
}
