package pl.fabrykagier.eduFarma.adminPanel 
{
	import com.greensock.TweenLite;
	import fl.controls.ComboBox;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.TextEvent;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * The user login field. Handles input of username and password and logging in to the game zone on server.
	 * @author Andrzej Kaczor
	 */
	public class AdminLoginBox extends MovieClip
	{
		private var verifyPattern:RegExp = /^[a-zA-Z0-9]*$/; 	// a regular expression used to filter unallowed chars in the username and password fields
		private var loginText:TextField;
		private var passwordText:TextField;
		private var roomName:String;
		private var roomId:int;
		private var classListCombo:ComboBox;
		private var classList:Array;
		private var currentSelectedClassId:int = -1;
		private var currentSelectedClassDatabaseId:int;
		
		/**
		 * Constructor. Gets the text fields references and registers functions used with contained buttons.
		 */
		public function AdminLoginBox() 
		{
			alpha = 0;
			
			Framework.instance.registerFunction(enterRoom, "enterRoom");
			
			classListCombo = getChildByName("classSelection") as ComboBox;
			classListCombo.enabled = false;
			
			this.addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			this.addEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);			
		}
		
		private function addedToStageHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			TweenLite.to(this, 0.3, { alpha:1 } );
		}
			
		public function populateClassList(classList:Array):void
		{
			this.classList = classList;
			
			classListCombo.addItem({label:"--- Wybierz klasę ---"});
			
			for each (var classDesc:Object in classList)
			{
				classListCombo.addItem( { label:classDesc.roomAlias, data:classDesc.roomId, data2:classDesc.id } );
			}
			
			classListCombo.rowCount = classList.length + 1 < 5 ? classList.length + 1 : 5;
			classListCombo.enabled = true;
			classListCombo.addEventListener(Event.CHANGE, handleClassSelection);
		}
		
		private function handleClassSelection(e:Event):void 
		{
			currentSelectedClassId = int(classListCombo.selectedItem.data);
			currentSelectedClassDatabaseId = int(classListCombo.selectedItem.data2);
		}
		
		/**
		 * Called upon removal from the display list. Clears listeners.
		 * @param	e
		 */
		private function removedFromStageHandler(e:Event):void
		{
			classListCombo.removeEventListener(Event.CHANGE, handleClassSelection);
			removeEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
		}			
		
		/**
		 * Places the user in a previously selected room on server
		 */
		private function enterRoom():void 
		{
			if (currentSelectedClassId < 0)
				return;
				
			// Call the communicator function to physically change the room
			TweenLite.to(this, 0.3, { alpha:0, onComplete:AdminPanel.getInstance.logInToClass, onCompleteParams:[currentSelectedClassId, currentSelectedClassDatabaseId] } );
		}
	}

}