package pl.fabrykagier.eduFarma.adminPanel 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * The object displayed on the user list, representing a single user and info about him.
	 * @author Andrzej Kaczor
	 */
	public class SingleUserItem extends MovieClip
	{		
		private var confirmButton:MovieClip;
		private var refuseButton:MovieClip;
		private var _id:int;
		private var _serverId:int;
		private var _userId:int;
		private var _username:String;
		private var stopButton:MovieClip;
		
		/**
		 * Get the references to the buttons used to accept, refuse or kick the user
		 */
		public function SingleUserItem() 
		{
			confirmButton = MovieClip(this.getChildByName("confirm"));
			refuseButton = MovieClip(this.getChildByName("refuse"));
			stopButton = MovieClip(this.getChildByName("stopPlayer"));
			
			confirmButton.buttonMode = true;
			refuseButton.buttonMode = true;
			stopButton.buttonMode = true;
			
			confirmButton.addEventListener(MouseEvent.CLICK, handleConfirmUser);
			refuseButton.addEventListener(MouseEvent.CLICK, handleRefuseUser);
			stopButton.addEventListener(MouseEvent.CLICK, handleStopUser);
			
			this.addEventListener(Event.REMOVED_FROM_STAGE, removedHandler);
		}
		
		/**
		 * Called when this object is removed from stage
		 * @param	e
		 */
		private function removedHandler(e:Event):void
		{
			removeEventListener(Event.REMOVED_FROM_STAGE, removedHandler);
			confirmButton.removeEventListener(MouseEvent.CLICK, handleConfirmUser);
			refuseButton.removeEventListener(MouseEvent.CLICK, handleRefuseUser);
			stopButton.removeEventListener(MouseEvent.CLICK, handleStopUser);
		}
		
		/**
		 * The user is not allowed to play in this room. Send a message to the server about this and kick the user out of the room.
		 * @param	e
		 */
		private function handleRefuseUser(e:MouseEvent):void 
		{
			AdminPanel.getInstance.communicator.callExtension("usersExt", "refuseUser", {username:username, id:userId} );
		}
		
		/**
		 * The user is allowed to play in this room. Send a message to the server about accepting the user.
		 * @param	e
		 */
		private function handleConfirmUser(e:MouseEvent):void 
		{
			AdminPanel.getInstance.communicator.callExtension("usersExt", "confirmUser", { username:username, id:userId } );
						
			this.gotoAndStop("confirmed");
			
			Framework.instance.callRegisteredFunction("refreshList");
		}
		
		/**
		 * Stops this user's gameplay and kicks him out of the room.
		 * @param	e
		 */
		private function handleStopUser(e:MouseEvent):void
		{
			if (stopButton.alpha < 1) return;
			
			AdminPanel.getInstance.communicator.callExtension("usersExt", "endGame", { userId: serverId, roomId: AdminPanel.getInstance.roomID } );
			
			stopButton.removeEventListener(MouseEvent.CLICK, handleStopUser);
		}
		
		public function get id():int { return _id; }
		
		public function set id(value:int):void 
		{
			_id = value;
		}
		
		public function get userId():int { return _userId; }
		
		public function set userId(value:int):void 
		{
			_userId = value;
		}
		
		public function get username():String { return _username; }
		
		public function set username(value:String):void 
		{
			_username = value;
		}
		
		public function get serverId():int { return _serverId; }
		
		public function set serverId(value:int):void 
		{
			_serverId = value;
		}
		
	}

}