package pl.fabrykagier.eduFarma.communication 
{
	import com.adobe.crypto.MD5;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import it.gotoandplay.smartfoxserver.data.Room;
	import it.gotoandplay.smartfoxserver.SFSEvent;
	import it.gotoandplay.smartfoxserver.SmartFoxClient;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.framework.events.FrameworkEvent;
	
	/**
	 * Handles communications with SmartFox Server.
	 * @author Andrzej Kaczor
	 */
	public class Communicator extends EventDispatcher
	{
		static public const CONNECTION_ERROR:String = "connectionError";
		static public const AUTHENTICATION_REPONSE:String = "authenticationReponse";
		static public const JOINED_WAITING_ROOM:String = "joinedWaitingRoom";
		static public const USER_LIST_CHANGE:String = "userListChange";
		static public const EXTENSION_USERS:String = "usersExt";
		private var sfs:SmartFoxClient;
		private var extensionCallbackFunction:Array = [];
		private var FLAG_loggedIn:Boolean = false;
		private var sessionKey:String;
		private var _dbRoomId:int;
		private var userId:int;
		private var username:String;
		
		/**
		 * Constructor
		 * @param	debug - specifies wheter the server should work in debug or normal mode
		 */
		public function Communicator(debug:Boolean=false)
		{
			// create the client object
			sfs = new SmartFoxClient(debug);
	
			// Register for SFS events
			sfs.addEventListener(SFSEvent.onConnection, onConnectionHandler);
			sfs.addEventListener(SFSEvent.onConnectionLost, onConnectionLostHandler);
			sfs.addEventListener(SFSEvent.onLogin, onLoginHandler);
			sfs.addEventListener(SFSEvent.onRoomListUpdate, onRoomListUpdateHandler);
			sfs.addEventListener(SFSEvent.onJoinRoom, onJoinRoomHandler);
			sfs.addEventListener(SFSEvent.onJoinRoomError, onJoinRoomErrorHandler);
			sfs.addEventListener(SFSEvent.onExtensionResponse, extensionResponseHandler);
			sfs.addEventListener(SFSEvent.onRandomKey, onRandomKeyHandler);
			sfs.addEventListener(SFSEvent.onUserCountChange, onUserCountChangeHandler);

			// Register for generic errors
			sfs.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onSecurityError);
			sfs.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
		}
		
		private function onUserCountChangeHandler(e:SFSEvent):void 
		{
			this.dispatchEvent(new Event(USER_LIST_CHANGE));
		}
		
		private function onLogoutHandler(e:SFSEvent):void 
		{
			sfs.removeEventListener(SFSEvent.onConnection, onConnectionHandler);
			sfs.removeEventListener(SFSEvent.onConnectionLost, onConnectionLostHandler);
			sfs.removeEventListener(SFSEvent.onLogin, onLoginHandler);
			sfs.removeEventListener(SFSEvent.onRoomListUpdate, onRoomListUpdateHandler);
			sfs.removeEventListener(SFSEvent.onJoinRoom, onJoinRoomHandler);
			sfs.removeEventListener(SFSEvent.onJoinRoomError, onJoinRoomErrorHandler);
			sfs.removeEventListener(SFSEvent.onExtensionResponse, extensionResponseHandler);
			sfs.removeEventListener(SFSEvent.onRandomKey, onRandomKeyHandler);
			sfs.removeEventListener(SFSEvent.onLogout, onLogoutHandler);
			sfs.removeEventListener(SFSEvent.onUserCountChange, onUserCountChangeHandler);
		}
		
		private function nullFunction(o:Object):void {}
		
		/**
		 * Establishes a connection to the local server (127.0.0.1), default TCP port (9339)
		 */
		public function connect(userId:int, username:String, address:String="37.128.104.86"):void
		{
			this.username = username;
			this.userId = userId;
			address = "37.128.104.86";
			
			if (!sfs.isConnected) sfs.connect(address);
			else trace("You are already connected!");
		}
		
		public function retryConnection():void
		{
			connect(userId, username);
		}
		
		/**
		 * Called when the client has connected to the server
		 * @param	e
		 */
		private function onConnectionHandler(e:SFSEvent):void 
		{
			var success:Boolean = e.params.success;
	
			// if the connection was a success
			if (success)
			{
				trace("Connection successfull!");
				login(username + "_" + userId.toString(), "guest");
												
				// Attempt to log in "simpleChat" Zone as a guest user
				//sfs.login("eduFarma", "", "");
			}
			// or not
			else
			{
				trace("Connection failed!");
				
				var event:FrameworkEvent = new FrameworkEvent(CONNECTION_ERROR);
				event.addParameter("errorType", "InitialConnectionError");
				this.dispatchEvent(event);
			}
		}
		
		private function onRandomKeyHandler(evt:SFSEvent):void
		{
			sessionKey = evt.params.key;
		}
		
		/**
		 * Login to a zone on the server using specified username and password
		 * @param	username
		 * @param	password
		 */
		public function login(username:String, password:String):void
		{
			if (username != "guest" && password != "guest")
			{
				password = MD5.hash(sessionKey + password);
			}
			
			sfs.login("eduFarma", username, password);
		}
		
		/**
		 * Try to register a new user using specified username and password
		 * @param	username
		 * @param	password
		 */
		public function register(username:String, password:String):void
		{
			
		}
		
		/**
		 * Calls a custom server extension specified by the "extensionName" parameter.
		 * @param	extensionName - the name of the extension which we want to call
		 * @param	extensionCommand - a command which we want to execute
		 * @param	extensionParams - all the needed parameters for the command to process
		 * @param	extensionCallback - a function to call when the extension sends a response
		 */
		public function callExtension(extensionName:String, extensionCommand:String, extensionParams:Object = null ):void
		{
			sfs.sendXtMessage(extensionName, extensionCommand, extensionParams, "xml");
			trace("######### EXT CALL ##########")
			trace(extensionName, extensionCommand, extensionParams);
		}
		
		/**
		 * Allows to set a callback function called on extension response
		 * @param	func - the callback function
		 */
		public function setExtensionCallback(func:Function, cmd:String):void
		{
			trace("SET CALLBACK: ", cmd)
					
			extensionCallbackFunction[cmd] = func;
		}
		
		/**
		 * Handles the response object sent by the server side extension when it finishes it's job
		 * @param	e
		 */
		private function extensionResponseHandler(e:SFSEvent):void 
		{						
			if (e.params.dataObj.command == "endGameResults")
			{
				var results:Array = (e.params.dataObj.results as Array);
				
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.END_GAME, {scoreResults:results}));
				return;
			}
			
			if (e.params.dataObj.command == "simulationStarting")
			{
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.SIMULATION_START));
				return;
			}
			
			if (e.params.dataObj.command == "timeSync")
			{
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.TIME_SYNC, { time:int(e.params.dataObj.time), targetTime: int(e.params.dataObj.targetTime), firstRoundId:int(e.params.dataObj.firstRoundId), isTutorial:int(e.params.dataObj.tutorial)} ));							
				return;
			}
			
			// call a callback function if there was one registered
			if(extensionCallbackFunction[e.params.dataObj._cmd] != null && extensionCallbackFunction[e.params.dataObj._cmd] != undefined) extensionCallbackFunction[e.params.dataObj._cmd].apply(null, [e.params.dataObj]);
					
			// Specifically for the custom login extension - if the login operation was successful, update the room list from server
			if (e.params.dataObj._cmd == "logOK")
			{
				sfs.getRoomList();
				
				if (!String(e.params.dataObj.name).match("guest"))				{
					
					sfs.addEventListener(SFSEvent.onLogout, onLogoutHandler);
				}
			}		
			
			if(extensionCallbackFunction[e.params.dataObj._cmd] != null && extensionCallbackFunction[e.params.dataObj._cmd] != undefined) extensionCallbackFunction[e.params.dataObj._cmd] = null;
		}
		
		/**
		 * Called when the client has been disconnected from the server
		 * @param	e
		 */
		private function onConnectionLostHandler(e:SFSEvent):void
		{
			sfs.removeEventListener(SFSEvent.onConnection, onConnectionHandler);
			sfs.removeEventListener(SFSEvent.onConnectionLost, onConnectionLostHandler);
			sfs.removeEventListener(SFSEvent.onLogin, onLoginHandler);
			sfs.removeEventListener(SFSEvent.onRoomListUpdate, onRoomListUpdateHandler);
			sfs.removeEventListener(SFSEvent.onJoinRoom, onJoinRoomHandler);
			sfs.removeEventListener(SFSEvent.onJoinRoomError, onJoinRoomErrorHandler);
			sfs.removeEventListener(SFSEvent.onExtensionResponse, extensionResponseHandler);
			sfs.removeEventListener(SFSEvent.onRandomKey, onRandomKeyHandler);
			sfs.removeEventListener(SFSEvent.onLogout, onLogoutHandler);
			sfs.removeEventListener(SFSEvent.onPublicMessage, messageHandler);
			sfs.removeEventListener(SFSEvent.onPrivateMessage, messageHandler);
			
			var event:FrameworkEvent = new FrameworkEvent(CONNECTION_ERROR);
			event.addParameter("errorType", "ConnectionError");
			this.dispatchEvent(event);
		}
		
		/**
		 * Called when the client has successfully logged into a zone on the server. Called only when the standard login procedure is invoked.
		 * @param	e
		 */
		private function onLoginHandler(e:SFSEvent):void 
		{
			
		}
		
		/**
		 * After successful login the client receives a room list update. This is called when the update occurs.
		 * @param	e
		 */
		private function onRoomListUpdateHandler(e:SFSEvent):void 
		{		
			sfs.joinRoom("WaitingRoom");
		}
		
		/**
		 * Handles messages receieved from other users
		 * @param	e
		 */
		private function messageHandler(e:SFSEvent):void 
		{
			switch(e.params.message)
			{
				case "EDU_FARMA_GAME_START":
				{
					GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.GAME_START));
					
					break;
				}
			}
		}
		
		/**
		 * Sends a message to another user
		 * @param	message - the message
		 * @param	type - type of the message: public - goes to everyone in a room, private - goes to a specific user
		 * @param	roomId - the room id which te message should go to
		 * @param	userId - if this is a private message - the id of the user which this message should go to
		 */
		public function sendMessage(message:String, type:String, roomId:int = -1, userId:int = -1):void
		{
			if (roomId == -1)
			{
				roomId = sfs.getActiveRoom().getId();
			}
			
			if (type == "public")
			{
				sfs.sendPublicMessage(message, roomId);
			}
			else if (type == "private")
			{
				sfs.sendPrivateMessage(message, userId, roomId);
			}
		}
		
		/**
		 * Changes the room or leaves a room
		 * @param	roomName - the room which the user wants to log in to
		 * @param	noRoom - set to true if you want to leave the current room
		 */
		public function changeRoom(roomName:*, noRoom:Boolean = false):void
		{
			if(!noRoom) sfs.leaveRoom(sfs.getActiveRoom().getId());
			sfs.joinRoom(roomName);
		}
				
		public function authenticate(sessionId:String, userId:int):void 
		{
			setExtensionCallback(authenticationResponse, "authenticate");
			callExtension(EXTENSION_USERS, "authenticate", { sessionId:sessionId, userId:userId.toString() } );
		}
		
		public function authenticateTeacher(sessionId:String, userId:int):void 
		{
			setExtensionCallback(authenticationResponse, "authenticateTeacher");
			callExtension("usersExt", "authenticateTeacher", { sessionId:sessionId, userId:userId.toString() } );
		}
		
		private function authenticationResponse(response:Object):void 
		{
			trace("AUTH RESPONSE:", response.authenticationStatus);
			
			if (response.authenticationStatus == "1") FLAG_loggedIn = true;
			
			var event:FrameworkEvent = new FrameworkEvent(AUTHENTICATION_REPONSE);
			event.addParameter("status", response.authenticationStatus);
			event.addParameter("roomName", response.roomName);
			event.addParameter("roomId", response.roomId);
			event.addParameter("schoolId", response.schoolId);
			
			FLAG_loggedIn = true;
			
			this.dispatchEvent(event);
		}
		
		/**
		 * Called when the user joins a room.
		 * @param	e
		 */
		private function onJoinRoomHandler(e:SFSEvent):void 
		{
			trace("JOIN ROOM");
			
			sfs.addEventListener(SFSEvent.onPublicMessage, messageHandler);
			sfs.addEventListener(SFSEvent.onPrivateMessage, messageHandler);
					
			if (FLAG_loggedIn) this.dispatchEvent(new Event("RESTORE_DATA"));
			else this.dispatchEvent(new Event(JOINED_WAITING_ROOM));
		}
		
		/**
		 * Called when an error occured during an attempt to join a room.
		 * @param	e
		 */
		private function onJoinRoomErrorHandler(e:SFSEvent):void 
		{
			var event:FrameworkEvent = new FrameworkEvent(CONNECTION_ERROR);
			event.addParameter("errorType", "JoinRoomError");
			this.dispatchEvent(event);
		}
		
		/**
		 * Generic security error
		 * @param	e
		 */
		private function onSecurityError(e:SecurityErrorEvent):void 
		{
			var event:FrameworkEvent = new FrameworkEvent(CONNECTION_ERROR);
			event.addParameter("errorType", "SecurityError");
			this.dispatchEvent(event);
		}
		
		/**
		 * Generic Input/Output error
		 * @param	e
		 */
		private function onIOError(e:IOErrorEvent):void 
		{
			var event:FrameworkEvent = new FrameworkEvent(CONNECTION_ERROR);
			event.addParameter("errorType", "");
			this.dispatchEvent(event);
		}
		
		public function get dbRoomId():int { return _dbRoomId; }
		
		public function set dbRoomId(value:int):void 
		{
			_dbRoomId = value;
		}
	}

}