package pl.fabrykagier.eduFarma.gameInterface 
{
	import adobe.utils.CustomActions;
	import com.greensock.plugins.VolumePlugin;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.utils.getDefinitionByName;
	import flash.utils.getQualifiedClassName;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.popups.InfoPopup;
	import pl.fabrykagier.engines.tEngine.EngineSettings;
	import pl.fabrykagier.framework.display.buttons.GotoButton;
	import pl.fabrykagier.framework.main.Framework;
	import pl.fabrykagier.framework.states.FrameworkState;
	import pl.fabrykagier.framework.states.FrameworkStatesType;
	
	/**
	 * An item on the buildings list
	 * @author Andrzej Kaczor
	 */
	public class BuildingListItem extends GotoButton
	{
		public var FLAG_inactive:Boolean = false;
		private static var _WIDTH:Number = 97.35;
		private static var _HEIGHT:Number = 97.35;
		private var _itemGraphics:MovieClip;
		private var objectGraphics:MovieClip;
		private var objectName:String;
		private var _typeId:int;
		private var _objectSettings:Object;
		
		/**
		 * Class constructor
		 * @param	name - name of the building
		 * @param	asset - graphic asset for the building
		 */
		public function BuildingListItem(objectSettings:Object) 
		{			
			this._objectSettings = objectSettings;
			
			// Create background graphics with description field
			itemGraphics = new buildingListItem();
			this.addChild(itemGraphics);
			
			this.addChild(itemGraphics["lockEnabled_false$"]);
			
			// Update the description field to show the name of the building
			//TextField(itemGraphics["itemName"]).text = name;
			TextField(itemGraphics["itemPrice"]).text = objectSettings["costLevel1"];
			
			objectName = objectSettings["name"];
			_typeId = int(objectSettings["typeId"]);
			
			// Create and scale the building graphics, then fit it in the center
			objectGraphics = MovieClip(new (getDefinitionByName(objectSettings["graphicAssetName"] + "_icon") as Class)());
			objectGraphics.gotoAndStop(1);
			//objectGraphics.scaleX = objectGraphics.scaleY = (HEIGHT*WIDTH*3/4) / (objectGraphics.height*objectGraphics.width);
			//objectGraphics.x = -objectGraphics.getBounds(this).topLeft.x + (WIDTH - objectGraphics.width) / 2;
			//objectGraphics.y = -objectGraphics.getBounds(this).topLeft.y + (HEIGHT*3/4 - objectGraphics.height) / 2;
			MovieClip(itemGraphics.getChildByName("icon")).addChild(objectGraphics);						
		}
		
		/**
		 * Shows a popup containing information about a building
		 */
		private function showBuildingInfo():void 
		{
			var popup:InfoPopup = new buildingInfoPopup();
			
			var parameters:Object = {};
			
			parameters.name = this.objectName;
			parameters.description = _objectSettings["description"];
			parameters.price = _objectSettings["costLevel1"];
			parameters.outputName = _objectSettings["outputProductName"];
			if(_objectSettings["inputProductName"]) parameters.inputName = _objectSettings["inputProductName"];
			parameters.buildTime = _objectSettings["constructionTime1"];
			parameters.inputType = _objectSettings["inputType"];
			parameters.asset = objectSettings["graphicAssetName"] + "_icon";
			if(objectSettings["inputProduct"] && objectSettings["inputProduct"] != "undefined") parameters.inputAsset = GameSettings.PRODUCTS[objectSettings["inputProduct"]].productIcon;
			if(objectSettings["outputProduct"] && objectSettings["outputProduct"] != "undefined") parameters.outputAsset = GameSettings.PRODUCTS[objectSettings["outputProduct"]].productIcon;
			
			for each (var object:Object in EngineSettings.PLACEABLE_SETTINGS)
			{
				if (object.type == "type 6" && object.objectSettings["inputType"] == objectSettings["outputType"])
				{
					parameters.warehouseName = object.placeableName;					
					
					var icon:MovieClip = MovieClip(new (getDefinitionByName(object.asset + "_icon") as Class)());
					icon.gotoAndStop(1);
					
					parameters.warehouseIcon = icon;
					break;
				}
			}
			
			popup.setInfo(parameters, _objectSettings["type"]);
			
			popup.x = 0;
			popup.y = 0;
			
			MainGameClass.getInstance.gameClip.addChild(popup);
		}
		
		/**
		 * Add a new object to grid on click
		 * @param	event
		 */
		override protected function onClickHandler(event:MouseEvent):void 
		{		
			if(!getQualifiedClassName(event.target).match("infoButton"))
			{
				if (FLAG_inactive) return;
				
				if (MainGameClass.getInstance.gameMap.FLAG_unfixedPlaceableOnGrid)
				{
					if(!MainGameClass.getInstance.gameMap.FLAG_moving) MainGameClass.getInstance.removePlaceableObject(true);
				}
				else MainGameClass.getInstance.addPlaceableObject(typeId);
			}
			else
			{
				showBuildingInfo();
			}
			
			Framework.unlockButtons();
		}
		
		override protected function onButtonDownHandler(event:MouseEvent):void 
		{
			if (FLAG_inactive) return;
			
			super.onButtonDownHandler(event);
		}
		
		override protected function onButtonUpHandler(event:MouseEvent):void 
		{
			if (FLAG_inactive) return;
			
			super.onButtonUpHandler(event);
		}
		
		static public function get WIDTH():Number { return _WIDTH; }
		
		static public function set WIDTH(value:Number):void 
		{
			_WIDTH = value;
		}
		
		static public function get HEIGHT():Number { return _HEIGHT; }
		
		static public function set HEIGHT(value:Number):void 
		{
			_HEIGHT = value;
		}
		
		public function get typeId():int { return _typeId; }
		
		public function set typeId(value:int):void 
		{
			_typeId = value;
		}
		
		public function get objectSettings():Object { return _objectSettings; }
		
		public function set objectSettings(value:Object):void 
		{
			_objectSettings = value;
		}
		
		public function get itemGraphics():MovieClip { return _itemGraphics; }
		
		public function set itemGraphics(value:MovieClip):void 
		{
			_itemGraphics = value;
		}
		
	}

}