package pl.fabrykagier.eduFarma.gameInterface 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.UserData;
	
	/**
	 * Upper hud bar.
	 * @author Andrzej Kaczor
	 */
	public class Hud extends MovieClip
	{
		private var timerText:TextField;
		private var moneyText:TextField;
		
		/**
		 * Constructor. Sets the values in dynamic text fields.
		 */
		public function Hud()
		{
			// get and update the timer and money amount text fields
			//timerText = TextField(this.getChildByName("timeCounter"));
			//this.mouseEnabled = true;
			this.mouseChildren = true;			
			
			moneyText = TextField(this.getChildByName("moneyCounter"));
			
			moneyText.text = UserData.getInstance.money.toString();
						
			UserData.getInstance.addEventListener(GameEvent.MONEY_UPDATE, updateMoney);
			
			this.addEventListener(MouseEvent.ROLL_OVER, mouseOverHandler);
			this.addEventListener(MouseEvent.ROLL_OUT, mouseOutHandler);
			
			this.addEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
		}
		
		private function removedFromStageHandler(e:Event):void 
		{
			removeEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
			
			this.removeEventListener(MouseEvent.ROLL_OVER, mouseOverHandler);
			this.removeEventListener(MouseEvent.ROLL_OUT, mouseOutHandler);
		}
		
		private function mouseOutHandler(e:MouseEvent):void 
		{
			MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = false;
		}
		
		private function mouseOverHandler(e:MouseEvent):void 
		{
			MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = true;
		}
		
		/**
		 * Called when the amount of money has changed. Updates the value in the money amount text field.
		 * @param	e
		 */
		private function updateMoney(e:GameEvent):void
		{
			moneyText.text = UserData.getInstance.money.toString();
		}
		
		/**
		 * Update the timer text field with the time specified by the timeLeft parameter.
		 * @param	timeLeft - the time, in seconds, which should be displayed in the text field
		 */
		public function updateRoundTimer(timeLeft:int,timeTotal:int):void
		{
			MovieClip(MovieClip(this.getChildByName("timeCounter")).getChildByName("clockMask")).gotoAndStop(61 - Math.round((timeLeft / timeTotal) * 60));
		}
		
	}

}