﻿package pl.fabrykagier.eduFarma.gameInterface 
{
	import flash.display.FrameLabel;
	import flash.display.MovieClip;
	import flash.utils.getDefinitionByName;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	import pl.fabrykagier.engines.tEngine.PlaceableObject;
	import flash.events.Event;
	
	/**
	 * The building's status icon. Indicates actions currently taking place in a building.
	 * @author Andrzej Kaczor
	 */
	public class StatusIcon extends MovieClip
	{
		private var face:MovieClip;
		private var FLAG_progressIcon:Boolean = false;
		
		/**
		 * Constructor. Sets the initial status graphic to "idle".
		 */
		public function StatusIcon() 
		{
			this.addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);			
		}
		
		private function addedToStageHandler(e:Event):void
		{
			this.removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			
			face = new iconIdle();
			this.addChild(face);
		}
		
		/**
		 * Set the appearance of the status icon.
		 * @param	status - a string value representing the building's status
		 */
		public function setStatus(status:String):void
		{
			// remove the previous status graphic
			this.removeChild(face);
			FLAG_progressIcon = false;
			
			switch(status)
			{
				case "idle":
				{
					face = new iconIdle();
					break;
				}
				case "progress":
				{
					face = new iconProgress();
					FLAG_progressIcon = true;
					break;
				}
				case "ready":
				{
					face = new iconDone();
					FLAG_progressIcon = true;
					MovieClip(face["icon"]).addChild(MovieClip(new (getDefinitionByName(GameSettings.PRODUCTS[PlaceableObject(this.parent.parent).objectSpecificContent.outputProduct].productIcon + "_small") as Class)()));
					break;
				}
				case "rotting":
				{
					face = new iconDone();
					MovieClip(face["icon"]).addChild(MovieClip(new (getDefinitionByName(GameSettings.PRODUCTS[PlaceableObject(this.parent.parent).objectSpecificContent.outputProduct].productIcon + "_small") as Class)()));
					break;
				}
				case "rotten":
				{
					face = new iconRotten();
					break;
				}
				case "building":
				{
					face = new iconBuilding();
					FLAG_progressIcon = true;
					break;
				}
			}
			
			this.addChild(face);
		}
				
		/**
		 * If the status icon is a progress icon, this updates it's current status.
		 * @param	percent - the progress
		 */
		public function update(percent:int):void
		{
			if (FLAG_progressIcon)
			{
				face.gotoAndStop(percent);
			}
		}
	}

}