package pl.fabrykagier.eduFarma.gameInterface 
{
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.popups.BalloonTooltip;
	import pl.fabrykagier.framework.display.buttons.GotoButton;
	import pl.fabrykagier.framework.main.Framework;
	/**
	 * ...
	 * @author Andrzej Kaczor
	 */
	public class TooltipButton extends GotoButton
	{
		private var tooltip:BalloonTooltip;
		private var FLAG_clicked:Boolean = false;
		
		public function TooltipButton() 
		{
			
		}
		
		override protected function onButtonOverHandler(event:MouseEvent):void 
		{
			super.onButtonOverHandler(event);
			
			tooltip = new balloonTooltip();
					
			var rect:Rectangle = this.getBounds(this.parent);
			var coords:Point = new Point(rect.left + rect.width / 2, rect.topLeft.y);
			
			tooltip.fixedPosition(coords.x, coords.y);		
			
			this.parent.addChild(tooltip);
			if(this.name == "call_showMarketplace$lockEnabled_false$") tooltip.show("Rynek");
			else if(this.name == "call_showWarehouse$lockEnabled_false$") tooltip.show("Magazyny");
			else if(this.name.match("call_infoPopup")) tooltip.show("Info");
		}
		
		override protected function onButtonOutHandler(event:MouseEvent):void 
		{
			super.onButtonOutHandler(event);
			
			if (tooltip)
			{
				tooltip.hide();
				tooltip = null;
			}
		}
		
		override protected function onClickHandler(event:MouseEvent):void 
		{
			if(!this.name.match("call_infoPopup")) MainGameClass.getInstance.sendCloseCommand();
						
			FLAG_clicked = true;
			
			if(this.name.match("call_infoPopup")) super.onClickHandler(event);
		}
		
		override protected function onRemoved():void 
		{
			super.onRemoved();
			
			if (FLAG_clicked)
			{
				if (this.name == "call_showWarehouse$lockEnabled_false$")
				{
					Framework.instance.callRegisteredFunction("showWarehouse");
				}
				else if (this.name == "call_showMarketplace$lockEnabled_false$")
				{
					Framework.instance.callRegisteredFunction("showMarketplace");
				}
			}
			
			FLAG_clicked = false;
		}
		
	}

}