package pl.fabrykagier.eduFarma.main 
{
	import flash.events.MouseEvent;
	import pl.fabrykagier.framework.display.buttons.GotoButton;
	
	/**
	 * A button which is active only in build game mode.
	 * @author Andrzej Kaczor
	 */
	public class BuildModeButton extends GotoButton
	{
		private var FLAG_lock:Boolean = false;
		
		/**
		 * Constructor. Checks the current game mode and lock or unlocks the buttons based on game mode.
		 */
		public function BuildModeButton() 
		{
			super();
			
			if (GameSettings.GAME_MODE == "game mode")
			{
				FLAG_lock = true;
				this.alpha = 0.5;
			}
			
			// Listen to an event telling to lock all the build buttons
			GameEvent.dispatcher.addEventListener(GameEvent.GAME_MODE_CHANGE, lockBuildButtons);
		}
		
		/**
		 * Called upon removal from display list. Clears listeners.
		 */
		override protected function onRemoved():void 
		{
			super.onRemoved();
			
			GameEvent.dispatcher.removeEventListener(GameEvent.GAME_MODE_CHANGE, lockBuildButtons);
		}
		
		/**
		 * Called when the game mode changes. Lock or unlock the build mode buttons.
		 * @param	e
		 */
		private function lockBuildButtons(e:GameEvent):void 
		{
			if (GameSettings.GAME_MODE == "game mode")
			{
				FLAG_lock = true;
				this.alpha = 0.5;
			}
			else
			{
				FLAG_lock = false;
				this.alpha = 1;
			}
		}
		
		// Prevents the base class event listeners from being called if the button is currenlty locked
		
		override protected function onClickHandler(event:MouseEvent):void 
		{
			if(!FLAG_lock) super.onClickHandler(event);
		}
		
		override protected function onButtonDownHandler(event:MouseEvent):void 
		{
			if(!FLAG_lock) super.onButtonDownHandler(event);
		}
		
		override protected function onButtonUpHandler(event:MouseEvent):void 
		{
			if(!FLAG_lock) super.onButtonUpHandler(event);
		}
		
		override protected function onButtonOverHandler(event:MouseEvent):void 
		{
			if(!FLAG_lock) super.onButtonOverHandler(event);
		}
		
		override protected function onButtonOutHandler(event:MouseEvent):void 
		{
			if(!FLAG_lock) super.onButtonOutHandler(event);
		}
		
	}

}