package pl.fabrykagier.eduFarma.main 
{
	import flash.events.Event;
	import flash.events.EventDispatcher;
	
	/**
	 * Holds event descriptions used throughout the game and a static dispatcher
	 * @author Andrzej Kaczor
	 */
	public final class GameEvent extends Event
	{
		private var _parameters:Object;
		public static var dispatcher:EventDispatcher = new EventDispatcher();
		
		/**
		 * Game mode has changed
		 */
		public static const GAME_MODE_CHANGE:String = "gameModeChange";
		
		/**
		 * Show the build menu with building list
		 */ 
		public static const SHOW_BUILDING_LIST:String = "showBuildingList";
		
		/**
		 * Close any in-game windows that are currently opened
		 */ 
		public static const CLOSE_OPEN_WINDOWS:String = "closeOpenWindows";
		
		/**
		 * Change the types of buildings on the buildings list according to the clicked tab
		 */ 
		public static const BUILDING_TAB_CHANGE:String = "buildingTabChange";
		
		/**
		 * Unhighlight inactive tabs
		 */ 
		public static const TAB_CHANGE:String = "tabChange";
		
		/**
		 * Stop TweenLite animation which scrolls the buildings list
		 */ 
		public static const STOP_SCROLLING:String = "stopScrolling";
		
		/**
		 * User's money amount has changed
		 */ 
		public static const MONEY_UPDATE:String = "moneyUpdate";
		
		/**
		 * Remove outline from other items on list
		 */ 
		public static const UNGLOW_ITEMS:String = "unglowItems";
		
		/**
		 * Process has ended
		 */ 
		public static const PROCESS_END:String = "processEnd";
		
		/**
		 *  If there's an open popup - update it's content
		 */ 
		public static const UPDATE_POPUP:String = "updatePopup";
		
		
		public static const GAME_START:String = "gameStart";
		
		
		public static const SIMULATION_START:String = "simulationStart";
				
		public static const TIME_SYNC:String = "timeSynchronisation";
		
		public static const ITEM_SELECTED:String = "itemSelected";
		
		public static const ITEM_DESELECTED:String = "itemDeselected";
		
		public static const YES_NO_RESPONSE:String = "yesNoResponse";
		public static const LOCK_RIGHT_ARROW:String = "lockRightArrow";
		public static const LOCK_LEFT_ARROW:String = "lockLeftArrow";
		public static const UNLOCK_ARROW:String = "unlockArrow";
		public static const END_GAME:String = "endGame";
		
		/**
		 * Create a new GameEvent.
		 * @param	type - type of event.
		 * @param	parameters - parameters to be passed to the listening function.
		 * @param	bubbles
		 * @param	cancelable
		 */
		public function GameEvent(type:String, parameters:Object=null, bubbles:Boolean = false, cancelable:Boolean = false)
		{
			super(type, bubbles, cancelable);
			this._parameters = parameters;	
		}			
		
		/**
		 * Get the parameters passed with the event object.
		 */
		public function get parameters():Object { return _parameters; }
	}

}