package pl.fabrykagier.eduFarma.main 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.utils.clearTimeout;
	import flash.utils.getQualifiedClassName;
	import flash.utils.getQualifiedSuperclassName;
	import flash.utils.setTimeout;
	import pl.fabrykagier.eduFarma.gameData.StructureData;
	import pl.fabrykagier.eduFarma.gameData.Warehouse;
	import pl.fabrykagier.eduFarma.gameInterface.BuildingList;
	import pl.fabrykagier.engines.tEngine.ObjectParser;
	import pl.fabrykagier.engines.tEngine.PlaceableObject;
	import pl.fabrykagier.engines.tEngine.TileEngine;
	import pl.fabrykagier.framework.main.Framework;
	import pl.fabrykagier.framework.media.sounds.SoundManager;
	import tileEngine.tiles.BGTile;
	import tileEngine.tiles.curvePathTile;
	import tileEngine.tiles.endFenceTile;
	import tileEngine.tiles.endPathTile;
	import tileEngine.tiles.fourCrossPathTile;
	import tileEngine.tiles.gateCenter;
	import tileEngine.tiles.gateLeft;
	import tileEngine.tiles.gateRight;
	import tileEngine.tiles.horizontalFenceTile;
	import tileEngine.tiles.lowerCornerFenceTile;
	import tileEngine.tiles.straightPathTile;
	import tileEngine.tiles.threeCrossPathTile;
	import tileEngine.tiles.tileHighliter;
	import tileEngine.tiles.upperCornerFenceTile;
	import tileEngine.tiles.verticalFenceTile;
	
	/**
	 * Custom tile engine class, extends TileEngine functionalities.
	 * @author Andrzej Kaczor
	 */
	public class GameMap extends TileEngine
	{
		private var passPlaceable:PlaceableObject;
		
		/**
		 * Class constructor.
		 */
		public function GameMap() 
		{				
			super();
			
			// Listen for an event informing of a game mode change
			GameEvent.dispatcher.addEventListener(GameEvent.GAME_MODE_CHANGE, lockBuildButtons);
		}
		
		override protected function addedToStageHandler(e:Event):void 
		{
			topLayer = MovieClip(MainGameClass.getInstance);
			
			super.addedToStageHandler(e);
		}
		
		/**
		 * Called upon removal of this object
		 * @see TileEngine#removedFromStageHandler
		 * @param	e
		 */
		override protected function removedFromStageHandler(e:Event):void 
		{
			super.removedFromStageHandler(e);
			
			GameEvent.dispatcher.removeEventListener(GameEvent.GAME_MODE_CHANGE, lockBuildButtons);
		}
		
		public function addGrid():void
		{
			addDebugGrid();
			setDisplayOrder();
		}
		
		public function removeGrid():void
		{
			removeDebugGrid();
			setDisplayOrder();
		}
		
		/**
		 * Locks the build buttons if game is in game mode or unlocks them if it is in build mode
		 * @param	e
		 */
		private function lockBuildButtons(e:GameEvent):void 
		{			
			if (GameSettings.GAME_MODE == "game mode")
			{
				FLAG_lockGridScrolling = false;
			}
			else
			{
				//FLAG_lockGridScrolling = true;
			}
		}
		
		override protected function mouseMoveHandler(e:MouseEvent):void 
		{
			super.mouseMoveHandler(e);
			
			if (GameSettings.GAME_MODE == GameSettings.BUILDMODE && FLAG_gridScrolled)
			{
				MainGameClass.getInstance.hideTooltip();
			}
		}
			
		/**
		 * @see TileEngine#mouseUpHandler
		 * @param	e
		 */
		override protected function mouseUpHandler(e:MouseEvent):void 
		{			
			if (FLAG_blockMouseActions) return;
			
			var placing:Boolean = false;
			if (FLAG_unfixedPlaceableOnGrid) placing = true;
			
			if (!FLAG_gridScrolled && !placing && !getQualifiedClassName(e.target.parent).match("PlaceableObject") && !getQualifiedSuperclassName(e.target).match("Button") && !FLAG_blockMouseActions) MainGameClass.getInstance.sendCloseCommand();
						
			super.mouseUpHandler(e);
			
			if (selectedPlaceable && selectedPlaceable.objectSpecificContent && selectedPlaceable.objectSettings["type"] == "storage")
			{
				Warehouse(selectedPlaceable.objectSpecificContent).currentID = selectedPlaceable.ID;
			}
			
			// If the object under mouse has just been added to stage and hasn't been placed yet
			if (placing && !FLAG_unfixedPlaceableOnGrid)
			{				
				if (!selectedPlaceable.objectSpecificContent)
				{
					// If the object isn't a warehouse
					if (selectedPlaceable.objectSettings["type"] != "storage")
					{
						// Create a regular building information object
						selectedPlaceable.objectSpecificContent = new StructureData();
					}
					// and if it is a warehouse
					else
					{
						// Check if an information object for this type of warehouse already exists
						var warehouse:Warehouse = UserData.getInstance.getWarehouse(selectedPlaceable.objectSettings["inputType"]);
						
						// If it does
						if (warehouse)
						{
							// Set the information object of this particular warehouse to the one existing
							selectedPlaceable.objectSpecificContent = warehouse;
							warehouse.currentID = selectedPlaceable.ID;
							//warehouse.expandFreeSpace(int(selectedPlaceable.objectSettings["capacityLevel1"]));
						}
						// and if not
						else
						{
							// Create a new warehouse information object
							warehouse = new Warehouse(selectedPlaceable.objectSettings["inputType"]);
							selectedPlaceable.objectSpecificContent = warehouse;
							warehouse.currentID = selectedPlaceable.ID;
							UserData.getInstance.addWarehouse(selectedPlaceable.objectSettings["inputType"], warehouse);
						}
					}
				
					// Set the necessary building info parsed form the xml configuration file
					
					StructureData(selectedPlaceable.objectSpecificContent).structureReference = selectedPlaceable;
					StructureData(selectedPlaceable.objectSpecificContent).typeId = selectedPlaceable.objectSettings["typeId"];
										
					if (selectedPlaceable.objectSettings["type"] != "storage")
					{					
						StructureData(selectedPlaceable.objectSpecificContent).structureLevel = 0;
						StructureData(selectedPlaceable.objectSpecificContent).upgradeCost = selectedPlaceable.objectSettings["costLevel2"];
						StructureData(selectedPlaceable.objectSpecificContent).capacity = int(selectedPlaceable.objectSettings["capacity"]);
						StructureData(selectedPlaceable.objectSpecificContent).unitProductionTime = Number(selectedPlaceable.objectSettings["productionTime1"]);
						StructureData(selectedPlaceable.objectSpecificContent).unitProductionCost = Number(selectedPlaceable.objectSettings["productionCost1"]);
						StructureData(selectedPlaceable.objectSpecificContent).inputProduct = String(selectedPlaceable.objectSettings["inputProduct"]);
						StructureData(selectedPlaceable.objectSpecificContent).inputProductAmount = Number(selectedPlaceable.objectSettings["inputProductAmount"]);
						StructureData(selectedPlaceable.objectSpecificContent).outputProduct = String(selectedPlaceable.objectSettings["outputProduct"]);
						StructureData(selectedPlaceable.objectSpecificContent).outputType = String(selectedPlaceable.objectSettings["outputType"]);
						StructureData(selectedPlaceable.objectSpecificContent).inputType = String(selectedPlaceable.objectSettings["inputType"]);
						StructureData(selectedPlaceable.objectSpecificContent).storageTime = int(selectedPlaceable.objectSettings["storageTime"]);
						StructureData(selectedPlaceable.objectSpecificContent).storageTimeLeft = int(selectedPlaceable.objectSettings["storageTime"]);
												
						MainGameClass.getInstance.communicator.setExtensionCallback(setStructureID,"setBuildingData");
						MainGameClass.getInstance.communicator.callExtension("buildingsExt",
																			 "setBuildingData",
																			 { typeId:selectedPlaceable.objectSpecificContent.typeId,
																			   structureId:selectedPlaceable.ID,
																			   x:selectedPlaceable.positionOnGridX,
																			   y:selectedPlaceable.positionOnGridY,
																			   level:1,
																			   userId:UserData.getInstance.userDbID
																			 });
					}
					else
					{
						Warehouse(selectedPlaceable.objectSpecificContent).structureLevel = 0;
						Warehouse(selectedPlaceable.objectSpecificContent).upgradeCost = selectedPlaceable.objectSettings["costLevel2"];
						//Warehouse(selectedPlaceable.objectSpecificContent).capacity += int(selectedPlaceable.objectSettings["capacityLevel1"]);
						//Warehouse(selectedPlaceable.objectSpecificContent).freeSpace += int(selectedPlaceable.objectSettings["capacityLevel1"]);
						Warehouse(selectedPlaceable.objectSpecificContent).storageType = String(selectedPlaceable.objectSettings["inputType"]);
						
						MainGameClass.getInstance.communicator.setExtensionCallback(setStructureID,"setBuildingData");
						MainGameClass.getInstance.communicator.callExtension("buildingsExt",
																			 "setBuildingData",
																			 { typeId:selectedPlaceable.objectSpecificContent.typeId,
																			   structureId:selectedPlaceable.ID,
																			   x:selectedPlaceable.positionOnGridX,
																			   y:selectedPlaceable.positionOnGridY,
																			   level:1,
																			   userId:UserData.getInstance.userDbID
																			 });
					}
										
					// Start an upgrade process from level 0 to 1 so the building doesn't just "appear" on the game grid
					StructureGraphics(selectedPlaceable.objectFace).setStatus("construction");
					MainGameClass.getInstance.startProcess("upgrade");
				}
				else
				{
					MainGameClass.getInstance.communicator.callExtension("buildingsExt",
																		 "updateBuildingData",																		 
																		 { dbId:selectedPlaceable.objectSpecificContent.dbID,
																		   x:selectedPlaceable.positionOnGridX,
																		   y:selectedPlaceable.positionOnGridY,
																		   userId:UserData.getInstance.userDbID
																		 });
				}
				
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.SHOW_BUILDING_LIST));
				
				SoundManager.instance.playSound({name:"buildingPlaced", group:"sound", duplicate:true});
			}			
			
			if (selectedPlaceable && selectedPlaceable.objectSpecificContent && selectedPlaceable.objectFace.currentLabel == "construction") 
			{
				unselectObject();
			}
			
			// If the game is in build mode and a PlaceableObject was clicked, show a build mode balloon tooltip and hide any existing tooltips
			if (GameSettings.GAME_MODE == GameSettings.BUILDMODE)
			{				
				if (selectedPlaceable && !placing && selectedPlaceable.objectSpecificContent && !StructureData(selectedPlaceable.objectSpecificContent).FLAG_upgrading)
				{
					MainGameClass.getInstance.addBuildTooltip(selectedPlaceable);
				}
				else if(!placing)
				{
					MainGameClass.getInstance.hideTooltip();
					unselectObject();
				}
			}
			// And if the game is in game mode - show the building description popup
			else
			{
				MainGameClass.getInstance.hideTooltip();
				if (selectedPlaceable)
				{
					if (selectedPlaceable.objectSpecificContent.FLAG_ready)
					{
						MainGameClass.getInstance.sendToWarehouse();
						unselectObject();
					}
					else if (selectedPlaceable.objectSpecificContent.FLAG_rotten)
					{
						MainGameClass.getInstance.removeRottenProducts();
						unselectObject();
					}
					else if (selectedPlaceable.objectFace.currentLabel != "construction")
					{
						MainGameClass.getInstance.showBuildingDescriptionPopup(selectedPlaceable);
					}					
				}
				//unselectObject();
			}
			
			MainGameClass.getInstance.hideOptionsTooltip();
			
			// Unlock the buttons if a building has just been placed on game grid
			if (!FLAG_unfixedPlaceableOnGrid && placing)
			{
				Framework.unlockButtons();
				
				if (MainGameClass.getInstance.cloudsClip) foregroundLayer.addChild(MainGameClass.getInstance.cloudsClip);
				
				if (selectedPlaceable && selectedPlaceable.objectSpecificContent && selectedPlaceable.objectSpecificContent.FLAG_producing)
				{
					selectedPlaceable.objectFace.setStatus("progress");
					selectedPlaceable.objectFace.statusIcon.setStatus("progress");
				}
				
				MainGameClass.getInstance.buildingList.mouseEnabled = true;
				MainGameClass.getInstance.buildingList.mouseChildren = true;
			}
		}		
		
		public function setStructureID(response:Object):void
		{
			trace("DBID: ", response.db);
			
			if (placeableVector[response.structureId].objectSettings["type"] == "storage")
			{
				Warehouse(placeableVector[response.structureId].objectSpecificContent).dbID = response.db;
			}
			else
			{
				StructureData(placeableVector[response.structureId].objectSpecificContent).dbID = response.db;
			}
		}
		
	}

}