package pl.fabrykagier.eduFarma.main 
{
	import flash.display.Bitmap;
	import flash.display.FrameLabel;
	import flash.display.MovieClip;
	import flash.display.Shape;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.utils.getQualifiedClassName;
	import flash.utils.getQualifiedSuperclassName;
	import pl.fabrykagier.eduFarma.gameInterface.StatusIcon;
	import pl.fabrykagier.engines.tEngine.PlaceableObject;
	import pl.fabrykagier.framework.media.sounds.SoundManager;
	
	/**
	 * Holds the graphic representing a building and it's status icon.
	 * @author Andrzej Kaczor
	 */
	public class StructureGraphics extends MovieClip
	{
		public static var FLAG_statusVisible:Boolean = false;
		public var isWarehouse:Boolean = false;
		public var isRotten:Boolean = false;
		private var _statusIcon:StatusIcon = null;
		private var animLength:int = 0;
		private var firstFrame:int;
		private var lastFrame:int;
		private var state:String;
		
		/**
		 * Constructor.
		 */
		public function StructureGraphics()
		{
			mouseChildren = false;
			this.addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			this.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHandler);
			this.addEventListener(MouseEvent.MOUSE_OUT, mouseOutHandler);
		}
		
		private function mouseOutHandler(e:MouseEvent):void 
		{
			if (getQualifiedSuperclassName(this.getChildAt(this.numChildren - 2)).match("MovieClip"))
			{
				var object:String = getQualifiedClassName(this);
								
				if (object.match("placeableButterfactory")) SoundManager.instance.pauseSound( { name:"productionButterfactory" } );
				else if (object.match("placeableChickencoop")) SoundManager.instance.pauseSound( { name:"productionChickencoop"} );
				else if (object.match("placeableCowshed")) SoundManager.instance.pauseSound( { name:"productionCowshed"} );
				else if (object.match("placeableFrozenfactory")) SoundManager.instance.pauseSound( { name:"productionFrozenfactory"} );
				else if (object.match("placeableJuicefactory")) SoundManager.instance.pauseSound( { name:"productionJuicefactory"} );
				else if (object.match("placeableJamfactory")) SoundManager.instance.pauseSound( { name:"productionJamfactory"} );
				else if (object.match("placeableWindmill")) SoundManager.instance.pauseSound( { name:"productionWindmill"} );
				
				if (int(PlaceableObject(this.parent).objectSettings["typeId"]) == 30 ||
					int(PlaceableObject(this.parent).objectSettings["typeId"]) == 6 ||
					int(PlaceableObject(this.parent).objectSettings["typeId"]) == 28 ||
					int(PlaceableObject(this.parent).objectSettings["typeId"]) == 15 ||
					int(PlaceableObject(this.parent).objectSettings["typeId"]) == 24 ||
					int(PlaceableObject(this.parent).objectSettings["typeId"]) == 21 ||
					int(PlaceableObject(this.parent).objectSettings["typeId"]) == 27 ||
					int(PlaceableObject(this.parent).objectSettings["typeId"]) == 23 ||
					int(PlaceableObject(this.parent).objectSettings["typeId"]) == 22 ||
					int(PlaceableObject(this.parent).objectSettings["typeId"]) == 19 )
				{
					SoundManager.instance.pauseSound( { name:"productionFog"} );
				}
			}
		}
		
		private function mouseOverHandler(e:MouseEvent):void 
		{
			if(state == "progress")
			{
				if (getQualifiedSuperclassName(this.getChildAt(this.numChildren - 2)).match("MovieClip"))
				{
					var object:String = getQualifiedClassName(this);
									
					if (object.match("placeableButterfactory")) SoundManager.instance.playSound( { name:"productionButterfactory", group:"sound", duplicate:true } );
					else if (object.match("placeableChickencoop")) SoundManager.instance.playSound( { name:"productionChickencoop", group:"sound", duplicate:true } );
					else if (object.match("placeableCowshed")) SoundManager.instance.playSound( { name:"productionCowshed", group:"sound", duplicate:true } );
					else if (object.match("placeableFrozenfactory")) SoundManager.instance.playSound( { name:"productionFrozenfactory", group:"sound", duplicate:true } );
					else if (object.match("placeableJuicefactory")) SoundManager.instance.playSound( { name:"productionJuicefactory", group:"sound", duplicate:true } );
					else if (object.match("placeableJamfactory")) SoundManager.instance.playSound( { name:"productionJamfactory", group:"sound", duplicate:true } );
					else if (object.match("placeableWindmill")) SoundManager.instance.playSound( { name:"productionWindmill", group:"sound", duplicate:true } );
					
					if (int(PlaceableObject(this.parent).objectSettings["typeId"]) == 30 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 6 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 28 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 15 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 24 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 21 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 27 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 23 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 22 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 19 )
					{
						SoundManager.instance.playSound( { name:"productionFog", group:"sound", duplicate:true } );
					}
				}					
			}
		}
		
		/**
		 * Called when this object has been added to the display list.
		 * @param	e
		 */
		private function addedToStageHandler(e:Event):void 
		{			
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			this.parent.addEventListener("placeableReady", addStatusIcon);
		}
		
		/**
		 * Adds the status icon of the building when it has been set in place on grid.
		 * @param	e
		 */
		public function addStatusIcon(e:Event=null):void 
		{			
			this.removeEventListener("placeableReady", addStatusIcon);
			
			// create the status icon
			if (statusIcon) 
			{
				if (statusIcon.parent) statusIcon.parent.removeChild(statusIcon);
				statusIcon = null;
			}
			
			statusIcon = new StatusIcon();
			statusIcon.visible = FLAG_statusVisible;
			
			// place it in the upper right corner of the building graphic
			statusIcon.x = this.width - statusIcon.width;
			statusIcon.y = this.getBounds(this).y;
			this.addChild(statusIcon);
		}		
		
		public function setStatus(status:String):void
		{				
			this.state = "";
			
			switch(status)
			{
				case "idle":
				{
					if (getQualifiedSuperclassName(this.getChildAt(this.numChildren - 2)).match("MovieClip"))
					{
						if (!isRotten) MovieClip(this.getChildAt(this.numChildren - 2)).gotoAndStop("idle");
						else MovieClip(this.getChildAt(this.numChildren - 2)).gotoAndPlay("removeRotten");
						
						isRotten = false;
					}
					
					if (isWarehouse) statusIcon.visible = false;
					
					break;
				}
				case "construction":
				{
					this.gotoAndStop("construction");
					
					if (int(PlaceableObject(this.parent).objectSettings["typeId"]) == 15 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 32 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 16 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 17 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 18 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 19 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 20 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 21 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 4 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 22 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 11 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 23 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 2 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 24 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 25 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 26 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 27 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 28 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 6 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 29 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 30 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 10 ||
						int(PlaceableObject(this.parent).objectSettings["typeId"]) == 7)
					{
						SoundManager.instance.playSound( { name:"constructionBuildings", group:"sound", duplicate:true } );
					}
					else
					{
						if (int(PlaceableObject(this.parent).objectSettings["typeId"]) == 9 ||
							int(PlaceableObject(this.parent).objectSettings["typeId"]) == 8 ||
							int(PlaceableObject(this.parent).objectSettings["typeId"]) == 3 )
						{					
							SoundManager.instance.playSound( { name:"constructionFieldsTractor", group:"sound", duplicate:true } );
						}
						
						if (int(PlaceableObject(this.parent).objectSettings["typeId"]) == 5 ||
							int(PlaceableObject(this.parent).objectSettings["typeId"]) == 9 ||
							int(PlaceableObject(this.parent).objectSettings["typeId"]) == 8 ||
							int(PlaceableObject(this.parent).objectSettings["typeId"]) == 3 )
						{					
							SoundManager.instance.playSound( { name:"constructionFieldsWater", group:"sound", duplicate:true } );
						}
					}
					
					if (isWarehouse) statusIcon.visible = true;
					
					break;
				}
				case "progress":
				{
					this.state = "progress"
					
					if (getQualifiedSuperclassName(this.getChildAt(this.numChildren - 2)).match("MovieClip"))
					{
						var object:String = getQualifiedClassName(this);
												
						if (object.match("placeableField") || object.match("placeableGreenhouse") || object.match("placeableSunflowerfield") || object.match("placeableVegfield") || object.match("placeableOrchard"))
						{
							MovieClip(this.getChildAt(this.numChildren - 2)).gotoAndStop("production");
							
							var labels:Array = MovieClip(this.getChildAt(this.numChildren - 2)).currentLabels;
													
							for each (var frameLabel:FrameLabel in labels)
							{
								if (frameLabel.name == "production") firstFrame = frameLabel.frame;
								else if (frameLabel.name == "finish") 
								{
									lastFrame = frameLabel.frame;
									break;
								}
							}
							
							animLength = lastFrame - firstFrame;
						}
						else
						{
							MovieClip(this.getChildAt(this.numChildren - 2)).gotoAndPlay("production");
							
							if (object.match("placeableButterfactory")) SoundManager.instance.playSound( { name:"productionButterfactory", group:"sound", duplicate:true } );
							else if (object.match("placeableChickencoop")) SoundManager.instance.playSound( { name:"productionChickencoop", group:"sound", duplicate:true } );
							else if (object.match("placeableCowshed")) SoundManager.instance.playSound( { name:"productionCowshed", group:"sound", duplicate:true } );
							else if (object.match("placeableFrozenfactory")) SoundManager.instance.playSound( { name:"productionFrozenfactory", group:"sound", duplicate:true } );
							else if (object.match("placeableJuicefactory")) SoundManager.instance.playSound( { name:"productionJuicefactory", group:"sound", duplicate:true } );
							else if (object.match("placeableJamfactory")) SoundManager.instance.playSound( { name:"productionJamfactory", group:"sound", duplicate:true } );
							else if (object.match("placeableWindmill")) SoundManager.instance.playSound( { name:"productionWindmill", group:"sound", duplicate:true } );
							
							if (int(PlaceableObject(this.parent).objectSettings["typeId"]) == 30 ||
								int(PlaceableObject(this.parent).objectSettings["typeId"]) == 6 ||
								int(PlaceableObject(this.parent).objectSettings["typeId"]) == 28 ||
								int(PlaceableObject(this.parent).objectSettings["typeId"]) == 15 ||
								int(PlaceableObject(this.parent).objectSettings["typeId"]) == 24 ||
								int(PlaceableObject(this.parent).objectSettings["typeId"]) == 21 ||
								int(PlaceableObject(this.parent).objectSettings["typeId"]) == 27 ||
								int(PlaceableObject(this.parent).objectSettings["typeId"]) == 23 ||
								int(PlaceableObject(this.parent).objectSettings["typeId"]) == 22 ||
								int(PlaceableObject(this.parent).objectSettings["typeId"]) == 19 )
							{
								SoundManager.instance.playSound( { name:"productionFog", group:"sound", duplicate:true } );
							}
						}
					}
					
					break;
				}
				case "ready":
				{
					object = getQualifiedClassName(this);
					
					if (!object.match("placeableOrchard") &&
						!object.match("placeableVegfield") &&
						!object.match("placeableSunflowerfield") &&
						!object.match("placeableField"))
					{
						SoundManager.instance.playSound( { name:"finishProductsAppear", group:"sound", duplicate:true } );
					}
					
					if (getQualifiedSuperclassName(this.getChildAt(this.numChildren - 2)).match("MovieClip"))
					{
						MovieClip(this.getChildAt(this.numChildren - 2)).gotoAndPlay("finish");
					}
					break;
				}
				case "rotten":
				{
					if (getQualifiedSuperclassName(this.getChildAt(this.numChildren - 2)).match("MovieClip"))
					{
						var clip:MovieClip = MovieClip(this.getChildAt(this.numChildren - 2));
						
						var limiter:int = clip.currentLabels.length;
						
						for (var i:int = 0; i < limiter; i++)
						{
							if (FrameLabel(clip.currentLabels[i]).name == "rotten")
							{
								clip.gotoAndPlay("rotten");
								break;
							}
						}		
						
					}
					break;
				}
			}
			
			this.addChildAt(statusIcon,this.numChildren-1);
		}
		
		public function update(prc:int):void
		{
			if (animLength > 0)
			{
				MovieClip(this.getChildAt(this.numChildren - 2)).gotoAndStop(Math.round(firstFrame + (prc * animLength)/100));
			}
		}
		
		/**
		 * Get the graphic object representing the building.
		 * @return
		 */
		public function getBitmap():Shape
		{
			return Shape(this.getChildAt(0));
		}
		
		/**
		 * Get the status icon reference.
		 */
		public function get statusIcon():StatusIcon { return _statusIcon; }
		
		/**
		 * Set the status icon reference.
		 */
		public function set statusIcon(value:StatusIcon):void 
		{
			_statusIcon = value;
		}
	}

}