package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TextEvent;
	import flash.text.TextField;
	import flash.utils.getDefinitionByName;
	import pl.fabrykagier.eduFarma.gameData.StructureData;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.UserData;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * Popup containing information about a building in the game. Allows launching of building functions.
	 * This popup appears after clicking on a building while in game mode.
	 * @author Andrzej Kaczor
	 */
	public class BuildingDescriptionPopup extends PopupBase
	{
		private var increaseInputButton:MovieClip;
		private var decreaseInputButton:MovieClip;
		private var increaseOutputButton:MovieClip;
		private var decreaseOutputButton:MovieClip;
		private var productionAmountField:TextField;
		private var verifyPattern:RegExp = /([0-9])/
		private var storedParams:Array;
		private var frameCount:int = 0;
		private var divider:int = 10;
		
		/**
		 * Constructor.
		 */
		public function BuildingDescriptionPopup() 
		{			
			super(false);			
			
			MainGameClass.getInstance.currentProductionAmount = 0;
						
			increaseInputButton = MovieClip(container.getChildByName("increaseInputAmount"));
			decreaseInputButton = MovieClip(container.getChildByName("decreaseInputAmount"));
			
			increaseOutputButton = MovieClip(container.getChildByName("increaseOutputAmount"));
			decreaseOutputButton = MovieClip(container.getChildByName("decreaseOutputAmount"));
			
			increaseInputButton.buttonMode = true;
			decreaseInputButton.buttonMode = true;
			
			increaseOutputButton.buttonMode = true;
			decreaseOutputButton.buttonMode = true;
			
			increaseInputButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			decreaseInputButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);	
			increaseInputButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			decreaseInputButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			increaseInputButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			decreaseInputButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			
			increaseOutputButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			decreaseOutputButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);	
			increaseOutputButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			decreaseOutputButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			increaseOutputButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			decreaseOutputButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);		
		}
		
		private function startValueChange(e:MouseEvent):void 
		{
			if (e.currentTarget.name == "increaseInputAmount") this.addEventListener(Event.ENTER_FRAME, increaseAmountHandler);
			else if (e.currentTarget.name == "decreaseInputAmount") this.addEventListener(Event.ENTER_FRAME, decreaseAmountHandler);
			else if (e.currentTarget.name == "increaseOutputAmount") this.addEventListener(Event.ENTER_FRAME, increaseAmountHandler);
			else if (e.currentTarget.name == "decreaseOutputAmount") this.addEventListener(Event.ENTER_FRAME, decreaseAmountHandler);
		}
		
		private function stopValueChange(e:MouseEvent):void 
		{
			frameCount = 0;
			divider = 10;
			
			this.removeEventListener(Event.ENTER_FRAME, increaseAmountHandler);
			this.removeEventListener(Event.ENTER_FRAME, decreaseAmountHandler);
		}
		
		/**
		 * Called upon removal from display list. Clears listeners.
		 * @param	e
		 */
		override protected function removedFromStageHandler(e:Event):void 
		{
			super.removedFromStageHandler(e);
			//productionAmountField.removeEventListener(TextEvent.TEXT_INPUT, checkInput);			
			
			increaseInputButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			decreaseInputButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);	
			increaseInputButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			decreaseInputButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			increaseInputButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			decreaseInputButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			
			increaseOutputButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			decreaseOutputButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);	
			increaseOutputButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			decreaseOutputButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			increaseOutputButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			decreaseOutputButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			
			this.removeEventListener(Event.ENTER_FRAME, increaseAmountHandler);
			this.removeEventListener(Event.ENTER_FRAME, decreaseAmountHandler);
		}
		
		private function decreaseAmountHandler(e:Event):void 
		{
			var modifyTime:TextField;
			var modifyCost:TextField;
			var modifyAmount:TextField;
			var modifyPrice:TextField;
			var modifyProduct:TextField;
			var modifyInputWarehouseAmount:TextField;
			var modifyOutputWarehouseAmount:TextField;
			
			modifyTime = TextField(MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")).getChildByName("productionTime"));
			modifyCost = TextField(MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")).getChildByName("productionCost"));
			
			modifyCost.mouseEnabled = false;
			modifyTime.mouseEnabled = false;
			
			modifyPrice = TextField(container.getChildByName("inputCost"));
			modifyProduct = TextField(container.getChildByName("productionAmount"));
			modifyInputWarehouseAmount = TextField(container.getChildByName("inputWarehouseAmount"));
			modifyOutputWarehouseAmount = TextField(container.getChildByName("outputWarehouseAmount"));
			
			if (MainGameClass.getInstance.currentProductionAmount > 0)
			{
				if (frameCount % divider == 0)
				{
					MainGameClass.getInstance.currentProductionAmount--;
					
					divider -= 1;
					if (divider < 2) divider = 2;
				}
				
				var outputAmount:int = UserData.getInstance.getProductAmountInWarehouse(MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent.outputType, MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent.outputProduct);
				var outputModified:int = outputAmount + MainGameClass.getInstance.currentProductionAmount;
				
				var cost:int = UserData.getInstance.getProductAmountInWarehouse(MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent.inputType, MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent.inputProduct);
				var price:int = Math.ceil(MainGameClass.getInstance.currentProductionAmount * MainGameClass.getInstance.gameMap.selectedPlaceable.objectSettings["inputProductAmount"]);
				cost -= price;
								
				modifyProduct.text = String(MainGameClass.getInstance.currentProductionAmount);
				modifyPrice.text = price.toString();
				modifyInputWarehouseAmount.text = cost.toString();
				modifyOutputWarehouseAmount.text = outputModified.toString();
				
				var time:int = storedParams[9] * MainGameClass.getInstance.currentProductionAmount;
				modifyTime.text = (time / 60 < 10 ? "0": "") + Math.floor(time / 60).toString() + ":" + (time % 60 < 10 ? "0": "") + Math.floor(time % 60).toString();
				modifyCost.text = String(storedParams[8] * MainGameClass.getInstance.currentProductionAmount);				
			}
			
			frameCount++;
			
		}
		
		private function increaseAmountHandler(e:Event):void 
		{
			var modifyTime:TextField;
			var modifyCost:TextField;
			var modifyAmount:TextField;
			var modifyPrice:TextField;
			var modifyProduct:TextField;
			var modifyInputWarehouseAmount:TextField;
			var modifyOutputWarehouseAmount:TextField;
			
			modifyTime = TextField(MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")).getChildByName("productionTime"));
			modifyCost = TextField(MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")).getChildByName("productionCost"));
			
			modifyCost.mouseEnabled = false;
			modifyTime.mouseEnabled = false;
			
			modifyPrice = TextField(container.getChildByName("inputCost"));
			modifyProduct = TextField(container.getChildByName("productionAmount"));
			modifyInputWarehouseAmount = TextField(container.getChildByName("inputWarehouseAmount"));
			modifyOutputWarehouseAmount = TextField(container.getChildByName("outputWarehouseAmount"));
						
			if (frameCount % divider == 0)
			{
				MainGameClass.getInstance.currentProductionAmount++;
				
				divider -= 1;
				if (divider < 2) divider = 2;
			}
			
			var outputAmount:int = UserData.getInstance.getProductAmountInWarehouse(MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent.outputType, MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent.outputProduct);
			var outputModified:int = outputAmount + MainGameClass.getInstance.currentProductionAmount;
			
			var cost:int = UserData.getInstance.getProductAmountInWarehouse(MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent.inputType, MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent.inputProduct);
			var price:int = Math.ceil(MainGameClass.getInstance.currentProductionAmount * MainGameClass.getInstance.gameMap.selectedPlaceable.objectSettings["inputProductAmount"]);
			cost -= price;
				
			if (cost < 0)
			{
				MainGameClass.getInstance.currentProductionAmount--;
				return;
			}
			
			modifyProduct.text = String(MainGameClass.getInstance.currentProductionAmount);
			modifyPrice.text = price.toString();
			modifyInputWarehouseAmount.text = cost.toString();
			modifyOutputWarehouseAmount.text = outputModified.toString();
			
			var time:int = storedParams[9] * MainGameClass.getInstance.currentProductionAmount;
			modifyTime.text = (time / 60 < 10 ? "0": "") + Math.floor(time / 60).toString() + ":" + (time % 60 < 10 ? "0": "") + Math.floor(time % 60).toString();
			modifyCost.text = String(storedParams[8] * MainGameClass.getInstance.currentProductionAmount);				
					
			frameCount++;
		}
				
		public function setNormalOverlay():void
		{
			this.container.gotoAndStop("normal");
			
			populate(storedParams);
			
			increaseInputButton = MovieClip(container.getChildByName("increaseInputAmount"));
			decreaseInputButton = MovieClip(container.getChildByName("decreaseInputAmount"));
			
			increaseOutputButton = MovieClip(container.getChildByName("increaseOutputAmount"));
			decreaseOutputButton = MovieClip(container.getChildByName("decreaseOutputAmount"));
			
			increaseInputButton.buttonMode = true;
			decreaseInputButton.buttonMode = true;
			
			increaseOutputButton.buttonMode = true;
			decreaseOutputButton.buttonMode = true;
			
			increaseInputButton.addEventListener(MouseEvent.CLICK, increaseAmountHandler);
			decreaseInputButton.addEventListener(MouseEvent.CLICK, decreaseAmountHandler);
			
			increaseOutputButton.addEventListener(MouseEvent.CLICK, increaseAmountHandler);
			decreaseOutputButton.addEventListener(MouseEvent.CLICK, decreaseAmountHandler);
		}
		
		public function setNormal2Overlay():void
		{
			this.container.gotoAndStop("normal2");
			
			if(storedParams) populate(storedParams);			
		}
		
		public function setProductionOverlay():void
		{
			increaseInputButton.removeEventListener(MouseEvent.CLICK, increaseAmountHandler);
			decreaseInputButton.removeEventListener(MouseEvent.CLICK, decreaseAmountHandler);
			
			increaseOutputButton.removeEventListener(MouseEvent.CLICK, increaseAmountHandler);
			decreaseOutputButton.removeEventListener(MouseEvent.CLICK, decreaseAmountHandler);
			
			this.container.gotoAndStop("production");			
		}
		
		public function updateProductionStatus(prc:int, time:int, amount:int):void
		{
			if (this.container.currentLabel != "production") return;
			
			TextField(container.getChildByName("productionAmount")).text = amount.toString();
			TextField(container.getChildByName("outputName")).text = storedParams[15];
			TextField(container.getChildByName("productionInfo")).text = prc.toString() + "% - " + (time / 60 < 10 ? "0": "") + Math.floor(time / 60).toString() + " min " + (time % 60 < 10 ? "0": "") + Math.floor(time % 60).toString() + " s";
			
			MovieClip(container.getChildByName("productionProgress")).gotoAndStop(prc);
		}
		
		/**
		 * Fills the variable fields in the popup with data provided in the paramsVector
		 * @param	paramsVector - array of parameters
		 */
		public function populate(paramsVector:Array):void
		{						
			storedParams = paramsVector;
			
			// Icons
			
			var buildingIcon:MovieClip = MovieClip(new (getDefinitionByName(paramsVector[0]) as Class)());
			buildingIcon.gotoAndStop(paramsVector[18]);
			MovieClip(container.getChildByName("icon")).addChild(buildingIcon);
			if(MovieClip(container.getChildByName("inputIcon")) && paramsVector[1]) MovieClip(container.getChildByName("inputIcon")).addChild(new (getDefinitionByName(paramsVector[1]) as Class)());
			if(MovieClip(container.getChildByName("outputIcon"))) MovieClip(container.getChildByName("outputIcon")).addChild(new (getDefinitionByName(paramsVector[2]) as Class)());
			if(MovieClip(container.getChildByName("iconInput")) && paramsVector[3]) MovieClip(container.getChildByName("iconInput")).addChild(new Bitmap(BitmapData(new (getDefinitionByName(paramsVector[3]) as Class)())));
			MovieClip(container.getChildByName("iconOutput")).addChild(new Bitmap(BitmapData(new (getDefinitionByName(paramsVector[4]) as Class)())));
			
			// Text Fields
			
			TextField(container.getChildByName("buildingName")).text = paramsVector[5];
			if(TextField(container.getChildByName("inputAmount"))) TextField(container.getChildByName("inputAmount")).text = paramsVector[6];
			if(TextField(container.getChildByName("outputAmount"))) TextField(container.getChildByName("outputAmount")).text = paramsVector[7];
			if(TextField(container.getChildByName("itemCost"))) TextField(container.getChildByName("itemCost")).text = paramsVector[8];
			if(TextField(container.getChildByName("itemTime"))) TextField(container.getChildByName("itemTime")).text = paramsVector[9];
			if(TextField(container.getChildByName("inputName"))) TextField(container.getChildByName("inputName")).text = paramsVector[10];
			if (TextField(container.getChildByName("inputWarehouseAmount"))) TextField(container.getChildByName("inputWarehouseAmount")).text = paramsVector[11];
			if(TextField(container.getChildByName("inputCost"))) TextField(container.getChildByName("inputCost")).text = paramsVector[12];
			TextField(container.getChildByName("productionAmount")).text = paramsVector[13];
			
			MainGameClass.getInstance.currentProductionAmount = paramsVector[13];
			
			if(TextField(container.getChildByName("outputWarehouseAmount"))) TextField(container.getChildByName("outputWarehouseAmount")).text = paramsVector[14];
			TextField(container.getChildByName("outputName")).text = paramsVector[15];
			
			if (MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")))
			{
				TextField(MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")).getChildByName("productionCost")).mouseEnabled = false;
				TextField(MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")).getChildByName("productionTime")).mouseEnabled = false;
				
				TextField(MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")).getChildByName("productionCost")).text = (paramsVector[16]*paramsVector[13]).toString();
				TextField(MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")).getChildByName("productionTime")).text = ((paramsVector[17]*paramsVector[13]) / 60 < 10 ? "0": "") + Math.floor((paramsVector[17]*paramsVector[13]) / 60).toString() + ":" + ((paramsVector[17]*paramsVector[13]) % 60 < 10 ? "0": "") + Math.floor((paramsVector[17]*paramsVector[13]) % 60).toString();
			
				if (paramsVector[8] > UserData.getInstance.money || paramsVector[6] > paramsVector[11])
				{
					MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")).alpha = 0.3;
					MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")).mouseEnabled = false;
					MovieClip(container.getChildByName("call_startProcess$callParameter_production$lockEnabled_false$")).mouseChildren = false;
					
					increaseInputButton.mouseEnabled = false;
					increaseInputButton.mouseChildren = false;
					increaseInputButton.alpha = 0.3;
					decreaseInputButton.mouseEnabled = false;
					decreaseInputButton.mouseChildren = false;
					decreaseInputButton.alpha = 0.3;
					
					increaseOutputButton.mouseEnabled = false;
					increaseOutputButton.mouseChildren = false;
					increaseOutputButton.alpha = 0.3;
					decreaseOutputButton.mouseEnabled = false;
					decreaseOutputButton.mouseChildren = false;
					decreaseOutputButton.alpha = 0.3;
				}
			}
			
			var upgradeButton:MovieClip = MovieClip(container.getChildByName("upgradeClip"));
			
			if (upgradeButton)
			{
				if (MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent && MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent.structureLevel > 2)
				{
					upgradeButton.gotoAndStop(2);
				}
			}		
		}
		
		///**
		 //* Tests the chars typed into an input field against the regular expression pattern.
		 //* If the typed text is in order, this updates the production amount.
		 //* @param	e
		 //*/
		//private function checkInput(e:TextEvent):void 
		//{
			//if (!verifyPattern.test(e.text))
			//{
				//e.preventDefault();
			//}
			//else
			//{
				//MainGameClass.getInstance.currentProductionAmount = int(productionAmountField.text + e.text);
			//}
		//}
		
		/**
		 * Hide the popup.
		 * @param	e
		 */
		override public function hide(e:GameEvent = null):void 
		{
			if (e && this.parent.getChildIndex(this) < this.parent.numChildren-1) return;
			
			super.hide(e);
			
			MainGameClass.getInstance.gameMap.unselectObject()
		}
		
	}

}