package pl.fabrykagier.eduFarma.popups 
{
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.popups.ScrollableWindow;
	/**
	 * ...
	 * @author Andrzej Kaczor
	 */
	public class BuyingRoundPopup extends PopupBase
	{
		private var scrollList:ScrollableWindow;
		private var infoField:TextField;
		private var titleField:TextField;
		
		public var FLAG_moneyAnim:Boolean = false;
		public var FLAG_tooLong:Boolean = false;
		
		public function BuyingRoundPopup() 
		{
			super(false);
			
			scrollList = ScrollableWindow(container.getChildByName("scrollablesContainer"));
			infoField = TextField(container.getChildByName("infoText"));
			titleField = TextField(container.getChildByName("titleText"));
		}
		
		public function populate(params:*):void
		{
			if (params[0].length > 0)
			{							
				scrollList.populateItemList(params[0], "marketplace");
				scrollList.activate();
			}
		}
		
		override public function hide(e:GameEvent = null):void 
		{
			super.hide(e);
						
			if (e && e.parameters.allWindows) FLAG_tooLong = true;			
			
			if (!FLAG_tooLong)
			{			
				MainGameClass.getInstance.removeScreenBlock();
				
				if (FLAG_moneyAnim)
				{
					MainGameClass.getInstance.showMoneyAnim();
				}				
			}
		}
		
		override protected function hidden():void 
		{
			super.hidden();
			
			if(!FLAG_tooLong) MainGameClass.getInstance.showStatisticsPopup();
		}
	}
}