package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.popups.ScrollableWindow;
	/**
	 * ...
	 * @author Andrzej Kaczor
	 */
	public class ChartsPopup extends PopupBase
	{
		private var roundField:TextField;
		private var productNameField:TextField;
		private var nextRoundButton:MovieClip;
		private var previousRoundButton:MovieClip;
		private var frameCount:int = 0;
		private var divider:int = 10;
		private var scrollWindow:ScrollableWindow;
		private var iconClip:MovieClip;
		
		public function ChartsPopup() 
		{
			roundField = TextField(container.getChildByName("roundNumber"));
			
			productNameField = TextField(container.getChildByName("productName"));
			
			iconClip = MovieClip(container.getChildByName("icon"));
			
			scrollWindow = ScrollableWindow(container.getChildByName("scrollablesContainer"));
						
			nextRoundButton = MovieClip(container.getChildByName("nextRound"));
			previousRoundButton = MovieClip(container.getChildByName("previousRound"));
						
			nextRoundButton.buttonMode = true;
			previousRoundButton.buttonMode = true;
			
			nextRoundButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			previousRoundButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);	
			nextRoundButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			previousRoundButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			nextRoundButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			previousRoundButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
		}
		
		private function startValueChange(e:MouseEvent):void
		{
			if (e.currentTarget.name == "nextRound") this.addEventListener(Event.ENTER_FRAME, nextRoundHandler);
			else if (e.currentTarget.name == "previousRound") this.addEventListener(Event.ENTER_FRAME, previousRoundHandler);
			else if (e.currentTarget.name == "nextRound") this.addEventListener(Event.ENTER_FRAME, nextRoundHandler);
			else if (e.currentTarget.name == "previousRound") this.addEventListener(Event.ENTER_FRAME, previousRoundHandler);
		}
		
		private function previousRoundHandler(e:Event):void 
		{
			
		}
		
		private function nextRoundHandler(e:Event):void 
		{
			
		}
		
		private function stopValueChange(e:MouseEvent):void 
		{
			frameCount = 0;
			divider = 10;
			
			this.removeEventListener(Event.ENTER_FRAME, nextRoundHandler);
			this.removeEventListener(Event.ENTER_FRAME, previousRoundHandler);
			this.removeEventListener(Event.ENTER_FRAME, nextRoundHandler);
			this.removeEventListener(Event.ENTER_FRAME, previousRoundHandler);
		}
		
		override protected function removedFromStageHandler(e:Event):void 
		{
			super.removedFromStageHandler(e);
			
			this.removeEventListener(Event.ENTER_FRAME, nextRoundHandler);
			this.removeEventListener(Event.ENTER_FRAME, previousRoundHandler);
			this.removeEventListener(Event.ENTER_FRAME, nextRoundHandler);
			this.removeEventListener(Event.ENTER_FRAME, previousRoundHandler);
		}
		
		public function populate(params:Array):void
		{
			iconClip.addChild(params[0]);
			
			productNameField.text = String(params[1]);
			roundField.text = String(params[2]);
			
			scrollWindow.populateItemList(params[3]);
			scrollWindow.activate();
		}
		
	}

}