package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.Bitmap;
	import flash.display.MovieClip;
	import flash.text.TextField;
	import flash.utils.getDefinitionByName;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	
	/**
	 * A generic warning popup appearing when something goes wrong
	 * @author Andrzej Kaczor
	 */
	public class InfoPopup extends PopupBase
	{		
		
		
		public function InfoPopup() 
		{
			
		}
		
		/**
		 * Sets the warning text in the popup according to warningType
		 * @param	warningType - keyword for a warning type
		 */
		public function setInfo(params:Object,buildingType:String="production"):void
		{
			TextField(container.getChildByName("buildingName")).text = params.name;			
			TextField(container.getChildByName("buildingDescription")).text = params.description;
			TextField(container.getChildByName("price")).text = params.price;
			TextField(container.getChildByName("buildTime")).text = (int(params.buildTime) / 60 < 10 ? "0": "") + Math.floor(int(params.buildTime) / 60).toString() + ":" + (int(params.buildTime) % 60 < 10 ? "0": "") + Math.floor(int(params.buildTime) % 60).toString();
			
			if (buildingType == "production")
			{
				container.gotoAndStop("buildingInfoOneItem");			
			
				if (params.outputName && params.outputName != undefined) TextField(container.getChildByName("outputName")).text = params.outputName;
				
				var icon:MovieClip = MovieClip(new (getDefinitionByName(params.asset) as Class)());
				icon.gotoAndStop(1);
				
				MovieClip(container.getChildByName("buildingIcon")).addChild(icon);
				MovieClip(container.getChildByName("outputProductIcon")).addChild(new Bitmap((new (getDefinitionByName(params.outputAsset) as Class)())));
				
				MovieClip(container.getChildByName("warehouseIcon")).addChild(params.warehouseIcon);
				TextField(container.getChildByName("warehouseName")).text = params.warehouseName;
			}
			else if (buildingType == "process")
			{
				container.gotoAndStop("buildingInfo");			
			
				if (params.outputName && params.outputName != undefined)TextField(container.getChildByName("outputName")).text = params.outputName;
				if (params.inputName && params.inputName != undefined) TextField(container.getChildByName("inputName")).text = params.inputName;
				//else TextField(container.getChildByName("inputName")).visible = false;
				
				icon = MovieClip(new (getDefinitionByName(params.asset) as Class)());
				icon.gotoAndStop(1);
				
				MovieClip(container.getChildByName("buildingIcon")).addChild(icon);
				MovieClip(container.getChildByName("outputProductIcon")).addChild(new Bitmap((new (getDefinitionByName(params.outputAsset) as Class)())));
				if (params.inputAsset && params.inputAsset != undefined) MovieClip(container.getChildByName("inputProductIcon")).addChild(new Bitmap((new (getDefinitionByName(params.inputAsset) as Class)())));
				
				MovieClip(container.getChildByName("warehouseIcon")).addChild(params.warehouseIcon);
				TextField(container.getChildByName("warehouseName")).text = params.warehouseName;
			}
			else
			{
				container.gotoAndStop("buildingInfoWarehouse");
				
				icon = MovieClip(new (getDefinitionByName(params.asset) as Class)());
				icon.gotoAndStop(1);
				
				MovieClip(container.getChildByName("buildingIcon")).addChild(icon);
				
				var counter:int = 1;
				
				for each (var product:Object in GameSettings.PRODUCTS)
				{
					if (product.productType == params.inputType)
					{
						MovieClip(container["icon" + counter.toString()]).addChild(new (getDefinitionByName(product.productIcon + "_small") as Class)());
						
						counter++;
					}
				}
			}
		}
	}

}