package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.DisplayObject;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	
	/**
	 * Basic popup functionalities.
	 * @author Andrzej Kaczor
	 */
	public class PopupBase extends MovieClip
	{		
		private var closeNextWindow:Boolean = false;
		private var hideMe:Boolean = false;
		protected var container:MovieClip;
		protected var _popupID:int;
		public var popupBeneath:PopupBase = null;
		
		/**
		 * Constructor. If the "stopped" parameter is true the popup will be stopped at it's first frame and has to be launched manually.
		 * @param	stopped
		 */
		public function PopupBase(stopped:Boolean=false)
		{
			hideMe = false;
			
			if(MainGameClass.getInstance.gameMap) MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = true;
			
			this.mouseEnabled = true;
			this.mouseChildren = true;
			
			if (stopped) gotoAndStop(1);
			
			container = MovieClip(this.getChildByName("content"));
			
			GameEvent.dispatcher.addEventListener(GameEvent.CLOSE_OPEN_WINDOWS, hide);
			this.addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			this.addEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
			
			this.addEventListener(MouseEvent.MOUSE_DOWN, clickHandler);
		}
		
		private function clickHandler(e:MouseEvent):void 
		{
			if (e.target.name != "content" && !container.contains(DisplayObject(e.target))) MainGameClass.getInstance.sendCloseCommand();
		}
		
		private function addedToStageHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			if(MainGameClass.getInstance.gameMap) MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = true;
		}
		
		/**
		 * Called upon removal from display list. Removes listeners.
		 * @param e
		 */
		protected function removedFromStageHandler(e:Event):void 
		{
			removeEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
			GameEvent.dispatcher.removeEventListener(GameEvent.CLOSE_OPEN_WINDOWS, hide);
			
			this.removeEventListener(MouseEvent.CLICK, clickHandler);			
		}
		
		/**
		 * Show the popup.
		 */
		protected function show():void
		{
			gotoAndPlay(1);
		}
		
		/**
		 * Called when the popup appears on screen after slide-in animation.
		 */
		public function popupInPlace():void
		{
			if(MainGameClass.getInstance.gameMap) MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = true;
			
			this.mouseEnabled = true;
			this.mouseChildren = true;
			
			if (hideMe) hide();
		}
		
		/**
		 * Hide the popup which is currently on top of popup stack.
		 * Can be called either manually or by an event.
		 * @param	e
		 */
		public function hide(e:GameEvent=null):void
		{
			if (e && this.parent.getChildIndex(this) < this.parent.numChildren - 1) return;
			
			if (e && e.parameters.allWindows)
			{
				closeNextWindow = true;
			}
			
			play();
			
			hideMe = true;
		}
		
		/**
		 * Called on last frame of a popup animation, removes the popup from stage.
		 */
		protected function hidden():void
		{
			GameEvent.dispatcher.removeEventListener(GameEvent.CLOSE_OPEN_WINDOWS, hide);	
			
			if (!closeNextWindow && !popupBeneath) 
			{
				if(MainGameClass.getInstance.gameMap) MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = false;
			}
			MainGameClass.getInstance.popup = popupBeneath;
			
			if (closeNextWindow && popupBeneath) popupBeneath.hide();
			
			popupBeneath = null;			
			
			this.parent.removeChild(this);
		}
		
		public function get popupID():int { return _popupID; }
		
		public function set popupID(value:int):void 
		{
			_popupID = value;
		}
	}

}