package pl.fabrykagier.eduFarma.popups 
{
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.TextEvent;
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.engines.tEngine.EngineSettings;
	import pl.fabrykagier.framework.display.buttons.GotoButton;
	import pl.fabrykagier.framework.main.Framework;
	/**
	 * ...
	 * @author Andrzej Kaczor
	 */
	public class RegistrationPopup extends PopupBase 
	{
		//private var verifyPattern:RegExp = /^[a-zA-Z0-9]*$/;
		private var loginField:TextField;
		private var passwordField:TextField;
		private var repeatPasswordField:TextField;
		private var button:GotoButton;
		private var message:TextField;
		
		/**
		 * Popup used for registering new players
		 */
		public function RegistrationPopup() 
		{
			Framework.instance.registerFunction(registerUser, "registerUser");
			
			loginField = TextField(container.getChildByName("inputLogin"));
			passwordField = TextField(container.getChildByName("inputPassword"));
			repeatPasswordField = TextField(container.getChildByName("repeatPassword"));
			
			passwordField.restrict = "A-Za-z0-9._";
			loginField.restrict = "A-Za-z0-9._";
			repeatPasswordField.restrict = "A-Za-z0-9._";
			
			passwordField.visible = false;
			repeatPasswordField.visible = false;
			
			//loginField.addEventListener(TextEvent.TEXT_INPUT, checkInput);
			//passwordField.addEventListener(TextEvent.TEXT_INPUT, checkInput);
			//repeatPasswordField.addEventListener(TextEvent.TEXT_INPUT, checkInput);
			
			message = TextField(container.getChildByName("warning"));
			message.text = "";
			message.tabEnabled = false;
			
			MainGameClass.getInstance.stage.addEventListener(KeyboardEvent.KEY_UP, keyDownHandler);
			
			button = GotoButton(container.getChildByName("call_registerUser$lockEnabled_false$"));
			
			button.alpha = 0.3;
			button.mouseChildren = false;
			button.mouseEnabled = false;
		}
		
		override protected function removedFromStageHandler(e:Event):void 
		{
			super.removedFromStageHandler(e);
			
			MainGameClass.getInstance.stage.removeEventListener(KeyboardEvent.KEY_UP, keyDownHandler);
		}
		
		/**
		 * Called when keyboard key is pressed down
		 * @param	e
		 */
		private function keyDownHandler(e:KeyboardEvent):void 
		{
			if (e.target.name == "repeatPassword" && passwordField.text.length > 0)
			{
				if (passwordField.text == repeatPasswordField.text)
				{
					message.text = "Wprowadzone hasło jest poprawne.";
					message.textColor = 0x339933;		
					
					button.alpha = 1;
					button.mouseChildren = true;
					button.mouseEnabled = true;
				}
				else
				{
					message.text = "Wprowadzone hasło jest błędne.";
					message.textColor = 0xFF0000;
					
					button.alpha = 0.3;
					button.mouseChildren = false;
					button.mouseEnabled = false;
				}
			}
			else if (e.target.name == "inputLogin")
			{
				if (loginField.length > 0)
				{
					passwordField.visible = true;
					repeatPasswordField.visible = true;
				}
				else
				{
					passwordField.text = "";
					repeatPasswordField.text = "";
					
					passwordField.visible = false;
					repeatPasswordField.visible = false;
				}
			}
		}
		//
		//private function checkInput(e:TextEvent):void 
		//{
			//if (!verifyPattern.test(e.text))
			//{
				//e.preventDefault();
			//}
		//}
		
		/**
		 * Register a new user
		 */
		private function registerUser():void 
		{
			// Set the callback function to be called on extension response
			MainGameClass.getInstance.communicator.setExtensionCallback(registrationResult,"userRegistration");
			// Attempt to register with given username and password
			MainGameClass.getInstance.communicator.callExtension("usersExt", "userRegistration", {username:loginField.text, password:passwordField.text, cash:GameSettings.MONEY, fieldX:EngineSettings.GRID_WIDTH, fieldY:EngineSettings.GRID_HEIGHT});
		
			this.dispatchEvent(new Event("HIDE_REGISTRATION"));
		}
		
		/**
		 * A callback function called upon receiving a response from the users extension on server.
		 * @param	response - an object containing response parameters.
		 */
		private function registrationResult(response:Object):void 
		{
			if (response.success)
			{
				trace("Registration ok");
				MainGameClass.FLAG_firstRun = true;
				
				hide();
			}
			else
			{
				trace("Registration failed");
				message.text = "Podana nazwa użytkownika już istnieje.";
				message.textColor = 0xFF0000;
				
			}
		}
		
		
	}

}