package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	
	/**
	 * Popup used to remove items from warehouse.
	 * @author Andrzej Kaczor
	 */
	public class RemoveFromWarehousePopup extends PopupBase
	{
		private var amountField:TextField;
		private var warehouseAmountField:TextField;
		private var increaseAmountButton:MovieClip;
		private var decreaseAmountButton:MovieClip;
		private var frameCount:int = 0;
		private var divider:int = 10;
		private var removeAmount:int=0;
		private var warehouseAmount:int=0;
		
		public function RemoveFromWarehousePopup() 
		{
			super(false);
			
			MovieClip(container.getChildByName("call_doRemoveItem$lockEnabled_false$")).alpha = 0.3;
			MovieClip(container.getChildByName("call_doRemoveItem$lockEnabled_false$")).mouseEnabled = false;
			MovieClip(container.getChildByName("call_doRemoveItem$lockEnabled_false$")).mouseChildren = false;
						
			amountField = TextField(container.getChildByName("removeAmount"));
			
			warehouseAmountField = TextField(container.getChildByName("warehouseAmount"));
						
			increaseAmountButton = MovieClip(container.getChildByName("increaseAmount"));
			decreaseAmountButton = MovieClip(container.getChildByName("decreaseAmount"));
			
			increaseAmountButton.buttonMode = true;
			decreaseAmountButton.buttonMode = true;
			
			increaseAmountButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			decreaseAmountButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);	
			increaseAmountButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			decreaseAmountButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			increaseAmountButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			decreaseAmountButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
		}
		
		/**
		 * Sets the values used in the popup using paramsVector
		 * @param	paramsVector - array of parameters used by the popup
		 */
		public function populate(paramsVector:Array):void
		{
			MovieClip(container.getChildByName("itemIcon")).addChild(paramsVector[0]);
			
			warehouseAmount = paramsVector[1];
			warehouseAmountField.text = warehouseAmount.toString();
			
			amountField.text = "0";
		}
		
		/**
		 * Adds listeners used to change the value in text fields
		 * @param	e
		 */
		private function startValueChange(e:MouseEvent):void 
		{
			if (e.currentTarget.name == "increaseAmount") this.addEventListener(Event.ENTER_FRAME, increaseAmountHandler);
			else if (e.currentTarget.name == "decreaseAmount") this.addEventListener(Event.ENTER_FRAME, decreaseAmountHandler);
		}
		
		/**
		 * Stops the continuous value change
		 * @param	e
		 */
		private function stopValueChange(e:MouseEvent):void 
		{
			frameCount = 0;
			divider = 10;
			
			this.removeEventListener(Event.ENTER_FRAME, increaseAmountHandler);
			this.removeEventListener(Event.ENTER_FRAME, decreaseAmountHandler);
		}
		
		/**
		 * Decreases the value in amount field
		 * @param	e
		 */
		private function decreaseAmountHandler(e:Event):void 
		{
			if (removeAmount > 0)
			{
				removeAmount = int(amountField.text);
				if (frameCount % divider == 0) 
				{
					removeAmount--;
					divider -= 1;
					if (divider < 2) divider = 2;
					
					if (removeAmount == 0)
					{
						MovieClip(container.getChildByName("call_doRemoveItem$lockEnabled_false$")).alpha = 0.3;
						MovieClip(container.getChildByName("call_doRemoveItem$lockEnabled_false$")).mouseEnabled = false;
						MovieClip(container.getChildByName("call_doRemoveItem$lockEnabled_false$")).mouseChildren = false;
					}
				}
				amountField.text = String(removeAmount);
				warehouseAmountField.text = String(warehouseAmount - removeAmount);
				
				GameSettings.selectedItem.removeAmount = removeAmount;
			}			
			
			frameCount++;
		}
		
		/**
		 * Increases the value in amount text field
		 * @param	e
		 */
		private function increaseAmountHandler(e:Event):void 
		{
			if (removeAmount < GameSettings.selectedItem.amount)
			{
				removeAmount = int(amountField.text);
				if (frameCount % divider == 0)
				{
					removeAmount++;
					divider -= 1;
					if (divider < 2) divider = 2;
					
					if (removeAmount > 0)
					{
						MovieClip(container.getChildByName("call_doRemoveItem$lockEnabled_false$")).alpha = 1;
						MovieClip(container.getChildByName("call_doRemoveItem$lockEnabled_false$")).mouseEnabled = true;
						MovieClip(container.getChildByName("call_doRemoveItem$lockEnabled_false$")).mouseChildren = true;
					}
				}
				
				amountField.text = String(removeAmount);
				warehouseAmountField.text = String(warehouseAmount - removeAmount);			
				
				GameSettings.selectedItem.removeAmount = removeAmount;
			}
			
			frameCount++;
		}
		
		override protected function removedFromStageHandler(e:Event):void 
		{
			super.removedFromStageHandler(e);
			
			this.removeEventListener(Event.ENTER_FRAME, increaseAmountHandler);
			this.removeEventListener(Event.ENTER_FRAME, decreaseAmountHandler);
		}
		
		/**
		 * Called on last frame of popup animation
		 */
		override protected function hidden():void 
		{
			super.hidden();
			
			MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = true;
		}
		
	}

}