package pl.fabrykagier.eduFarma.popups 
{
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.framework.display.buttons.GotoButton;
	
	/**
	 * Buttons used to switch between rounds in statistics or round end popups
	 * @author Andrzej Kaczor
	 */
	public class RoundArrowsButton extends GotoButton 
	{
		
		public function RoundArrowsButton() 
		{
			GameEvent.dispatcher.addEventListener(GameEvent.LOCK_RIGHT_ARROW, lockRightArrow);
			GameEvent.dispatcher.addEventListener(GameEvent.LOCK_LEFT_ARROW, lockLeftArrow);
			GameEvent.dispatcher.addEventListener(GameEvent.UNLOCK_ARROW, unlockArrow);			
		}
		
		/**
		 * Disables the left arrow
		 * @param	e
		 */
		private function lockLeftArrow(e:GameEvent):void 
		{
			if (this.name.match("prev"))
			{
				this.alpha = 0.3;
				this.mouseEnabled = false;
				this.mouseChildren = false;
			}
		}
		
		/**
		 * Disables the right arrow
		 * @param	e
		 */
		private function lockRightArrow(e:GameEvent):void 
		{
			if (this.name.match("next"))
			{
				this.alpha = 0.3;
				this.mouseEnabled = false;
				this.mouseChildren = false;
			}
		}
		
		/**
		 * Enables the button
		 * @param	e
		 */
		private function unlockArrow(e:GameEvent):void
		{
			this.alpha = 1;
			this.mouseEnabled = true;
			this.mouseChildren = true;
		}
		
		override protected function onRemoved():void 
		{
			super.onRemoved();
			
			GameEvent.dispatcher.removeEventListener(GameEvent.LOCK_RIGHT_ARROW, lockRightArrow);
			GameEvent.dispatcher.removeEventListener(GameEvent.LOCK_LEFT_ARROW, lockLeftArrow);
		}
		
	}

}