package pl.fabrykagier.eduFarma.popups
{
	import com.greensock.TweenLite;
	import flash.display.Bitmap;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.text.Font;
	import flash.text.FontStyle;
	import flash.text.FontType;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.utils.getDefinitionByName;
	import flash.utils.getQualifiedClassName;
	import pl.fabrykagier.eduFarma.gameData.Product;
	import pl.fabrykagier.eduFarma.gameInterface.ProductStatsButton;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	import pl.fabrykagier.eduFarma.main.UserData;
	
	/**
	 * Scrollable items list.
	 * @author Andrzej Kaczor
	 */
	public class ScrollableWindow extends MovieClip
	{
		private static var singleItemWidth:Number = 529;
		private static var singleItemHeight:Number = 88;
		private static var horizontalMargin:Number = 4.5;
		private static var verticalMargin:Number = 4.5;
		
		private var sHead:MovieClip;
		private var maxTop:Number;
		private var maxBottom:Number;
		private var itemContainer:MovieClip;
		private var sLine:MovieClip;
		private var scrollState:int = 0;
		private var itemContainerOrigin:Number;
		private var windowHeight:Number;
		private var windowWidth:Number;		
		private var sArrowUp:MovieClip;
		private var sArrowDown:MovieClip;
		private var columns:int;
		private var rows:int;
				
		/**
		 * class constructor, gathers instances of objects
		 */
		public function ScrollableWindow() 
		{
			sHead = MovieClip(this.getChildByName("scrollHead"));			
			sLine = MovieClip(this.getChildByName("scrollLine"));
			sArrowUp = MovieClip(this.getChildByName("scrollUp"));
			sArrowDown = MovieClip(this.getChildByName("scrollDown"));
			itemContainer = MovieClip(this.getChildByName("iContainer"));
			itemContainerOrigin = itemContainer.y;
			
			windowHeight = this.getChildByName("itemMask").height;
			windowWidth = this.getChildByName("itemMask").width;
			
			maxTop = sLine.y + sHead.height/2;
			maxBottom = maxTop + sLine.height - sHead.height;		
			
			this.addEventListener(Event.REMOVED_FROM_STAGE, cleanUp);
		}
		
		/**
		 * clears listeners, vars, instances when the container is removed
		 * @param	e
		 */
		private function cleanUp(e:Event):void 
		{
			removeEventListener(Event.REMOVED_FROM_STAGE, cleanUp);
			clearItemList();
			deactivate();
		}
		
		/**
		 * activates the container by adding listeners, enabling interaction
		 */
		public function activate(force:Boolean=false):void
		{
			if (itemContainer.height > windowHeight || force)
			{
				sHead.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
				sHead.addEventListener(MouseEvent.ROLL_OVER, handleMouseOver);
				sHead.addEventListener(MouseEvent.ROLL_OUT, handleMouseOut);
				this.parent.parent.addEventListener(MouseEvent.MOUSE_UP, handleMouseUp);
				sLine.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
				this.addEventListener(MouseEvent.MOUSE_WHEEL, mouseWheelHandler);
				
				sArrowUp.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
				sArrowUp.addEventListener(MouseEvent.ROLL_OVER, handleMouseOver);
				sArrowUp.addEventListener(MouseEvent.ROLL_OUT, handleMouseOut);
				sArrowDown.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
				sArrowDown.addEventListener(MouseEvent.ROLL_OVER, handleMouseOver);
				sArrowDown.addEventListener(MouseEvent.ROLL_OUT, handleMouseOut);		
			
				sHead.buttonMode = true;
				sLine.buttonMode = true;
				sArrowUp.buttonMode = true;
				sArrowDown.buttonMode = true;
				
				sHead.gotoAndStop("active");
				sArrowUp.gotoAndStop("active");
				sArrowDown.gotoAndStop("active");
				
				sHead.alpha = 1;
				sArrowUp.alpha = 1;
				sArrowDown.alpha = 1;
				sLine.alpha = 1;
			}
			//else
			//{
				//sHead.gotoAndStop("inactive");
				//sArrowUp.gotoAndStop("inactive");
				//sArrowDown.gotoAndStop("inactive");
				//
				//sHead.alpha = 0.3;
				//sArrowUp.alpha = 0.3;
				//sArrowDown.alpha = 0.3;
				//sLine.alpha = 0.3;
			//}
		}
		
		/**
		 * deactivates the container by removing listeners, disabling interaction
		 */
		public function deactivate():void
		{
			sHead.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
			this.parent.parent.removeEventListener(MouseEvent.MOUSE_UP, handleMouseUp);
			sLine.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
			this.removeEventListener(MouseEvent.MOUSE_WHEEL, mouseWheelHandler);
			this.parent.parent.removeEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);
			
			sArrowUp.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
			sArrowUp.removeEventListener(MouseEvent.ROLL_OVER, handleMouseOver);
			sArrowUp.removeEventListener(MouseEvent.ROLL_OUT, handleMouseOut);
			sArrowDown.removeEventListener(MouseEvent.MOUSE_DOWN, handleMouseDown);
			sArrowDown.removeEventListener(MouseEvent.ROLL_OVER, handleMouseOver);
			sArrowDown.removeEventListener(MouseEvent.ROLL_OUT, handleMouseOut);
			
			this.parent.parent.addEventListener(Event.ENTER_FRAME, handleScrollUp);
			this.parent.parent.addEventListener(Event.ENTER_FRAME, handleScrollDown);
			
			sHead.buttonMode = false;
			sLine.buttonMode = false;
			sArrowUp.buttonMode = false;
			sArrowDown.buttonMode = false;
			
			sHead.gotoAndStop("inactive");
			sArrowUp.gotoAndStop("inactive");
			sArrowDown.gotoAndStop("inactive");
			
			sHead.alpha = 0.3;
			sArrowUp.alpha = 0.3;
			sArrowDown.alpha = 0.3;
			sLine.alpha = 0.3;
		}
		
		private function handleMouseOut(e:MouseEvent):void 
		{
			e.target.gotoAndStop("off");
			
			this.removeEventListener(Event.ENTER_FRAME, handleScrollUp);
			this.removeEventListener(Event.ENTER_FRAME, handleScrollDown);
		}
		
		private function handleMouseOver(e:MouseEvent):void 
		{
			e.target.gotoAndStop("on");
		}
		
		/**
		 * called when the mouse wheel has moved, scrolls the item list
		 * @param	e
		 */
		private function mouseWheelHandler(e:MouseEvent):void 
		{
			var movement:Number = e.delta;
			
			if (sHead.y - movement < maxTop) sHead.y = maxTop;
			else if (sHead.y - movement > maxBottom) sHead.y = maxBottom;
			else sHead.y -= movement;
			
			scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
			
			moveItemContainer(scrollState);
		}
		
		/**
		 * removes objects from item list
		 */
		public function clearItemList():void
		{
			var items:int = itemContainer.numChildren;
			
			for (var i:int = 0; i < items; i++)
			{
				if(getQualifiedClassName(itemContainer.getChildAt(0)).match("SingleItem")) SingleItem(itemContainer.getChildAt(0)).deactivate();
				itemContainer.removeChild(itemContainer.getChildAt(0));
			}
			
			moveItemContainer(0);
			sHead.y = maxTop;
		}
		
		/**
		 * populates the item list with new objects
		 * @param	items - a vector containing arrays which consist of two elements - object instance and it's class reference
		 * @param	itemGroup - the group od items to which the new item belongs
		 */
		public function populateItemList(items:*=null, itemGroup:String = ""):void
		{
			var itemAmount:int;
			
			if (itemGroup == "productStats")
			{
				singleItemWidth = 179;
				horizontalMargin = 0;
				verticalMargin = 0;
			}
			else
			{
				singleItemWidth = 529;
				horizontalMargin = 4.5;
				verticalMargin = 4.5;
			}
			
			if (items && items.length > 0)
			{
				itemAmount = items.length;			
			
				columns = Math.floor(windowWidth / (singleItemWidth + horizontalMargin));
				trace(columns, windowWidth / (singleItemWidth + horizontalMargin));
				columns = (itemAmount < columns ? itemAmount : columns);
				rows = Math.ceil(itemAmount / columns);
				var singleItem:MovieClip;
				
				var counter:int = 0;
				
				for (var i:int = 0; i < rows; i++)
				{
					for (var j:int = 0; j < columns; j++)
					{
						if (items.length - 1 < counter) break;
						
						if (itemGroup != "balance" && itemGroup != "statistics" && itemGroup != "text" && itemGroup != "productStats")
						{						
							singleItem = new SingleItemContainer();
							
							if (itemGroup == "warehouse") singleItem.gotoAndStop("warehouse");
							else if (itemGroup == "marketplace") singleItem.gotoAndStop("marketplace");
							
							if (items[counter].sold)
							{
								singleItem.gotoAndStop("marketplaceSold");
								SingleItem(singleItem).FLAG_unclickable = true;
								singleItem.mouseEnabled = false;
							}
							else if (items[counter].notSold) 
							{
								singleItem.gotoAndStop("marketplaceNotSold");
								SingleItem(singleItem).FLAG_unclickable = true;
								singleItem.mouseEnabled = false;
							}
							else if (items[counter].soldHeader)
							{
								singleItem.gotoAndStop("soldStatistics");
								SingleItem(singleItem).FLAG_unclickable = true;
								singleItem.mouseEnabled = false;
							}
							else if (items[counter].notSoldHeader) 
							{
								singleItem.gotoAndStop("notSoldStatistics");
								SingleItem(singleItem).FLAG_unclickable = true;
								singleItem.mouseEnabled = false;
							}
							else if (items[counter].roundNumber >= 0)
							{
								singleItem.gotoAndStop("round");
								SingleItem(singleItem).FLAG_unclickable = true;
								singleItem.mouseEnabled = false;
							}
																			
							singleItem.id = counter;
												
							var onMarketAmount:int = 0;
							var amount:int = 0;
							
							if (TextField(singleItem["roundNumber"])) TextField(singleItem["roundNumber"]).text = items[counter].roundNumber.toString();
							
							if (TextField(singleItem["transactionNumber"])) TextField(singleItem["transactionNumber"]).text = items[counter].transactionNumber.toString();
							if (TextField(singleItem["transactionProfit"])) TextField(singleItem["transactionProfit"]).text = items[counter].totalProfit.toString();
							
							if (singleItem["itemCounter"])
							{
								if (itemGroup.match("marketplace"))
								{
									TextField(singleItem["itemCounter"]).text = items[counter].amount.toString();
									amount = items[counter].amount;
								}
								else
								{
									if (!items[counter].onMarket)
									{
										TextField(singleItem["itemCounter"]).text = items[counter].amount.toString();
										amount = items[counter].amount;
									}
									else
									{
										TextField(singleItem["itemCounter"]).text = "0";
										onMarketAmount = items[counter].amount;
										amount = 0;
									}
								}
							}
							
							if (singleItem["marketplaceCounter"])
							{							
								var spliceIndexes:Array = [];
								
								for (var k:int = 0; k < items.length; k++)
								{
									if (k != counter && items[k].productId == items[counter].productId && items[k].onMarket)
									{
										onMarketAmount += items[k].amount;
										spliceIndexes.push(k);
									}
								}
								
								for (k = spliceIndexes.length - 1; k >= 0; k--)
								{
									items.splice(spliceIndexes[k], 1);
								}
								
								TextField(singleItem["marketplaceCounter"]).text = onMarketAmount.toString();
							}
							
							if (singleItem["totalCounter"]) TextField(singleItem["totalCounter"]).text = (amount + onMarketAmount).toString();												
							if (singleItem["singlePrice"]) TextField(singleItem["singlePrice"]).text = items[counter].price.toString();
							if (singleItem["totalPrice"]) TextField(singleItem["totalPrice"]).text = (items[counter].price * amount).toString();
							
							if (singleItem["icon"])
							{
								SingleItem(singleItem).product = items[counter];
								SingleItem(singleItem).setIcon(new Bitmap(new (getDefinitionByName(GameSettings.PRODUCTS[items[counter].product].productIcon) as Class)()));
							}
						}
						else if (itemGroup == "balance")
						{							
							singleItem = new BalanceItemContainer();
							singleItem.mouseEnabled = false;
							
							SingleItem(singleItem).FLAG_unclickable = true;
							
							var record:int = items[counter].length-1;
														
							TextField(singleItem["income"]).text = items[counter][record].income;
							TextField(singleItem["loan"]).text = items[counter][record].loan;
							TextField(singleItem["buildingsCost"]).text = items[counter][record].buildingsCost;
							TextField(singleItem["productionCost"]).text = items[counter][record].productionCost;
							TextField(singleItem["loanRate"]).text = items[counter][record].paidLoanRate;
							
							var balance:int = int(items[counter][record].income) + int(items[counter][record].loan) - int(items[counter][record].buildingsCost) - int(items[counter][record].expandCost) - int(items[counter][record].productionCost) - int(items[counter][record].paidLoanRate);
							
							TextField(singleItem["endBalance"]).text = balance.toString();
							TextField(singleItem["closeBalance"]).text = items[counter][record].money;
							TextField(singleItem["startBalance"]).text = (int(items[counter][record].money) - balance).toString();
							
							if (balance < 0) MovieClip(singleItem["endBalanceSign"]).gotoAndStop("minus");
							
							MovieClip(singleItem["graphContainer"]).addChild(items[counter + 1]);
							
							var rect:Rectangle = MovieClip(items[counter+1]).getBounds(MovieClip(singleItem["graphContainer"]));
							
							items[counter+1].y -= rect.top;
							items[counter+1].x -= rect.left;
							
							counter++;
						}
						else if (itemGroup == "statistics")
						{							
							singleItem = new ItemStatistics();
							
							MovieClip(singleItem["graphContainer"]).addChild(items[counter]);
							
							rect = MovieClip(items[counter]).getBounds(MovieClip(singleItem["graphContainer"]));
							
							items[counter].y -= rect.top;
							items[counter].x -= rect.left;
							
							TextField(singleItem["roundNumber"]).text = items[counter + 1].toString();
							
							MovieClip(singleItem["icon"]).addChild(items[counter+2])
							
							counter += 2;
						}
						else if (itemGroup == "text")
						{
							singleItem = new textItem();
							
							TextField(singleItem["content"]).text = items[counter];
														
							if (TextField(singleItem["content"]).textHeight > windowHeight)
							{
								MovieClip(singleItem["dumbFlashMagic"]).height = TextField(singleItem["content"]).textHeight;
								TextField(singleItem["content"]).height = TextField(singleItem["content"]).textHeight + 50;
								activate(true);
							}
						}
						else if (itemGroup == "productStats")
						{
							singleItem = new ProductStatisticsButton();
							TextField(singleItem["itemName"]).text = items[counter].name;
							MovieClip(singleItem["itemIcon"]).addChild(items[counter].icon);
							ProductStatsButton(singleItem).productId = int(items[counter].productId);
							
							singleItem.name = items[counter].name + "$lockEnabled_false$";
						}
						
						singleItem.x = j * singleItem.width + j * horizontalMargin;
						singleItem.y = i * singleItem.height + i * verticalMargin;
						
						itemContainer.addChild(singleItem);
						
						counter++;
					}
				}
			}
			
		}
		
		/**
		 * called when the mouse button is released, disables scrolling
		 * @param	e
		 */
		private function handleMouseUp(e:MouseEvent):void 
		{
			this.parent.parent.removeEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);
			this.removeEventListener(Event.ENTER_FRAME, handleScrollUp);
			this.removeEventListener(Event.ENTER_FRAME, handleScrollDown);
		}
		
		/**
		 * called when the mouse button is pressed, enables scrolling
		 * @param	e
		 */
		private function handleMouseDown(e:MouseEvent):void 
		{
			e.target.gotoAndStop("click");
						
			if (e.target.name == "scrollHead")
			{
				if (this.mouseY < maxTop) sHead.y = maxTop;
				else if (this.mouseY > maxBottom) sHead.y = maxBottom;
				else sHead.y = this.mouseY;
				
				scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
				
				moveItemContainer(scrollState);
				
				this.parent.parent.addEventListener(MouseEvent.MOUSE_MOVE, handleMouseMove);
			}
			else if (e.target.name == "scrollUp")
			{
				scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
				
				moveItemContainer(scrollState);
				
				this.addEventListener(Event.ENTER_FRAME, handleScrollUp);
			}
			else if (e.target.name == "scrollDown")
			{
				scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
				
				moveItemContainer(scrollState);
				
				this.addEventListener(Event.ENTER_FRAME, handleScrollDown);
			}
		}
		
		private function handleScrollDown(e:Event):void 
		{
			sHead.y += 2;
			
			if (sHead.y < maxTop) sHead.y = maxTop;
			else if (sHead.y > maxBottom) sHead.y = maxBottom;
			
			scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
			
			moveItemContainer(scrollState);
		}
		
		private function handleScrollUp(e:Event):void 
		{
			sHead.y -= 2;
			
			if (sHead.y < maxTop) sHead.y = maxTop;
			else if (sHead.y > maxBottom) sHead.y = maxBottom;
			
			scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
			
			moveItemContainer(scrollState);
		}
		
		/**
		 * called when the mouse has moved, updates the scrollbar and item list position
		 * @param	e
		 */
		private function handleMouseMove(e:MouseEvent):void
		{
			if (this.mouseY < maxTop) sHead.y = maxTop;
			else if (this.mouseY > maxBottom) sHead.y = maxBottom;
			else sHead.y = this.mouseY;
			
			scrollState = Math.floor(((sHead.y - maxTop)/ sLine.height) * 100);
			
			moveItemContainer(scrollState);
		}
		
		/**
		 * moves the item container to a new position
		 * @param	position - in percent, 0 - original position, 100 - fully scrolled down
		 */
		private function moveItemContainer(position:int):void
		{
			var translation:Number = itemContainerOrigin - ((itemContainer.height + rows*4.5) - windowHeight) * position / 100;
			
			TweenLite.killTweensOf(itemContainer);
			TweenLite.to(itemContainer, 0.3, { y:translation });
		}
		
		
		
	}

}