package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.events.TextEvent;
	import flash.text.TextField;
	import flash.utils.getDefinitionByName;
	import pl.fabrykagier.eduFarma.gameData.Product;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.UserData;
	import pl.fabrykagier.engines.tEngine.EngineSettings;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * An input popup in which the user can specify the amount and price of products which he wantes to put on market.
	 * @author Andrzej Kaczor
	 */
	public class SendToMarketplacePopup extends PopupBase
	{
		private var verifyPattern:RegExp = /([0-9])/
		private var amountField:TextField;
		private var priceField:TextField;
		private var sendAmount:int = 0;
		private var price:int = 0;
		private var increaseAmountButton:MovieClip;
		private var decreaseAmountButton:MovieClip;
		private var increasePriceButton:MovieClip;
		private var decreasePriceButton:MovieClip;
		private var frameCount:int = 0;
		private var divider:int = 10;
		private var incomeField:TextField;
		
		/**
		 * Constructor. Get the input fields references.
		 */
		public function SendToMarketplacePopup() 
		{
			super(false);
						
			MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).alpha = 0.3;
			MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseEnabled = false;
			MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseChildren = false;
			
			Framework.instance.registerFunction(sendProduct, "sendProduct");
			
			amountField = TextField(container.getChildByName("amount"));
			amountField.addEventListener(TextEvent.TEXT_INPUT, checkInput);
			
			priceField = TextField(container.getChildByName("price"));
			priceField.addEventListener(TextEvent.TEXT_INPUT, checkInput);
			
			MainGameClass.getInstance.stage.addEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
			
			incomeField = TextField(container.getChildByName("income"));
			
			increaseAmountButton = MovieClip(container.getChildByName("increaseAmount"));
			decreaseAmountButton = MovieClip(container.getChildByName("decreaseAmount"));
			
			increasePriceButton = MovieClip(container.getChildByName("increasePrice"));
			decreasePriceButton = MovieClip(container.getChildByName("decreasePrice"));
			
			increaseAmountButton.buttonMode = true;
			decreaseAmountButton.buttonMode = true;
			
			increasePriceButton.buttonMode = true;
			decreasePriceButton.buttonMode = true;
			
			increaseAmountButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			decreaseAmountButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);	
			increaseAmountButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			decreaseAmountButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			increaseAmountButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			decreaseAmountButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			
			increasePriceButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			decreasePriceButton.addEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			increasePriceButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			decreasePriceButton.addEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			increasePriceButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			decreasePriceButton.addEventListener(MouseEvent.ROLL_OUT, stopValueChange);
		}
		
		private function startValueChange(e:MouseEvent):void 
		{
			if (e.currentTarget.name == "increaseAmount") this.addEventListener(Event.ENTER_FRAME, increaseAmountHandler);
			else if (e.currentTarget.name == "decreaseAmount") this.addEventListener(Event.ENTER_FRAME, decreaseAmountHandler);
			else if (e.currentTarget.name == "increasePrice") this.addEventListener(Event.ENTER_FRAME, increasePriceHandler);
			else if (e.currentTarget.name == "decreasePrice") this.addEventListener(Event.ENTER_FRAME, decreasePriceHandler);
		}
		
		private function stopValueChange(e:MouseEvent):void 
		{
			frameCount = 0;
			divider = 10;
			
			this.removeEventListener(Event.ENTER_FRAME, increaseAmountHandler);
			this.removeEventListener(Event.ENTER_FRAME, decreaseAmountHandler);
			this.removeEventListener(Event.ENTER_FRAME, increasePriceHandler);
			this.removeEventListener(Event.ENTER_FRAME, decreasePriceHandler);
		}
		
		public function populate(type:String, product:String):void
		{
			MovieClip(container.getChildByName("inputProductIcon")).addChild(new (getDefinitionByName(GameSettings.PRODUCTS[product].productIcon + "_small") as Class)());
			
			var totalProductionCost:int = 0;
			
			for each (var object:Object in EngineSettings.PLACEABLE_SETTINGS)
			{
				if (object.objectSettings["outputProduct"] == product)
				{
					totalProductionCost = int(object.objectSettings["totalProductionCost"]);
					break;					
				}
			}
			
			TextField(container.getChildByName("productCost")).text = totalProductionCost.toString();
			
			priceField.text = totalProductionCost.toString();
			price = totalProductionCost;
			
			MovieClip(container.getChildByName("productIcon")).addChild(new Bitmap(BitmapData(new (getDefinitionByName(GameSettings.PRODUCTS[product].productIcon) as Class)())));
			
			TextField(container.getChildByName("warehouseAmount")).text = UserData.getInstance.getProductAmountInWarehouse(type, product).toString();
		}
		
		private function decreasePriceHandler(e:Event):void
		{
			if (price > 0)
			{
				price = int(priceField.text);
				if (frameCount % divider == 0)
				{
					price--;
					divider -= 1;
					if (divider < 2) divider = 2;
					
					if (price == 0)
					{
						MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).alpha = 0.3;
						MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseEnabled = false;
						MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseChildren = false;
					}
				}
				priceField.text = String(price);
				
				calculateIncome();
				//if(divider > 1) divider -= Math.ceil(((2800/divider)*(2800/divider)));
			}
			
			frameCount++;
		}
		
		private function increasePriceHandler(e:Event):void 
		{
			price = int(priceField.text);
			if (frameCount % divider == 0) 
			{
				price++;
				divider -= 1;
				if (divider < 2) divider = 2;
				
				if (sendAmount > 0 && price > 0)
				{
					MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).alpha = 1;
					MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseEnabled = true;
					MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseChildren = true;
				}
			}
			priceField.text = String(price);
			calculateIncome();
			//if(divider > 1) divider -= Math.ceil(((2800/divider)*(2800/divider)));
			
			frameCount++;
		}
		
		private function decreaseAmountHandler(e:Event):void 
		{
			if (sendAmount > 0)
			{
				sendAmount = int(amountField.text);
				if (frameCount % divider == 0) 
				{
					sendAmount--;
					divider -= 1;
					if (divider < 2) divider = 2;
					
					if (sendAmount == 0)
					{
						MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).alpha = 0.3;
						MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseEnabled = false;
						MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseChildren = false;
					}
				}
				amountField.text = String(sendAmount);
				
				calculateIncome();
				//if(divider > 1) divider -= Math.ceil(((2800/divider)*(2800/divider)));
			}			
			
			frameCount++;
		}
		
		private function increaseAmountHandler(e:Event):void 
		{
			if (sendAmount < GameSettings.selectedItem.amount)
			{
				sendAmount = int(amountField.text);
				if (frameCount % divider == 0)
				{
					sendAmount++;
					divider -= 1;
					if (divider < 2) divider = 2;
					
					if (sendAmount > 0 && price > 0)
					{
						MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).alpha = 1;
						MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseEnabled = true;
						MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseChildren = true;
					}
				}
				amountField.text = String(sendAmount);
				
				calculateIncome();
				
				//if(divider > 1) divider -= Math.ceil(((2800/divider)*(2800/divider)));
			}
			
			frameCount++;
		}
		
		private function calculateIncome():void
		{
			incomeField.text = Math.round(sendAmount * price).toString();
		}
		
		/**
		 * Called upon removal from display list. Removes listeners.
		 * @param	e
		 */
		override protected function removedFromStageHandler(e:Event):void 
		{
			super.removedFromStageHandler(e);
			stage.removeEventListener(KeyboardEvent.KEY_UP, keyUpHandler);
			
			priceField.removeEventListener(TextEvent.TEXT_INPUT, checkInput);
			amountField.removeEventListener(TextEvent.TEXT_INPUT, checkInput);
			
			increaseAmountButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			decreaseAmountButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);	
			increaseAmountButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			decreaseAmountButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			increaseAmountButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			decreaseAmountButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			
			increasePriceButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			decreasePriceButton.removeEventListener(MouseEvent.MOUSE_DOWN, startValueChange);
			increasePriceButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			decreasePriceButton.removeEventListener(MouseEvent.MOUSE_UP, stopValueChange);
			increasePriceButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			decreasePriceButton.removeEventListener(MouseEvent.ROLL_OUT, stopValueChange);
			
			this.removeEventListener(Event.ENTER_FRAME, increaseAmountHandler);
			this.removeEventListener(Event.ENTER_FRAME, decreaseAmountHandler);
			this.removeEventListener(Event.ENTER_FRAME, increasePriceHandler);
			this.removeEventListener(Event.ENTER_FRAME, decreasePriceHandler);
		}
		
		/**
		 * Send the previously selected product to marketplace. The product's amount and price are gathered from the input fields.
		 */
		private function sendProduct():void 
		{
			if (sendAmount > GameSettings.selectedItem.amount || sendAmount == 0) return;
			
			UserData.getInstance.removeFromWarehouse(GameSettings.selectedItem.type, GameSettings.selectedItem.product, sendAmount);
						
			var marketplaceProduct:Product = new Product(GameSettings.selectedItem.product,
														 GameSettings.selectedItem.productName,
														 GameSettings.selectedItem.productId,
														 GameSettings.selectedItem.type,
														 int(amountField.text),
														 int(priceField.text),
														 GameSettings.selectedItem.buildingId);
			
			UserData.getInstance.productToMarketplace(marketplaceProduct);
			//UserData.getInstance.storeInWarehouse(marketplaceProduct);
			
			// Inform the "parent" popup underneath that it should update it's data
			GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.UPDATE_POPUP));
					
			// hide the popup afterwards
			hide();
		}
		
		/**
		 * Check the typed chars against a regular expression pattern.
		 * @param	e
		 */
		private function checkInput(e:TextEvent):void 
		{
			if (!verifyPattern.test(e.text))
			{
				e.preventDefault();
				return;
			}		
		}
		
		private function keyUpHandler(e:KeyboardEvent):void 
		{
			if (e.target.name == "amount")
			{			
				if (parseInt(amountField.text) <= GameSettings.selectedItem.amount)
				{
					sendAmount = parseInt(amountField.text);
				}
				else
				{
					amountField.text = sendAmount.toString();
				}
			}
			else if (e.target.name == "price")
			{
				price = int(priceField.text);
			}
			
			if (sendAmount > 0 && price > 0)
			{
				MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).alpha = 1;
				MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseEnabled = true;
				MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseChildren = true;
			}
			else
			{
				MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).alpha = 0.3;
				MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseEnabled = false;
				MovieClip(container.getChildByName("call_sendProduct$lockEnabled_false$")).mouseChildren = false;
			}
			
			calculateIncome();
		}
		
		override protected function hidden():void 
		{
			super.hidden();
			
			MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = true;
		}
	}
		

}