package pl.fabrykagier.eduFarma.popups 
{
	import flash.display.Bitmap;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.GlowFilter;
	import pl.fabrykagier.eduFarma.gameData.Product;
	import pl.fabrykagier.eduFarma.gameData.Warehouse;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	
	/**
	 * An item container which resides in the scrollable item list
	 * @author Andrzej Kaczor
	 */
	public class SingleItem extends MovieClip
	{
		private var _itemClass:String = "";
		private var _id:int;
		private var glowFilter:GlowFilter = new GlowFilter(0xFFFFFF, 1, 10, 10, 10, 1, true);
		
		private var _product:Product;
		private var FLAG_selected:Boolean=false;
		public var FLAG_unclickable:Boolean=false;
				
		/**
		 * class constructor
		 */
		public function SingleItem() 
		{
			this.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			this.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			this.addEventListener(MouseEvent.MOUSE_OVER, mouseOverHandler);
			this.addEventListener(MouseEvent.MOUSE_OUT, mouseOutHandler);
			
			this.buttonMode = true;
			
			this.addEventListener(Event.REMOVED_FROM_STAGE, cleanUp);
		}		
		
		public function setIcon(icon:Bitmap):void
		{
			MovieClip(this.getChildByName("icon")).addChild(icon);
		}
		
		/**
		 * clears listeners when the item is removed
		 * @param	e
		 */
		private function cleanUp(e:Event):void 
		{
			if(FLAG_selected) GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.ITEM_DESELECTED));
			
			removeEventListener(Event.REMOVED_FROM_STAGE, cleanUp);
			GameEvent.dispatcher.removeEventListener(GameEvent.UNGLOW_ITEMS, unglow);
			unglow();
			deactivate();		
		}
		
		/**
		 * called when mouse pointer leaves the item area
		 * @param	e
		 */
		private function mouseOutHandler(e:MouseEvent):void 
		{
			
		}
		
		/**
		 * called when mouse pointer is over the item area
		 * @param	e
		 */
		private function mouseOverHandler(e:MouseEvent):void 
		{
			
		}
		
		/**
		 * called when the mouse button is pressed, adds a related object to the screenActions container
		 * @param	e
		 */
		private function mouseDownHandler(e:MouseEvent):void 
		{	
			if (FLAG_unclickable) return;
			
			if (!FLAG_selected)
			{
				FLAG_selected = true;
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.UNGLOW_ITEMS));
				glow();
				GameEvent.dispatcher.addEventListener(GameEvent.UNGLOW_ITEMS, unglow);
				
				GameSettings.selectedItem = product;
				
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.ITEM_SELECTED));
			}
			else
			{
				unglow();
				GameSettings.selectedItem = null;
				FLAG_selected = false;
				
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.ITEM_DESELECTED));
			}
		}
		
		/**
		 * called when the mouse button is released
		 * @param	e
		 */
		private function mouseUpHandler(e:MouseEvent):void 
		{
			
		}
		
		public function glow():void
		{
			this.filters = [glowFilter];
		}
		
		public function unglow(e:GameEvent=null):void
		{
			FLAG_selected = false;
			GameEvent.dispatcher.removeEventListener(GameEvent.UNGLOW_ITEMS, unglow);
			this.filters = [];
		}
		
		/**
		 * deactivates the item by removing listeners
		 */
		public function deactivate():void
		{
			this.removeEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			this.removeEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			this.removeEventListener(MouseEvent.MOUSE_OVER, mouseOverHandler);
			this.removeEventListener(MouseEvent.MOUSE_OUT, mouseOutHandler);
		}
		
		//////////////////// [ GETTER / SETTER SECTION ] //////////////////////////////////////////////////////////
		
		public function get itemClass():String { return _itemClass; }
		
		public function set itemClass(value:String):void 
		{
			_itemClass = value;
		}
		
		public function get id():int { return _id; }
		
		public function set id(value:int):void 
		{
			_id = value;
		}	
		
		public function get product():Product { return _product; }
		
		public function set product(value:Product):void 
		{
			_product = value;
		}
		
	}

}