package pl.fabrykagier.eduFarma.popups 
{
	import adobe.utils.CustomActions;
	import fl.motion.Color;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;
	import flash.text.TextField;
	import flash.utils.getDefinitionByName;
	import pl.fabrykagier.eduFarma.gameData.Product;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.UserData;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * Popup containing product and player statistic data.
	 * @author Andrzej Kaczor
	 */
	public class StatisticsPopup extends PopupBase
	{
		
		public var activeTab:String = "balance";
		private var scrollableWindow:ScrollableWindow;
		private var roundNumber:int = 0;
		private var offersArray:Array = null;
		private var displayedProduct:int;
		private var FLAG_productStatsFirst:Boolean = false;
		private var shownProductId:int;
		private var fakeLoader:MovieClip;
				
		public function StatisticsPopup() 
		{						
			MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = true;
			
			GameEvent.dispatcher.addEventListener(GameEvent.TAB_CHANGE, tabChangeHandler);
			
			// get the scrollable window instance
			scrollableWindow = ScrollableWindow(container.getChildByName("scrollablesContainer"));
			
			Framework.instance.registerFunction(previousRound, "prevRound");
			Framework.instance.registerFunction(nextRound, "nextRound");
			Framework.instance.registerFunction(previousRoundChart, "prevRoundChart");
			Framework.instance.registerFunction(nextRoundChart, "nextRoundChart");
			Framework.instance.registerFunction(backToStats, "backToStats");
		}
		
		/**
		 * Called through the "back" button in product statistics. Goes back to product choosing screen.
		 */
		private function backToStats():void 
		{
			populate("statistics");
		}
		
		/**
		 * Displays statistics for the next round
		 */		
		private function nextRound():void 
		{
			if (!offersArray) return;
			
			roundNumber++;		
			
			scrollableWindow.deactivate();
			scrollableWindow.clearItemList();
			
			displayOffers();
			
			if (roundNumber == MainGameClass.getInstance.currentRound-1)
			{
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.LOCK_RIGHT_ARROW));
			}
			else if (roundNumber == 2)
			{
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.UNLOCK_ARROW));
			}			
		}
		
		/**
		 * Displays statistics for the previous round
		 */
		private function previousRound():void 
		{
			if (!offersArray) return;
			
			roundNumber--;		
			
			scrollableWindow.deactivate();
			scrollableWindow.clearItemList();
			
			displayOffers();
			
			if (roundNumber == 1)
			{
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.LOCK_LEFT_ARROW));
			}
			else if (roundNumber == MainGameClass.getInstance.currentRound - 1)
			{
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.UNLOCK_ARROW));
			}
		}
		
		/**
		 * Displays product statistics for the next round
		 */
		private function nextRoundChart():void 
		{
			if (!offersArray) return;
			
			roundNumber++;		
			
			showProductGraph(displayedProduct);
			
			if (roundNumber == MainGameClass.getInstance.currentRound-1)
			{
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.LOCK_RIGHT_ARROW));
			}
			else if (roundNumber == 2)
			{
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.UNLOCK_ARROW));
			}
		}
		
		/**
		 * Displays product statistics for the previous round
		 */
		private function previousRoundChart():void 
		{
			if (!offersArray) return;
			
			roundNumber--;		
						
			showProductGraph(displayedProduct);
			
			if (roundNumber == 1)
			{
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.LOCK_LEFT_ARROW));
			}
			else if (roundNumber == MainGameClass.getInstance.currentRound - 1)
			{
				GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.UNLOCK_ARROW));
			}			
		}
		
		/**
		 * Called when one of the popup's tabs has been clicked
		 * @param	e
		 */
		private function tabChangeHandler(e:GameEvent):void 
		{
			if (String(e.parameters.tabName) == activeTab) return;
			
			switch(e.parameters.tabName)
			{
				case "balance":
				{
					activeTab = "balance";
					
					break;
				}
				case "round":
				{
					activeTab = "round";
					
					break;
				}
				case "statistics":
				{
					activeTab = "statistics";
					
					break;
				}
			}
			
			populate(activeTab);
		}
		
		/**
		 * Populates the scrollable window depending on the type of elements to display
		 * @param	type - type of content to display
		 * @param	pId - product id for direct product stats display
		 */
		public function populate(type:String, pId:int = -1):void
		{
			switch(type)
			{
				case "balance":
				{
					MainGameClass.getInstance.communicator.setExtensionCallback(getFinancesData,"getFinancesHistory");					
					MainGameClass.getInstance.communicator.callExtension("historyExt", "getFinancesHistory", {userId:UserData.getInstance.userDbID});
					
					activeTab = "balance"
					
					break;
				}
				case "round":
				{
					MainGameClass.getInstance.communicator.setExtensionCallback(getOfferData,"getOfferHistory");					
					MainGameClass.getInstance.communicator.callExtension("historyExt", "getOfferHistory", {userId:UserData.getInstance.userDbID, roomId:MainGameClass.getInstance.communicator.dbRoomId});
					
					activeTab = "round"
					
					break;
				}
				case "statistics":
				{
					MainGameClass.getInstance.communicator.setExtensionCallback(getStatisticsData,"getFullOfferHistory");					
					MainGameClass.getInstance.communicator.callExtension("historyExt", "getFullOfferHistory", {roomId:MainGameClass.getInstance.communicator.dbRoomId});
					
					activeTab = "statistics"
					
					break;
				}
				case "productStats":
				{
					MainGameClass.getInstance.communicator.setExtensionCallback(getStatisticsData,"getFullOfferHistory");					
					MainGameClass.getInstance.communicator.callExtension("historyExt", "getFullOfferHistory", {roomId:MainGameClass.getInstance.communicator.dbRoomId});
							
					activeTab = "statistics"
					
					FLAG_productStatsFirst = true;
					
					shownProductId = pId;
					
					break;
				}
			}
			
			GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.TAB_CHANGE, { tabName:(type == "productStats" ? "statistics" : type) } ));
					
			MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = true;
			
			scrollableWindow.clearItemList();
			
			fakeLoader = new miniPreloader();
			fakeLoader.x = container.width / 2;
			fakeLoader.y = container.height / 2 + 50;
			
			var glow:GlowFilter = new GlowFilter(0xFFFFFF, 1, 17, 17, 2);
			
			fakeLoader.filters = [glow];
			
			container.addChild(fakeLoader);
		}
		
		/**
		 * Called when a response from server has been received, containing financial history of the player. Displays the financial statistics.
		 * @param	params - object containing received data
		 */
		private function getFinancesData(params:Object):void 
		{
			if(fakeLoader && fakeLoader.parent) fakeLoader.parent.removeChild(fakeLoader);
			
			trace(params.finances);
			
			scrollableWindow.deactivate();
			scrollableWindow.clearItemList();
			
			if (params.finances == undefined) return;
						
			params.finances = (params.finances as Array).reverse();
			
			var highestRound:int = MainGameClass.getInstance.currentRound;
			
			var graphIntervals:Vector.<Object> = new Vector.<Object>();
			
			for (var i:int = highestRound-6; i < highestRound; i++)
			{
				graphIntervals.push( {start:i, stop:(i+1), income:0, expense:0 } );
			}
			
			var highestAmount:int = 0;
			
			for (i = 0; i < 6; i++)
			{
				for each (var finance:Object in params.finances)
				{
					if (int(finance.roundNumber) >= graphIntervals[i].start && int(finance.roundNumber) < graphIntervals[i].stop)
					{
						graphIntervals[i].income = int(finance.income) + int(finance.loan);
						graphIntervals[i].expense = int(finance.buildingsCost) + int(finance.expandCost) + int(finance.productionCost) + int(finance.paidLoanRate);
						
						if (graphIntervals[i].income > highestAmount) highestAmount = graphIntervals[i].income;
						if (graphIntervals[i].expense > highestAmount) highestAmount = graphIntervals[i].expense;
					}
				}
			}
			
			var graph:MovieClip = new PriceRoundChart();
			
			for (i = 0; i < 6; i++)
			{
				var xPoint:MovieClip = new ChartPointX();
				
				var graphBar1:MovieClip = new ChartBar();
				var graphBar2:MovieClip = new ChartBar();
				
				TextField(xPoint["value"]).text = graphIntervals[i].start.toString();
				xPoint.y = 0;
				xPoint.x = i * 33.3 + 5;
												
				graphBar1.gotoAndStop(2);
				graphBar1.height = 100 * (graphIntervals[i].income / highestAmount);
				graphBar1.width = graphBar1.width / 2;
				graphBar1.x = i * 33.3 + 10;
				graphBar1.y = 0;
				
				if (graphIntervals[i].income == 0) graphBar1.visible = false;
							
				graphBar2.gotoAndStop(3);
				graphBar2.height = 100 * (graphIntervals[i].expense / highestAmount);
				graphBar2.width = graphBar2.width / 2;
				graphBar2.x = i * 33.3 + 10 + graphBar1.width;
				graphBar2.y = 0;			
				
				if (graphIntervals[i].expense == 0) graphBar2.visible = false;
				
				if (graphIntervals[i].start < 0) graph.addChild(xPoint);
				graph.addChild(graphBar1);
				graph.addChild(graphBar2);
				
				if (i == 5)
				{
					xPoint = new ChartPointX();
					TextField(xPoint["value"]).text = graphIntervals[i].stop.toString();
					xPoint.y = 0;
					xPoint.x = (i + 1) * 33.3 + 5;
					
					graph.addChild(xPoint);
				}
			}
						
			var paramsVector:Vector.<Object> = new Vector.<Object>();
			paramsVector.push(params.finances.reverse());
			paramsVector.push(graph);
						
			scrollableWindow.populateItemList(paramsVector, "balance");
			scrollableWindow.activate();
		}
		
		/**
		 * Called when a response from server has been received, containing offer history of the player. Displays the offer history.
		 * @param	params - object containing received data
		 */
		private function getOfferData(params:Object):void 
		{
			if(fakeLoader && fakeLoader.parent) fakeLoader.parent.removeChild(fakeLoader);
			
			trace(params.offers);
			
			scrollableWindow.deactivate();
			scrollableWindow.clearItemList();
			
			if (params.offers == undefined)
			{
				offersArray = [];
			}
			else
			{
				offersArray = params.offers;
			}		
			
			roundNumber = MainGameClass.getInstance.currentRound-1;
			
			displayOffers();
		}
		
		/**
		 * Displays the offer data.
		 */
		private function displayOffers():void 
		{
			var soldProducts:Vector.<Product> = new Vector.<Product>();
			var unsoldProducts:Vector.<Product> = new Vector.<Product>();
			var totalProfit:int = 0;
					
			for each (var offerObject:Object in offersArray)
			{			
				if (int(offerObject.roundNumber) == roundNumber)
				{
					if (int(offerObject.boughtAmount) == 0)
					{
						var product:Product = new Product(GameSettings.PRODUCTS_BY_ID[offerObject.productId].internalName,
														  GameSettings.PRODUCTS_BY_ID[offerObject.productId].productName,
														  offerObject.productId,
														  GameSettings.PRODUCTS_BY_ID[offerObject.productId].productType,
														  offerObject.offerAmount,
														  offerObject.offerPrice,
														  0,
														  false,
														  false, 
														  false,
														  true);
						
						unsoldProducts.push(product)
					}
					else
					{
						product = new Product(GameSettings.PRODUCTS_BY_ID[offerObject.productId].internalName,
											  GameSettings.PRODUCTS_BY_ID[offerObject.productId].productName,
											  offerObject.productId,
											  GameSettings.PRODUCTS_BY_ID[offerObject.productId].productType,
											  offerObject.boughtAmount,
											  offerObject.offerPrice,
											  0,
											  false,
											  false, 
											  true);
						
						soldProducts.push(product);
						
						totalProfit += int(offerObject.boughtAmount) * int(offerObject.offerPrice);
					}					
				}				
			}
			
			soldProducts.push(new Product("", "", -1, "", 0, 0, 0, true, false, false, false, soldProducts.length, totalProfit));
			unsoldProducts.push(new Product("", "", -1, "", 0, 0, 0, false, true, false, false, unsoldProducts.length, 0));
			
			soldProducts.reverse();
			unsoldProducts.reverse();
			
			var summary:Vector.<Product> = soldProducts.concat(unsoldProducts);
			summary.splice(0,0,new Product("", "", -1, "", 0, 0, 0, false, false, false, false, 0, 0, roundNumber));
			
			scrollableWindow.populateItemList(summary, "marketplace");
			scrollableWindow.activate();
			
			if (roundNumber == MainGameClass.getInstance.currentRound-1) GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.LOCK_RIGHT_ARROW));
		}
		
		/**
		 * Called when a response from server has been received, containing product offer history.
		 * @param	params - object containing received data
		 */
		private function getStatisticsData(params:Object):void 
		{
			if(fakeLoader && fakeLoader.parent) fakeLoader.parent.removeChild(fakeLoader);
			
			trace(params.offers);
								
			if (params.offers == undefined)
			{
				offersArray = [];
			}
			else
			{
				offersArray = params.offers.reverse();
			}
			
			roundNumber = MainGameClass.getInstance.currentRound-1;
			
			var parameters:Array = [];
			
			for each (var product:Object in GameSettings.PRODUCTS)
			{
				parameters.push( { name:product.productName, productId:product.productId, icon:MovieClip(new (getDefinitionByName(product.productIcon + "_small") as Class)()) } );
			}
			
			parameters.sortOn("name");
						
			if (!FLAG_productStatsFirst)
			{
				scrollableWindow.deactivate();
				scrollableWindow.clearItemList();
				
				scrollableWindow.populateItemList(parameters, "productStats");
				scrollableWindow.activate();
			}
			else
			{
				FLAG_productStatsFirst = false;
				
				showProductGraph(shownProductId);
			}
		}
		
		/**
		 * Displays the product statistics.
		 * @param	productId
		 */
		public function showProductGraph(productId:int):void
		{
			if(roundNumber == 0) roundNumber = MainGameClass.getInstance.currentRound-1;
			
			trace("ID: ", productId);
			trace(GameSettings.PRODUCTS_BY_ID[productId].productName);
			
			displayedProduct = productId;
			
			scrollableWindow.deactivate();
			scrollableWindow.clearItemList();
			
			var highestPrice:int = 0;		
			
			for each (var offer:Object in offersArray)
			{
				if (int(offer.roundNumber) == roundNumber && int(offer.offerPrice) > highestPrice && int(offer.productId) == productId)
				{
					highestPrice = int(offer.offerPrice);
				}
			}
			
			var lowestPrice:int = highestPrice;
			
			for each (offer in offersArray)
			{
				if (int(offer.roundNumber) == roundNumber && int(offer.offerPrice) < lowestPrice && int(offer.productId) == productId)
				{
					lowestPrice = int(offer.offerPrice);
				}
			}
			
			if (lowestPrice == highestPrice) lowestPrice = 0;
			var interval:int = Math.ceil((highestPrice - lowestPrice) / 6);
			
			var graphIntervals:Vector.<Object> = new Vector.<Object>();
			
			for (var i:int = 0; i < 6; i++)
			{
				graphIntervals.push( {start:lowestPrice + i*interval, stop:lowestPrice + (i+1)*interval, amount:0 } );
			}
			
			var highestAmount:int = 0;
			
			for (i = 0; i < 6; i++)
			{
				for each (offer in offersArray)
				{
					if (int(offer.offerPrice) >= int(graphIntervals[i].start) && (int(offer.offerPrice) < int(graphIntervals[i].stop) || (int(offer.offerPrice) == highestPrice && i == 5)) && int(offer.productId) == productId && int(offer.roundNumber) == roundNumber)
					{
						graphIntervals[i].amount += int(offer.boughtAmount);
						
						if (int(graphIntervals[i].amount) > highestAmount) highestAmount = int(graphIntervals[i].amount);
					}
				}
			}
			
			var graph:MovieClip = new AmountPriceChart();
			
			var yPointValues:Array = [];
			
			for (i = 0; i < 6; i++)
			{
				var xPoint:MovieClip = new ChartPointX();
				var yPoint:MovieClip;
				var graphBar:MovieClip = new ChartBar();
				
				TextField(xPoint["value"]).text = graphIntervals[i].start.toString();
				xPoint.y = 0;
				xPoint.x = i * 33.3 + 5;
							
				graphBar.height = 100 * (graphIntervals[i].amount / highestAmount);
				graphBar.width = 33.3;
				graphBar.x = i * 33.3 + 5;
				graphBar.y = 0;
				
				if (graphIntervals[i].amount == 0) graphBar.visible = false;
				
				//if (yPointValues.indexOf(graphIntervals[i].amount) < 0)
				{
					yPoint = new ChartPointY();
					
					TextField(yPoint["value"]).text = graphIntervals[i].amount.toString();
					yPoint.y = -100 * (graphIntervals[i].amount / highestAmount);
					yPoint.x = i * 33.3 + 16.65 + 5;
					
					yPointValues.push(graphIntervals[i].amount);
				}
				
				graph.addChild(xPoint);
				if(yPoint) graph.addChild(yPoint);
				graph.addChild(graphBar);
				
				if (i == 5)
				{
					xPoint = new ChartPointX();
					TextField(xPoint["value"]).text = graphIntervals[i].stop.toString();
					xPoint.y = 0;
					xPoint.x = (i + 1) * 33.3 + 5;
					
					graph.addChild(xPoint);
				}
			}
			
			var parameters:Array = [graph, roundNumber, new Bitmap(BitmapData(new (getDefinitionByName(GameSettings.PRODUCTS_BY_ID[productId].productIcon) as Class)()))];			
			
			scrollableWindow.populateItemList(parameters, "statistics");
			scrollableWindow.activate();
						
			if (roundNumber == MainGameClass.getInstance.currentRound-1) GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.LOCK_RIGHT_ARROW));			
		}
				
		override protected function removedFromStageHandler(e:Event):void 
		{
			super.removedFromStageHandler(e);
			
			GameEvent.dispatcher.removeEventListener(GameEvent.TAB_CHANGE, tabChangeHandler);
		}
		
	}

}