package pl.fabrykagier.eduFarma.popups 
{
	import flash.events.MouseEvent;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.framework.display.buttons.GotoButton;
	
	/**
	 * A generic tab button used to change content of popups
	 * @author Andrzej Kaczor
	 */
	public class TabButton extends GotoButton
	{				
		private var thisTabName:String;
		
		public function TabButton()
		{
			GameEvent.dispatcher.addEventListener(GameEvent.TAB_CHANGE, deactivateTab);
			
			thisTabName = this.name.split("_")[1].split("$")[0];
			
			if (thisTabName == this.parent["activeTab"]) this.gotoAndStop("on_on");
		}
		
		/**
		 * Called when the object is being removed from stage.
		 */
		override protected function onRemoved():void 
		{
			GameEvent.dispatcher.removeEventListener(GameEvent.TAB_CHANGE, deactivateTab);
			
			super.onRemoved();
		}
		
		/**
		 * Deactivates this tab object
		 * @param	e
		 */
		private function deactivateTab(e:GameEvent):void 
		{
			if (String(e.parameters.tabName) != thisTabName) this.gotoAndStop("off_off");
			else this.gotoAndStop("on_on");
		}
		
		/**
		 * Activates this tab object and dispatches and event regarding this occurance
		 * @param	event
		 */
		override protected function onClickHandler(event:MouseEvent):void 
		{
			super.onClickHandler(event);
			
			var type:String = this.name.split("_")[1].split("$")[0];
								
			// Send the type of the clicked tab as a parameter of the event
			GameEvent.dispatcher.dispatchEvent(new GameEvent(GameEvent.TAB_CHANGE, {tabName:type}));
			
			this.gotoAndStop("on_on");
		}
		
		/**
		 * Mouse is over the tab
		 * @param	event
		 */
		override protected function onButtonOverHandler(event:MouseEvent):void
		{
			this.gotoAndStop("on_" + this.currentLabel.split("_")[1]);
		}
		
		/**
		 * Mouse went off the tab
		 * @param	event
		 */
		override protected function onButtonOutHandler(event:MouseEvent):void 
		{
			this.gotoAndStop("off_" + this.currentLabel.split("_")[1]);			
		}
		
	}
}