package pl.fabrykagier.eduFarma.popups 
{
	import adobe.utils.CustomActions;
	import flash.display.MovieClip;
	import flash.text.TextField;
	import flash.utils.getDefinitionByName;
	import pl.fabrykagier.eduFarma.main.GameEvent;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.UserData;
	import pl.fabrykagier.engines.tEngine.PlaceableObject;
	import pl.fabrykagier.framework.main.Framework;
	
	/**
	 * Upgrade popup which allows upgrading of buildings in the game.
	 * @author Andrzej Kaczor
	 */
	public class UpgradePopup extends PopupBase
	{
		private var buildingRef:PlaceableObject;		
		
		public function UpgradePopup() 
		{
			super(false);
		}
		
		/**
		 * Displays the warehouse version of the popup
		 */
		public function setWarehouseOverlay():void
		{
			container.gotoAndStop(2);
		}
		
		/**
		 * Populates the information fields in the popup
		 * @param	params
		 */
		public function populate(params:Array):void
		{		
			TextField(container.getChildByName("buildingName")).text = params[0];
			TextField(container.getChildByName("upgradeCost")).text = params[1];
			if(params[2]) TextField(container.getChildByName("currentValue")).text = params[2];
			if(params[3]) TextField(container.getChildByName("nextValue")).text = params[3];
			
			MovieClip(container.getChildByName("currentLevelIcon")).addChild(params[4]);
			MovieClip(container.getChildByName("nextLevelIcon")).addChild(params[5]);
			
			buildingRef = params[6];
			
			var upgradeButton:MovieClip = MovieClip(container["call_startProcess$callParameter_upgrade$lockEnabled_false$"]);
			
			if ((MainGameClass.getInstance.gameMap.selectedPlaceable &&
				 MainGameClass.getInstance.gameMap.selectedPlaceable.objectSettings["costLevel" + (MainGameClass.getInstance.gameMap.selectedPlaceable.objectSpecificContent.structureLevel + 1).toString()] > UserData.getInstance.money))
			{
				upgradeButton.alpha = 0.3;
				upgradeButton.mouseChildren = false;
				upgradeButton.mouseEnabled = false;
			}
		}
		
		/**
		 * If the building to which this popup corresponds is being upgraded, close the popup and the building popup beneath
		 */
		override protected function hidden():void 
		{
			super.hidden();
			
			if (buildingRef && buildingRef.objectSpecificContent.FLAG_upgrading) 
			{
				buildingRef = null;
				
				MainGameClass.getInstance.sendCloseCommand();
			}
			
			MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = true;
		}
		
	}

}