package pl.fabrykagier.eduFarma.popups 
{
	import flash.text.TextField;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	
	/**
	 * A generic warning popup appearing when something goes wrong
	 * @author Andrzej Kaczor
	 */
	public class WarningPopup extends PopupBase
	{		
		public function WarningPopup() 
		{
			
		}
		
		/**
		 * Sets the warning text in the popup according to warningType
		 * @param	warningType - keyword for a warning type
		 */
		public function setWarning(warningType:String):void
		{
			// get the text field
			var warning:TextField = TextField(this.container.getChildByName("warningText"));
			
			// set the warning text according to warningType
			switch(warningType)
			{
				case "noWarehousedry":
				{
					warning.htmlText = "Nie masz spichlerza!<br><br><font size=\"10\">Wybuduj Spichlerz aby składować w nim te produkty</font>";
					break;
				}				
				case "noWarehousenormal":
				{
					warning.htmlText = "Nie masz magazynu!<br><br><font size=\"10\">Wybuduj Magazyn aby składować w nim te produkty</font>";
					break;
				}
				case "noWarehousefrozen":
				{
					warning.htmlText = "Nie masz chłodni!<br><br><font size=\"10\">Wybuduj Chłodnię aby składować w niej te produkty</font>";
					break;
				}
				case "noCapacitydry":
				{
					warning.htmlText = "Nie masz miejsca w spichlerzach!<br><br><font size=\"10\">Wybuduj więcej spichlerzy lub zmodernizuj istniejące.</font>";
					break;
				}				
				case "noCapacitynormal":
				{
					warning.htmlText = "Nie masz miejsca w magazynach!<br><br><font size=\"10\">Wybuduj więcej magazynów lub zmodernizuj istniejące.</font>";
					break;
				}
				case "noCapacityfrozen":
				{
					warning.htmlText = "Nie masz miejsca w chłodniach!<br><br><font size=\"10\">Wybuduj więcej chłodni lub zmodernizuj istniejące.</font>";
					break;
				}
				case "noInputProduct":
				{
					warning.text = "W magazynach nie ma wystarczającej ilości potrzebnego surowca!";
					break;
				}
				case "removeWarehouse":
				{
					warning.text = "W tym magazynie wciąż przechowywane są produkty. Opróżnij magazyn przed jego usunięciem.";
					break;
				}
			}
		}
		
		override protected function hidden():void 
		{
			super.hidden();
			
			MainGameClass.getInstance.gameMap.FLAG_blockMouseActions = false;
		}
	}

}