package pl.fabrykagier.eduFarma.processess 
{
	import flash.utils.getQualifiedClassName;
	import flash.utils.getQualifiedSuperclassName;
	import pl.fabrykagier.eduFarma.main.GameSettings;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.StructureGraphics;
	import pl.fabrykagier.eduFarma.main.UserData;
	import pl.fabrykagier.eduFarma.popups.BuildingDescriptionPopup;
	import pl.fabrykagier.engines.tEngine.PlaceableObject;
	
	/**
	 * This handles the process of production of items in buildings.
	 * @author Andrzej Kaczor
	 */
	public class ProcessProduction extends ProcessBase
	{
		private var _product:String;
		private var _amount:int;
		private var _unitProductionTime:Number;
		private var _unitProductionCost:Number;
		
		private var processTime:Number;
		private var _inputProduct:String;
		private var totalTime:Number;
		private var _productType:String;
		private var _inputProductAmount:Number;
		
		/**
		 * Constructor. Handles necessary process parameters and calculations.
		 * @param	buildingID - the ID of the building which starts the process
		 * @param	structure - reference to the building object
		 * @param	product - the name of the product which is the outcome of production process
		 * @param	inputProduct - the name of the product which is needed to produce the output product
		 * @param	amount - how many units of the output product should be produced
		 * @param	unitProductionTime - how long a production of one unit of the output product takes
		 * @param	unitProductionCost - how much does the production of one unit of the output product cost
		 */
		public function ProcessProduction(buildingID:int, structure:PlaceableObject, product:String, inputProduct:String, inputProductAmount:Number, productType:String, amount:int, unitProductionTime:Number, unitProductionCost:Number, startPoint:int=0) 
		{
			super(buildingID, structure);
			
			_processType = "production";
			
			this._inputProductAmount = inputProductAmount;
			
			// set the variables
			this._productType = productType;		
			this._inputProduct = inputProduct;			
			this._unitProductionCost = unitProductionCost;
			this._unitProductionTime = unitProductionTime;
			this._amount = amount;
			this._product = product;
			this._structure = structure;
			this._buildingID = buildingID;
			
			// calculate how long will the whole process take
			processTime = unitProductionTime * amount;
			totalTime = processTime;
			
			if (startPoint > 0) processTime -= Math.round(processTime * (startPoint / 100));
			
			// decrease the money amount by the cost of producing one unit
			if(MainGameClass.FLAG_dataRestored) UserData.getInstance.money = UserData.getInstance.money - Math.round(_unitProductionCost * amount);
			
			if(MainGameClass.FLAG_dataRestored) UserData.getInstance.productionCost += Math.round(_unitProductionCost * amount);
			
			// decrease the amount of input product needed for production
			if (!_inputProduct.match("undefined")) 
			{
				if(MainGameClass.FLAG_dataRestored) UserData.getInstance.decreaseProduct(_inputProduct, _productType, Math.ceil(_inputProductAmount*amount));
			}
						
			var productId:int = GameSettings.PRODUCTS[product].productId;
			
			if (MainGameClass.FLAG_dataRestored)
			{
				MainGameClass.getInstance.communicator.callExtension("productionExt", "", { dbId:structure.objectSpecificContent.dbID,
																						structureId:_buildingID,
																						productId:productId ,
																						type:productType, amount:_amount, totalTime:totalTime,
																						userId:UserData.getInstance.userDbID } );
			}
		}
		
		/**
		 * Updates the process state. Called by a timer/enter frame function invoked by the creator of this process.
		 */
		override public function update():void 
		{		
			// decrease the time
			processTime--;
			
			// update the progress status icon
			_progress =  Math.round(((totalTime - processTime) / totalTime) * 100);
			if (progress > 100) _progress = 100;
			StructureGraphics(_structure.objectFace).statusIcon.update(progress);
			StructureGraphics(_structure.objectFace).update(progress);
			
			if (MainGameClass.getInstance.popup && getQualifiedClassName(MainGameClass.getInstance.popup).match("buildingDescriptionPopup") && MainGameClass.getInstance.popup.popupID == buildingID)
			{
				BuildingDescriptionPopup(MainGameClass.getInstance.popup).updateProductionStatus(progress, processTime, amount);
			}
			
			if (MainGameClass.getInstance.tooltip && MainGameClass.getInstance.tooltipID == structure.ID)
			{
				MainGameClass.getInstance.tooltip.updateTimer(processTime);
			}
			
			// if the process time is up
			if (processTime <= 0)
			{
				// end the process
							
				if (MainGameClass.getInstance.tooltip && MainGameClass.getInstance.tooltipID == structure.ID)
				{
					MainGameClass.getInstance.tooltip.updateText("", "Kliknij, aby przenieść produkty do magazynu");
				}
				
				endProcess();
				return;
			}
						
			super.update();
		}
		
		public function get product():String { return _product; }
		
		public function set product(value:String):void 
		{
			_product = value;
		}
		
		public function get amount():int { return _amount; }
		
		public function set amount(value:int):void
		{
			_amount = value;
		}
		
	}

}