package pl.fabrykagier.engines.tEngine 
{
	import flash.display.MovieClip;
	import flash.utils.getQualifiedClassName;
	import flash.utils.getQualifiedSuperclassName;
	import pl.fabrykagier.engines.tEngine.tiles.TileSettings;
	/**
	 * ...
	 * @author Andrzej Kaczor
	 */
	public class ObjectParser 
	{
		
		public function ObjectParser() 
		{
			
		}
		
		public static function parseObjects(container:MovieClip):void
		{
			var objectNum:int = container.numChildren;
			var displayObject:*;
			var object:StaticObject;
			
			for (var i:int = 0; i < objectNum; i++)
			{				
				displayObject = container.getChildAt(i);
				
				if (!getQualifiedSuperclassName(displayObject).match("StaticObject")) continue;
				
				object = StaticObject(displayObject);
				
				if (object.name.match("end"))
				{
					if (object.name.match("end_x")) EngineSettings.END_GRID_X_SWAP = getQualifiedClassName(object);
					else if (object.name.match("end_y")) EngineSettings.END_GRID_Y_SWAP = getQualifiedClassName(object);
					
					continue;
				}
				
				var settings:Object = {};
				
				settings.tileName = getQualifiedClassName(object);// trace(settings.tileName);
				settings.gridY = Math.round(object.getBounds(container).bottom / EngineSettings.TILE_HEIGHT);
				settings.gridX = Math.round(object.getBounds(container).left / EngineSettings.TILE_WIDTH);
				settings.rotation = 0;
				
				if (String(settings.tileName).match("removable")) settings.removable = true;
				else settings.removable = false;
				
				TileSettings.OBJECTS_SETTINGS.push(settings);
			}
		}
		
	}

}