package pl.fabrykagier.engines.tEngine
{
	import flash.display.DisplayObject;
	import flash.display.MovieClip;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.utils.clearTimeout;
	import flash.utils.getDefinitionByName;
	import flash.utils.getQualifiedClassName;
	import flash.utils.getQualifiedSuperclassName;
	import flash.utils.setTimeout;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.engines.tEngine.tiles.BackgroundTile
	import pl.fabrykagier.engines.tEngine.tiles.FenceTile;
	import pl.fabrykagier.engines.tEngine.tiles.TileSettings;
	import tileEngine.tiles.BGTile;
	import tileEngine.tiles.curvePathTile;
	import tileEngine.tiles.endFenceTile;
	import tileEngine.tiles.endPathTile;
	import tileEngine.tiles.fourCrossPathTile;
	import tileEngine.tiles.gateCenter;
	import tileEngine.tiles.gateLeft;
	import tileEngine.tiles.gateRight;
	import tileEngine.tiles.horizontalFenceTile;
	import tileEngine.tiles.lowerCornerFenceTile;
	import tileEngine.tiles.straightPathTile;
	import tileEngine.tiles.threeCrossPathTile;
	import tileEngine.tiles.tileHighliter;
	import tileEngine.tiles.upperCornerFenceTile;
	import tileEngine.tiles.verticalFenceTile;
	
	/**
	 * Manages tiles used to build a game map. Handles scrolling, depth and rendering of tiles.
	 * @author Andrzej Kaczor
	 */
	public class TileEngine extends MovieClip
	{	
		protected var placeableGrid:Vector.<Vector.<Boolean>> /* of Vectors of Boolean */ = new Vector.<Vector.<Boolean>>();
		protected var _placeableVector:Vector.<PlaceableObject> /* of PlaceableObjects */ = new Vector.<PlaceableObject>();
		protected var staticTileVector:Vector.<StaticObject> /* of StaticObjects */ = new Vector.<StaticObject>();
		protected var fenceTiles:Vector.<FenceTile> = new Vector.<FenceTile>();
		protected var layerContainer:MovieClip;
		protected var backgroundLayer:MovieClip;
		protected var _foregroundLayer:MovieClip;
		protected var debugLayer:MovieClip;		// remove or hash out for release
		
		private var gridHighliter:MovieClip;
		private var mouseClickPosition:Point;			
		private var _selectedPlaceable:PlaceableObject;		
		private var staticGroupsAdded:Vector.<String> = new Vector.<String>();
		
		private var _hudReferences:Array = [];
		private var tId:uint;
		
		// FLAGS
		private var FLAG_blockMouseActions_:Boolean = false;		
		protected var FLAG_scrollGrid:Boolean = false;
		public var FLAG_unfixedPlaceableOnGrid:Boolean = false;		
		public var FLAG_gridScrolled:Boolean = false;		
		public var FLAG_moving:Boolean = false;
		protected var topLayer:MovieClip;
		protected var FLAG_lockGridScrolling:Boolean = false;
		
		/**
		 * Class constructor. The Boolean tile grid for the top layer is created here. 
		 */
		public function TileEngine()
		{					
			for (var i:int = 0; i < EngineSettings.MAX_GRID_WIDTH; i++)
			{
				placeableGrid.push(new Vector.<Boolean>());
				for (var j:int = 0; j < EngineSettings.MAX_GRID_HEIGHT; j++)
				{
					placeableGrid[i].push(false);
				}
			}
			
			this.addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			this.addEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
		}
		
		/**
		 * Removes listeners, clears references.
		 * @param	e
		 */
		protected function removedFromStageHandler(e:Event):void 
		{
			removeEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
			topLayer.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			topLayer.removeEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler );
			topLayer.removeEventListener(MouseEvent.MOUSE_UP, mouseUpHandler );
			this.removeEventListener(MouseEvent.ROLL_OUT, mouseOutHandler);
			this.parent.removeEventListener(MouseEvent.ROLL_OUT, rollOutHandler);
			
			hudReferences = null;
			
		}
		
		/**
		 * Adds the top and bottom layers to the layer container when the engine is created and added to display list.
		 * @param	e
		 */
		protected function addedToStageHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			
			// create a container for layers
			layerContainer = new MovieClip();
			layerContainer.x = 0;
			layerContainer.y = 0;
			this.addChild(layerContainer);
						
			// create the background layer
			backgroundLayer = new MovieClip();
			backgroundLayer.x = 0;
			backgroundLayer.y = 0;
			
			// create the foreground layer
			foregroundLayer = new MovieClip();		
			foregroundLayer.x = 0;
			foregroundLayer.y = 0;
			foregroundLayer.mouseEnabled = false;
			foregroundLayer.mouseChildren = true;
			
			layerContainer.addChild(backgroundLayer);
			layerContainer.addChild(foregroundLayer);
			
			fillBackgroundLayer();
			
			// DEBUG GRID - remove or hash out for release
			//addDebugGrid();
			//debugLayer.mouseEnabled = false;
			//debugLayer.mouseChildren = false;
						
			topLayer.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler );
			topLayer.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler );
			topLayer.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			this.addEventListener(MouseEvent.ROLL_OUT, mouseOutHandler);
			this.parent.addEventListener(MouseEvent.ROLL_OUT, rollOutHandler);
		}	
		
		private function rollOutHandler(e:MouseEvent):void 
		{
			FLAG_scrollGrid = false;
		}
		
		protected function addDebugGrid():void
		{			
			if (!debugLayer)
			{
				debugLayer = new MovieClip();
				debugLayer.x = 0;
				debugLayer.y = 0;
				debugLayer.mouseEnabled = false;
				layerContainer.addChild(debugLayer);
			}
						
			debugLayer.graphics.clear();
			debugLayer.graphics.lineStyle(1, 0x703F27, 0.5);
			
			for (var i:int = 0; i <= EngineSettings.GRID_WIDTH; i++)
			{
				debugLayer.graphics.moveTo(EngineSettings.TILE_WIDTH * i, 0);
				debugLayer.graphics.lineTo(EngineSettings.TILE_WIDTH * i, EngineSettings.TILE_HEIGHT * EngineSettings.GRID_HEIGHT);
			}
			
			for (i = 0; i <= EngineSettings.GRID_HEIGHT; i++)
			{
				debugLayer.graphics.moveTo(0, EngineSettings.TILE_HEIGHT * i);
				debugLayer.graphics.lineTo(EngineSettings.TILE_WIDTH * EngineSettings.GRID_WIDTH, EngineSettings.TILE_HEIGHT * i);
			}
		}
		
		protected function removeDebugGrid():void
		{
			if(debugLayer) debugLayer.graphics.clear();
		}
		
		public function clearHighlight():void
		{
			if (gridHighliter && gridHighliter.parent) gridHighliter.parent.removeChild(gridHighliter);
			gridHighliter = null;
		}
		
		/**
		 * Called when mouse leaves the grid. Removes tile highlight if there was one applied.
		 * @param	e
		 */
		private function mouseOutHandler(e:MouseEvent):void 
		{
			clearHighlight();		
		}
		
		/**
		 * Makes the selected object not selected so nothing is selected. Obviously.
		 */
		public function unselectObject():void
		{
			if (selectedPlaceable)
			{
				selectedPlaceable.unglow();
				selectedPlaceable = null;
			}
		}
		
		/**
		 * Removes MouseMove listener, disables dragging
		 * @param	e
		 */
		protected function mouseUpHandler(e:MouseEvent):void 
		{					
			topLayer.mouseEnabled = false;
			topLayer.mouseChildren = false;
			
			tId = setTimeout(enableClicking, 180);
			
			var placeableObject:PlaceableObject;
			
			if (FLAG_blockMouseActions) return;
			
			trace("CLICKED: ", getQualifiedClassName(e.target.parent));
			if (getQualifiedClassName(e.target.parent).match("PlaceableObject") && !FLAG_gridScrolled)
			{
				placeableObject = e.target.parent;
				
				if (!FLAG_unfixedPlaceableOnGrid)
				{
					if (selectedPlaceable == placeableObject)
					{
						selectedPlaceable.unglow();
						selectedPlaceable = null;
					}
					else
					{
						for each (var object:PlaceableObject in placeableVector)
						{
							if(object) object.unglow();
						}
						
						selectedPlaceable = placeableObject;
						selectedPlaceable.glow();					
					}
				}				
				else if (FLAG_unfixedPlaceableOnGrid && !placeableObject.FLAG_placeableInPlace && checkPosition(placeableObject) &&
						 !checkObjectCollision(new Point(placeableObject.positionOnGridX,placeableObject.positionOnGridY),
											   placeableObject.objectSettings["baseSizeY"],
											   placeableObject.objectSettings["baseSizeX"])
						)
				{							
					updateGrid(placeableObject);			
					
					FLAG_unfixedPlaceableOnGrid = false;
					FLAG_moving = false;
					
					for each (object in placeableVector)
					{
						if (object)
						{
							object.mouseEnabled = true;
							object.mouseChildren = true;
						}
					}
					
					selectedPlaceable = placeableObject;
					placeableObject.placeableClicked();
				}
				
			}
			else if(selectedPlaceable && !getQualifiedClassName(e.target).match("button"))
			{
				unselectObject();
			}
			
			FLAG_scrollGrid = false;
			FLAG_gridScrolled = false;
		}
		
		private function enableClicking():void 
		{
			topLayer.mouseEnabled = true;
			topLayer.mouseChildren = true;
			
			clearTimeout(tId);
		}
		
		private function checkPosition(placeable:PlaceableObject):Boolean
		{			
			if (placeable.positionOnGridX >= 1 && placeable.positionOnGridY >= 1 &&
				placeable.positionOnGridX + int(placeable.objectSettings["baseSizeX"]) <= EngineSettings.GRID_WIDTH &&
				placeable.positionOnGridY + int(placeable.objectSettings["baseSizeY"]) <= EngineSettings.GRID_HEIGHT)
			{
				return true;
			}
			
			return false;
		}
		
		/**
		 * Sets grid elements according to position of objects
		 * @param placeableObject
		 */
		public function updateGrid(placeableObject:PlaceableObject, remove:Boolean=false):void
		{
			for (var j:int = 0; j < placeableObject.objectSettings["baseSizeY"]; j++)
			{
				for (var k:int = 0; k < placeableObject.objectSettings["baseSizeX"]; k++)
				{
					if (!remove) placeableGrid[placeableObject.positionOnGridX + k][placeableObject.positionOnGridY + j] = true;
					else placeableGrid[placeableObject.positionOnGridX + k][placeableObject.positionOnGridY + j] = false;
				}
			}
			
			if (!remove)
			{
				for each (var sObject:StaticObject in staticTileVector)
				{
					if (sObject && sObject.FLAG_removable && sObject.positionOnGridX >= placeableObject.positionOnGridX && sObject.positionOnGridX < placeableObject.positionOnGridX + int(placeableObject.objectSettings["baseSizeX"]) &&
						sObject.positionOnGridY >= placeableObject.positionOnGridY && sObject.positionOnGridY < placeableObject.positionOnGridY + int(placeableObject.objectSettings["baseSizeY"]))
					{					
						sObject.parent.removeChild(sObject);
						staticTileVector[sObject.ID] = null;
					}
				}
			}
		}
		
		/**
		 * Adds MouseMove listener, enables dragging
		 * @param	e
		 */
		protected function mouseDownHandler(e:MouseEvent):void 
		{
			mouseClickPosition = new Point(layerContainer.mouseX, layerContainer.mouseY);
			
			if (!FLAG_blockMouseActions) 
			{
				FLAG_scrollGrid = true;		
			}
		}
		
		/**
		 * Changes grid's posistion according to current mouse pointer coordinates
		 * @param	e
		 */
		protected function mouseMoveHandler(e:MouseEvent):void 
		{
			if (!FLAG_blockMouseActions)
			{			
				if (FLAG_scrollGrid && !FLAG_lockGridScrolling)
				{
					if ((this.mouseX - mouseClickPosition.x) <= 280 && (this.mouseX - mouseClickPosition.x) >= -((EngineSettings.GRID_WIDTH-EngineSettings.IINITIAL_MAP_WIDTH)*EngineSettings.TILE_WIDTH + 260))
					{
						layerContainer.x = (this.mouseX - mouseClickPosition.x);
					}
					
					if ((this.mouseY - mouseClickPosition.y) <= 240 && (this.mouseY - mouseClickPosition.y) >= -((EngineSettings.GRID_HEIGHT-EngineSettings.IINITIAL_MAP_HEIGHT)*EngineSettings.TILE_HEIGHT + 340))
					{
						layerContainer.y = (this.mouseY - mouseClickPosition.y);
					}
					
					FLAG_gridScrolled = true;
					unselectObject();
					
					//return;
				}
				
				var placeableAmount:int = placeableVector.length;
				if (placeableAmount > 0)
				{
					for (var i:int = 0; i < placeableAmount; i++)
					{
						if(placeableVector[i]) placeableVector[i].update();
					}
				}			
			}
			else e.stopImmediatePropagation();
			//if(FLAG_unfixedPlaceableOnGrid) setDisplayOrder();
		}
		
		/**
		 * Reorganizes display order according to EngineSettings.DISPLAY_ORDER and ID's of objects 
		 */
		public function setDisplayOrder():void
		{
			var limiter:int = EngineSettings.DISPLAY_ORDER.length;
			
			for (var t:int = 0; t < limiter; t++ )
			{
				switch(EngineSettings.DISPLAY_ORDER[t])
				{
					case "StaticObject":
					{
						for each (var staticObject:StaticObject in staticTileVector)
						{
							if(staticObject) foregroundLayer.addChild(staticObject);
						}
						break;
					}
					case "Grid":
					{
						if (debugLayer) foregroundLayer.addChild(debugLayer);
						break;
					}
					case "TileHighlight":
					{
						if(gridHighliter) foregroundLayer.addChild(gridHighliter);
						break;
					}
					case "PlaceableObject":
					{						
						for (var i:int = 0; i <= EngineSettings.GRID_HEIGHT; i++)
						{
							for each (var placeableObject:PlaceableObject in placeableVector)
							{
								if (placeableObject && placeableObject.positionOnGridY == i) 
								{
									foregroundLayer.addChild(placeableObject);
								}
							}		
						}
						break;
					}
					case "UpperFence":
					{
						for each (var fence:FenceTile in fenceTiles)
						{
							if (fence.positionOnGridY == 0) foregroundLayer.addChild(fence);						
						}
						
						//for each (staticObject in staticTileVector)
						//{
							//if (staticObject && staticObject.positionOnGridY > 0 && staticObject.positionOnGridY < EngineSettings.GRID_HEIGHT-1) foregroundLayer.addChild(staticObject);
							//else if (debugLayer && staticObject) foregroundLayer.swapChildren(staticObject, debugLayer);
						//}
						break;
					}
					case "SideFence":
					{
						for each (fence in fenceTiles)
						{
							if (fence.positionOnGridX == 1 || fence.positionOnGridX == EngineSettings.GRID_WIDTH-1) foregroundLayer.addChild(fence);
						}
						break;
					}
					case "LowerFence":
					{
						for each (fence in fenceTiles)
						{
							if (fence.positionOnGridY == EngineSettings.GRID_HEIGHT - 1) foregroundLayer.addChild(fence);							
						}
						
						for each (staticObject in staticTileVector)
						{
							if (staticObject && staticObject.positionOnGridY > EngineSettings.GRID_HEIGHT-1) foregroundLayer.addChild(staticObject);
							else if (debugLayer && staticObject) foregroundLayer.swapChildren(staticObject, debugLayer);
						}
						break;
					}
				}
			}
		}
		
		/**
		 * Adds highlight to tiles under mouse point.
		 * @param	gridCoords - cooridnates of the tile currently lying under mouse pointer
		 * @param	tileHeight - detemines how many vertical tiles should be highlighted
		 * @param	tileWidth - determines how many horizontal tiles should be highlighted
		 */
		public function highlightTiles(gridCoords:Point, tileHeight:int = 1, tileWidth:int = 1):void
		{
			var counter:int = 0;
			
			if (!gridHighliter || (gridHighliter && gridHighliter.numChildren != tileHeight * tileWidth))
			{			
				if (gridHighliter) foregroundLayer.removeChild(gridHighliter);
				gridHighliter = new MovieClip();
				
				var singleTileHighlight:MovieClip;
				
				for (var i:int = 0; i < tileHeight; i++)
				{
					for (var j:int = 0; j < tileWidth; j++)
					{
						singleTileHighlight = new tileHighliter();
						singleTileHighlight.y = i * EngineSettings.TILE_HEIGHT;
						singleTileHighlight.x = j * EngineSettings.TILE_WIDTH;
						
						trace("H COORDS: ", singleTileHighlight.x, singleTileHighlight.y);
						
						gridHighliter.addChildAt(singleTileHighlight, counter);
						
						counter++;
					}
				}
				
				foregroundLayer.addChild(gridHighliter);
				
				for each (var object:PlaceableObject in placeableVector)
				{
					if (object && !object.FLAG_placeableInPlace)
					{
						foregroundLayer.swapChildren(gridHighliter, object);
						break;
					}
				}
			}
			
			//gridHighliter.x = (gridCoords.x - Math.floor(tileWidth/2)) * EngineSettings.TILE_WIDTH;
			//gridHighliter.y = (gridCoords.y - Math.floor(tileHeight/2)) * EngineSettings.TILE_HEIGHT;
			
			gridHighliter.x = gridCoords.x * EngineSettings.TILE_WIDTH;
			gridHighliter.y = gridCoords.y * EngineSettings.TILE_HEIGHT;
			
			counter = 0;
			
			for (i = 0; i < tileHeight; i++)
			{
				for (j = 0; j < tileWidth; j++)
				{
					var xIndex:int = gridCoords.x + j;
					var yIndex:int = gridCoords.y + i;
					
					if (xIndex < EngineSettings.GRID_WIDTH && yIndex < EngineSettings.GRID_HEIGHT && xIndex >= 0 && yIndex >= 0)
					{
						if (placeableGrid[xIndex][yIndex])
						{
							MovieClip(gridHighliter.getChildAt(counter)).gotoAndStop("forbiddenHighlight");
							counter++;
							continue;
						}						
					}
					else
					{
						MovieClip(gridHighliter.getChildAt(counter)).gotoAndStop("forbiddenHighlight");
						counter++;
						continue;
					}
					
					MovieClip(gridHighliter.getChildAt(counter)).gotoAndStop("normalHighlight");
					
					counter++;
				}
			}
		}
		
		public function checkObjectCollision(gridCoords:Point, tileHeight:int = 1, tileWidth:int = 1):Boolean
		{
			for (var i:int = 0; i < tileHeight; i++)
			{
				for (var j:int = 0; j < tileWidth; j++)
				{
					var xIndex:int = gridCoords.x + j;
					var yIndex:int = gridCoords.y + i;
					
					if (xIndex < EngineSettings.GRID_WIDTH && yIndex < EngineSettings.GRID_HEIGHT && xIndex >= 0 && yIndex >= 0)
					{
						if (placeableGrid[xIndex][yIndex])
						{
							return true;
							break;
						}					
					}							
				}
			}
			
			return false;
		}
		
		/**
		 * Fills the background layer with tiles represented by the BackgroundTile class
		 */
		protected function fillBackgroundLayer(tileName:String = ""):void
		{
			var tile:BackgroundTile;
			
			for (var i:int = -7; i < EngineSettings.GRID_WIDTH+7; i++)
			{
				for (var j:int = -7; j < EngineSettings.GRID_HEIGHT+7; j++)
				{
					tile = new BackgroundTile(tileName);
					backgroundLayer.addChild(tile);
					tile.x = EngineSettings.TILE_WIDTH * i;
					tile.y = EngineSettings.TILE_HEIGHT * j;
				}
			}
			
			//var additionalBackground:StaticObject = StaticObject(new (getDefinitionByName("staticBackgroundObjects") as Class)());
			//
			//if (additionalBackground)
			//{
				//additionalBackground.x = 0;
				//additionalBackground.x = 0;
				//backgroundLayer.addChild(additionalBackground);
			//}
		}
		
		/**
		 * Adds static tiles to the grid according to the settings stored in TileSettings class
		 * @param	type - the type of tiles to render on grid
		 * @param	hitTestEnabled - set to true if this object(s) cannot be covered by any other object
		 */
		public function addStaticTileGroup(type:String, hitTestEnabled:Boolean = false):void
		{
			type = type.toUpperCase();
			
			if(staticGroupsAdded.indexOf(type) < 0) staticGroupsAdded.push(type);
			
			if (TileSettings[type + "_SETTINGS"])
			{
				var tileCount:int = TileSettings[type + "_SETTINGS"].length;
				var currentTile:StaticObject;
				
				for (var i:int = 0; i < tileCount; i++)
				{
					if (!TileSettings[type + "_SETTINGS"][i].removable)
					{
						placeableGrid[TileSettings[type + "_SETTINGS"][i].gridX][TileSettings[type + "_SETTINGS"][i].gridY] = true;
					}
				}
								
				for (i = 0; i < tileCount; i++)
				{										
					currentTile = StaticObject(new (getDefinitionByName(TileSettings[type + "_SETTINGS"][i].tileName) as Class)());
					
					var gridX:int;
					var gridY:int;
					
					gridX = TileSettings[type + "_SETTINGS"][i].gridX;										
					gridY = TileSettings[type + "_SETTINGS"][i].gridY;
					
					if (hitTestEnabled && !TileSettings[type + "_SETTINGS"][i].removable)
					{
						//placeableGrid[gridX][gridY] = true;
						
						if (gridX >= EngineSettings.GRID_WIDTH-1 || gridY >= EngineSettings.GRID_HEIGHT-1) currentTile.visible = false;
						else if (gridX == EngineSettings.GRID_WIDTH - 2 && !placeableGrid[gridX][gridY + 1] && !placeableGrid[gridX][gridY - 1])
						{
							currentTile = StaticObject(new (getDefinitionByName(EngineSettings.END_GRID_X_SWAP) as Class)());
						}
						else if (gridY == EngineSettings.GRID_HEIGHT - 2 && !placeableGrid[gridX - 1][gridY] && !placeableGrid[gridX + 1][gridY])
						{
							currentTile = StaticObject(new (getDefinitionByName(EngineSettings.END_GRID_Y_SWAP) as Class)());
						}
					}
					
					foregroundLayer.addChild(currentTile);
					
					currentTile.x = gridX * EngineSettings.TILE_WIDTH;
					currentTile.y = gridY * EngineSettings.TILE_HEIGHT;
					currentTile.positionOnGridX = gridX;
					currentTile.positionOnGridY = gridY;
					
					rotateAroundCenter(currentTile, TileSettings[type + "_SETTINGS"][i].rotation);
					
					staticTileVector.push(currentTile);
					currentTile.ID = staticTileVector.indexOf(currentTile);
					
					currentTile.FLAG_removable = TileSettings[type + "_SETTINGS"][i].removable;
				}
			}
		}
		
		/**
		 * Puts a fence around the visible area. If the area size changes, call this method right after the change.
		 */
		public function fenceVisibleArea():void
		{
			if (fenceTiles.length > 0)
			{
				var limiter:int = fenceTiles.length;
				var currentTile:FenceTile;
				
				for (var i:int = 0; i < limiter; i++)
				{
					currentTile = fenceTiles.pop();
					placeableGrid[currentTile.positionOnGridX][currentTile.positionOnGridY] = false;
					foregroundLayer.removeChild(currentTile);
					currentTile = null;
				}
			}
			
			var tile:FenceTile;			
			
			for (i = 0; i < EngineSettings.GRID_WIDTH; i++)
			{
				for (var j:int = 0; j < EngineSettings.GRID_HEIGHT; j++)
				{
					var reverse:Boolean = false;
					
					if (i == 0 && j == 0)
					{
						tile = new upperCornerFenceTile();
					}
					else if (i == 0 && j == EngineSettings.GRID_HEIGHT - 1)
					{
						tile = new lowerCornerFenceTile();
					}
					else if (i == EngineSettings.GRID_WIDTH - 1 && j == 0)
					{
						tile = new upperCornerFenceTile();	
						reverse = true;
					}
					else if (i == EngineSettings.GRID_WIDTH - 1 && j == EngineSettings.GRID_HEIGHT - 1)
					{
						tile = new lowerCornerFenceTile();
						reverse = true;
					}
					else if (i == 0 || i == EngineSettings.GRID_WIDTH - 1)
					{
						tile = new verticalFenceTile();
					}
					else if (j == 0 || j == EngineSettings.GRID_HEIGHT - 1)
					{
						tile = new horizontalFenceTile();
					}
					else continue;
					
					
					// Very ugly non-engine code
					if (i == 8 && j == EngineSettings.GRID_HEIGHT - 1)
					{
						tile = new gateLeft();
					}
					else if (i == 9 && j == EngineSettings.GRID_HEIGHT - 1)
					{
						tile = new gateCenter();
					}
					else if (i == 10 && j == EngineSettings.GRID_HEIGHT - 1)
					{
						tile = new gateRight();
					}
					
					// end of very ugly code
					
					//if (placeableGrid[i][j])
					{
						for each (var sTile:StaticObject in staticTileVector)
						{
							if (sTile && sTile.positionOnGridX == i && sTile.positionOnGridY == j)
							{	
								sTile.visible = false;
																
								break;
							}
						}
					}
					
					//if (MainGameClass.getInstance.expandLevel == 1) tile.gotoAndStop(2);
					//else if (MainGameClass.getInstance.expandLevel == 2) tile.gotoAndStop(3);
					
					foregroundLayer.addChild(tile);
					tile.x = EngineSettings.TILE_WIDTH * i;
					tile.y = EngineSettings.TILE_HEIGHT * j;
					tile.positionOnGridX = i;
					tile.positionOnGridY = j;
					
					if(reverse) scaleThroughCenter(tile, -1);
					
					placeableGrid[i][j] = true;
					
					fenceTiles.push(tile);
				}
			}
		}
		
		/**
		 * Adds a PlaceableObject to the grid
		 * @param	objectName - specifies what kind of PlaceableObject should be added. Object settings must be present in EngineSettings.PLACEABLE_SETTINGS under a corresponding name.
		 */
		public function addPlaceableObject(typeId:int, objectSpecificContent:*=null):PlaceableObject
		{
			var newPlaceable:PlaceableObject = new PlaceableObject(typeId, this);
			foregroundLayer.addChild(newPlaceable);
			newPlaceable.x = foregroundLayer.mouseX - newPlaceable.width / 2;
			newPlaceable.y = foregroundLayer.mouseY - newPlaceable.height / 2;
			newPlaceable.objectSpecificContent = objectSpecificContent;
			
			for each (var object:PlaceableObject in placeableVector)
			{
				if (object)
				{
					object.mouseEnabled = false;
					object.mouseChildren = false;
				}
			}
			
			var nullPosition:int = placeableVector.indexOf(null);
			
			if (nullPosition >= 0)
			{
				newPlaceable.ID = nullPosition;
				placeableVector[nullPosition] = newPlaceable;
			}
			else
			{
				newPlaceable.ID = placeableVector.length;
				placeableVector.push(newPlaceable);				
			}
			
			FLAG_unfixedPlaceableOnGrid = true;
			
			traceGrid(placeableGrid);
			
			return newPlaceable;
		}
		
		public function disablePlaceableMouse():void
		{
			if (FLAG_unfixedPlaceableOnGrid)
			{				
				FLAG_blockMouseActions = true;
				
				for each (var object:PlaceableObject in placeableVector)
				{
					if (object && !object.FLAG_placeableInPlace)
					{
						object.mouseEnabled = false;
						object.mouseChildren = false;
						return;
					}
				}
			}
		}
		
		public function enablePlaceableMouse():void
		{
			if (FLAG_unfixedPlaceableOnGrid)
			{				
				FLAG_blockMouseActions = false;
				
				for each (var object:PlaceableObject in placeableVector)
				{
					if (object && !object.FLAG_placeableInPlace)
					{
						object.mouseEnabled = true;
						object.mouseChildren = true;
						return;
					}
				}
			}
		}
		
		/**
		 * Removes specified PlaceableObject from grid
		 * @param	object - PlaceableObject to remove
		 */
		public function removePlaceableObject():void
		{
			if (selectedPlaceable)
			{
				var objectPosition:int = selectedPlaceable.ID;
				
				if (objectPosition >= 0)
				{
					placeableVector[objectPosition] = null;
					
					if (selectedPlaceable.FLAG_placeableInPlace)
					{
						updateGrid(selectedPlaceable, true);
					}
				}
				
				for each (var object:PlaceableObject in placeableVector)
				{
					if (object)
					{
						object.mouseEnabled = true;
						object.mouseChildren = true;
					}
				}
				
				selectedPlaceable.unglow();
				selectedPlaceable.parent.removeChild(selectedPlaceable);
				selectedPlaceable = null;
			}
		}
		
		public function movePlaceableObject():void
		{			
			if (selectedPlaceable)
			{				
				selectedPlaceable.FLAG_placeableInPlace = false;
				FLAG_unfixedPlaceableOnGrid = true;
				
				FLAG_moving = true;
				
				for each (var object:PlaceableObject in placeableVector)
				{
					if (object && object.ID != selectedPlaceable.ID)
					{
						object.mouseEnabled = false;
						object.mouseChildren = false;
					}
					else if (object && object.ID == selectedPlaceable.ID)
					{
						object.mouseEnabled = true;
						object.mouseChildren = true;
					}
				}
				
				selectedPlaceable.objectFace.alpha = 0.5;
				
				var objectPosition:int = selectedPlaceable.ID;
				
				if (objectPosition >= 0)
				{					
					updateGrid(selectedPlaceable, true);
				}
				
				foregroundLayer.addChild(selectedPlaceable);
				
				selectedPlaceable.unglow();
				selectedPlaceable = null;
			}
		}
		
		/**
		 * Translates coordinates to grid coordinates
		 * @param	coords - coordinates
		 * @param	coordsParent - object which the coordinates where taken from
		 * @return  returns a Point object containing the grid coordinates
		 */		
		public function translateCoordsToGrid(coords:Point,coordsParent:DisplayObject):Point
		{
			var globalCoords:Point = coordsParent.localToGlobal(coords);
			var gridCoords:Point = foregroundLayer.globalToLocal(globalCoords);
			
			var gridPoint:Point = new Point(Math.ceil(gridCoords.x / EngineSettings.TILE_WIDTH), Math.ceil(gridCoords.y / EngineSettings.TILE_HEIGHT));
			
			return gridPoint;
		}
		
		/**
		 * Expands the tile grid, resets necessary tiles, adds new background tiles and fencing
		 * @param	addTilesX - amount of tile columns to add
		 * @param	addTilesY - amount of tile rows to add
		 */
		public function expandGrid(addTilesX:int, addTilesY:int):void
		{
			EngineSettings.GRID_WIDTH += addTilesX;
			EngineSettings.GRID_HEIGHT += addTilesY;
			
			if (EngineSettings.GRID_WIDTH > EngineSettings.MAX_GRID_WIDTH) EngineSettings.GRID_WIDTH = EngineSettings.MAX_GRID_WIDTH;
			if (EngineSettings.GRID_HEIGHT > EngineSettings.MAX_GRID_HEIGHT) EngineSettings.GRID_HEIGHT = EngineSettings.MAX_GRID_HEIGHT;
			
			var limiter:int = backgroundLayer.numChildren;
			for (var i:int = 0; i < limiter; i++)
			{
				var child:DisplayObject = DisplayObject(backgroundLayer.getChildAt(limiter - i - 1));
				backgroundLayer.removeChild(child);
			}
			
			for (i = placeableGrid.length-1; i < EngineSettings.GRID_WIDTH; i++)
			{
				placeableGrid.push(new Vector.<Boolean>());
				for (var j:int = placeableGrid[i].length-1; j < EngineSettings.GRID_HEIGHT; j++)
				{
					placeableGrid[i].push(false);
				}
			}
			
			fillBackgroundLayer();
			
			// DEBUG GRID - remove or hash out for release
			//addDebugGrid();
			
			for each (var tile:StaticObject in staticTileVector)
			{
				if (tile) tile.parent.removeChild(tile);
			}
			
			if (fenceTiles.length > 0)
			{
				limiter = fenceTiles.length;
				var currentTile:FenceTile;
				
				for (i = 0; i < limiter; i++)
				{
					currentTile = fenceTiles.pop();
					placeableGrid[currentTile.positionOnGridX][currentTile.positionOnGridY] = false;
					foregroundLayer.removeChild(currentTile);
					currentTile = null;
				}
			}			
			
			staticTileVector = new Vector.<StaticObject>();
			
			for each (var type:String in staticGroupsAdded)
			{
				addStaticTileGroup(type, true);
			}
						
			fenceVisibleArea();			
			
			setDisplayOrder();
		}
		
		/**
		 * Rotates an object around it's center point if the object's registration point is set to (0,0)
		 * @param	rotationObject - object which the rotation is applied to
		 * @param	angle - angle of rotation (in degrees)
		 */
		private function rotateAroundCenter (rotationObject:DisplayObject, angle:Number):void
		{
			var matrix:Matrix = rotationObject.transform.matrix;
			matrix.tx -= (rotationObject.x + rotationObject.width/2);
			matrix.ty -= (rotationObject.y + rotationObject.height/2);
			matrix.rotate(angle*(Math.PI/180));
			matrix.tx += (rotationObject.x + rotationObject.width/2);
			matrix.ty += (rotationObject.y + rotationObject.height/2);
			rotationObject.transform.matrix = matrix;
		}
		
		/**
		 * Scales an object through it's center point keeping it's original position intact
		 * @param	scaleObject = object which the scaling is applied to
		 * @param	scale_x - scale value along the x axis
		 * @param	scale_y - scale value along the y axis
		 */
		private function scaleThroughCenter (scaleObject:DisplayObject, scale_x:Number=1, scale_y:Number=1):void
		{
			var matrix:Matrix = scaleObject.transform.matrix;
			matrix.tx -= (scaleObject.x + scaleObject.width/2);
			matrix.ty -= (scaleObject.y + scaleObject.height/2);
			matrix.scale(scale_x, scale_y);
			matrix.tx += (scaleObject.x + scaleObject.width/2);
			matrix.ty += (scaleObject.y + scaleObject.height/2);
			scaleObject.transform.matrix = matrix;
		}
		
		public function traceGrid(_grid:*=null):void
		{
			if (_grid)
			{
				trace("\n################ GAME GRID #################");
				////trace("GRID LENGTH: ", grid.length);
				for (var i:int = 0; i < _grid.length; i++)
				{					
					var row:String = "";
					for (var j:int = 0; j < _grid[i].length; j++)
					{
						if (_grid[i][j])
						{
							//row += String(_grid[i][j].blockType) + " " + String(_grid[i][j].blockColor) + ", ";
							row += "[1] ";
						}
						else row += "[0] ";
					}
					trace(row);
				}
			}			
		}
		
		public function get selectedPlaceable():PlaceableObject { return _selectedPlaceable; }
		
		public function set selectedPlaceable(value:PlaceableObject):void 
		{
			_selectedPlaceable = value;
		}
		
		public function get placeableVector():Vector.<PlaceableObject> { return _placeableVector; }
		
		public function set placeableVector(value:Vector.<PlaceableObject>):void 
		{
			_placeableVector = value;
		}
		
		public function get foregroundLayer():MovieClip { return _foregroundLayer; }
		
		public function set foregroundLayer(value:MovieClip):void 
		{
			_foregroundLayer = value;
		}
		
		public function get hudReferences():Array { return _hudReferences; }
		
		public function set hudReferences(value:Array):void 
		{
			_hudReferences = value;
		}
		
		public function get FLAG_blockMouseActions():Boolean { return FLAG_blockMouseActions_; }
		
		public function set FLAG_blockMouseActions(value:Boolean):void 
		{
			FLAG_blockMouseActions_ = value;
			
			if (value)
			{
				topLayer.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			}
			else
			{
				topLayer.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
			}
		}
		
	}

}