<?php

function classAdd($request) {
    if (empty($request->data['name']) ||
        empty($request->data['school_id']) ||
        !is_numeric($request->data['school_id']) ||
        empty($request->data['teacher_id']) ||
        !is_numeric($request->data['teacher_id']) ||
        empty($request->data['id']) ||
        !is_numeric($request->data['id']))
            return new Error(ExError::ERR_REQUEST);

    $schoolModel        = BaseModel::load('school');
    $teacherModel       = BaseModel::load('teacher');
    $schoolClassModel   = BaseModel::load('schoolClass');

    if (!$schoolModel->exists($request->data['school_id']))
        return new Error(ExError::ERR_CLASS_SCHOOL_NOT_FOUND);

    if (!$teacherModel->exists($request->data['teacher_id']))
        return new Error(ExError::ERR_CLASS_TEACHER_NOT_FOUND);

    $request->data['room_name'] = 'class' . $request->data['id'];

    return $schoolClassModel->save($request->data);
}
