<?php

function classUpdate($request) {
    if (empty($request->data['name']) ||
        empty($request->data['school_id']) ||
        !is_numeric($request->data['school_id']) ||
        empty($request->data['teacher_id']) ||
        !is_numeric($request->data['teacher_id']))
            return new Error(ExError::ERR_REQUEST);

    $schoolModel        = BaseModel::load('school');
    $teacherModel       = BaseModel::load('teacher');
    $schoolClassModel   = BaseModel::load('schoolClass');

    if (!$schoolClassModel->exists($request->data['id']))
        return new Error(ExError::ERR_CLASS_NOT_EXISTS);

    if (!$schoolModel->exists($request->data['school_id']))
        return new Error(ExError::ERR_CLASS_SCHOOL_NOT_FOUND);

    if (!$teacherModel->exists($request->data['teacher_id']))
        return new Error(ExError::ERR_CLASS_TEACHER_NOT_FOUND);

    return $schoolClassModel->save($request->data);
}
