<?php

class School extends BaseModel
{
    public function exists($id) {
        return $this->executeGetValue('SELECT id FROM school WHERE id = :id', array(
            'id'    => $id
        )) !== false;
    }


    public function existsByName($name) {
        return $this->executeGetValue('SELECT id FROM school WHERE name = :name', array(
            'name'    => $name
        )) !== false;
    }


    public function save($row) {
        $this->execute('
            INSERT INTO school
            SET
                id = :id,
                name = :name,
                city = :city
            ON DUPLICATE KEY UPDATE
                id = :id,
                name = :name,
                city = :city
        ', $row);

        return $row;
    }

    
    public function delete($id) {
        //delete school
        $this->execute('DELETE FROM school WHERE id = :id', array(
            'id'    => $id
        ));

        //delete teachers
        $this->execute('DELETE FROM teacher WHERE school_id = :id', array(
            'id'    => $id
        ));

        //get classes
        $classes = array();
        foreach ($this->execute('SELECT id FROM class WHERE school_id = :id', array(
            'id'    => $id
        )) as $item)
            $classes[$item['id']] = null;

        $classes = array_keys($classes);

        if (!empty($classes)) {
            //delete students in classses
            $this->execute('DELETE FROM student WHERE class_id IN (' . implode(',', $classes) . ')');
        }

        //delete classes
        $this->execute('DELETE FROM class WHERE teacher_id = :teacher_id', array(
            'teacher_id'    => $id
        ));
    }


    public function get($id) {
        return $this->executeGetRow('SELECT id, name, city FROM school WHERE id = :id', array(
            'id'    => $id
        ));
    }
}
