<?php

class Student extends BaseModel
{
    protected static $DEFAULTS = array(
        'cash'          => 10000,
        'loan'          => 0,
        'loan_rate'     => 0,
        'loan_length'   => 0,
        'field_size_x'  => 20,
        'field_size_y'  => 20
    );

    protected static $REMAPPED = array(
        array('salary', 'cash')
    );


    /**
     * remap fields (forward) due to self::$REMAPPED array
     * @param array $fields
     * @return array
     */
    protected function remapFieldsForward($fields) {
        foreach (self::$REMAPPED as $fd) {
            if (array_key_exists($fd[0], $fields)) {
                $fields[$fd[1]] = $fields[$fd[0]];
                unset($fields[$fd[0]]);
            }
        }

        return $fields;
    }


    public function exists($id) {
        return $this->executeGetValue('SELECT id FROM student WHERE id = :id', array(
            'id'    => $id
        )) !== false;
    }


    public function emailToId($email) {
        return $this->executeGetValue('SELECT id FROM student WHERE email = :email', array(
            'email'    => $email
        ));
    }


    public function save($row) {
        $row['loan']            = self::$DEFAULTS['loan'];
        $row['loan_rate']       = self::$DEFAULTS['loan_rate'];
        $row['loan_length']     = self::$DEFAULTS['loan_length'];
        $row['field_size_x']    = self::$DEFAULTS['field_size_x'];
        $row['field_size_y']    = self::$DEFAULTS['field_size_y'];

        $row = $this->remapFieldsForward($row);

        $this->execute('
            INSERT INTO student
            SET
                id = :id,
                name = :name,
                surname = :surname,
                email = :email,
                class_id = :class_id,
                cash = :cash,
                loan = :loan,
                loan_rate = :loan_rate,
                loan_length = :loan_length,
                field_size_x = :field_size_x,
                field_size_y = :field_size_y,
                accepted = 0
            ON DUPLICATE KEY UPDATE
                id = :id,
                name = :name,
                surname = :surname,
                email = :email,
                class_id = :class_id,
                cash = :cash
        ', $row);

        return $row;
    }


    public function get($id) {
        return $this->executeGetRow('SELECT id, name, surname, email, class_id, cash, loan, loan_rate, loan_length, field_size_x, field_size_y FROM student WHERE id = :id', array(
            'id'    => $id
        ));
    }

    
    public function delete($id) {
        $this->execute('DELETE FROM student WHERE id = :id', array(
            'id'    => $id
        ));
    }
}
