<?php
class RoomController extends Controller
{
    
  public function index_page()
  {
    $viewData = array();
    $records = RepositoryLoader::get('Room')->getAllRooms();
    
    $viewData['records'] = $records;
    //print_r($schools);
    $this->view->apply('room_list.php', $viewData);
  }
  
  public function add()
  {
    $this->edit();
  } 
  public function delete($id)
  {
    RepositoryLoader::get('Room')->removeRoomById($id);
    header('Location: ' . BASE_HREF . 'room?removed=true');
  }
  public function edit($id = 0, $record = null, $error = null)
  {
  	if (!$record) 
  	{
    	$viewData['record'] = RepositoryLoader::get('Room')->getRoomById($id);
  	}
  	else
  	{
  		$viewData['record'] = $record;
  		$viewData['error'] = $error;
  	}
  	
    $viewData['school_list'] = RepositoryLoader::get('School')->getAllSchools();
    $this->view->apply('room_edit.php', $viewData);
  }
  
  public function save($id = 0)
  {
    $record = array();
    $record['school_id'] = $_POST['school_id'];
    $record['max_users'] = $_POST['max_users'];
    $record['room_name'] = $_POST['room_name'];
    
    if (!RepositoryLoader::get('Room')->saveRoom($id, $record))
    {
    	$this->edit(0, $record, 'Klasa o takiej nazwie istnieje już w wybranej szkole!');
    	return;
    }
    
    
    $_GET['new_room'] = true;
    $this->index_page();
  }
  
  public function getURIMethods()
  {
      return array('add','edit','delete','save');
  }
  public function notFound()
  {
    $this->view->apply('not_found.php');
  }
}