<?php
class SchoolController extends Controller
{
    
  public function index_page()
  {
    $viewData = array();
    $schools = RepositoryLoader::get('School')->getAllSchools();
    $viewData['school_list'] = $schools;
    //print_r($schools);
    $this->view->apply('school_list.php', $viewData);
  }
  
  public function add()
  {
    $this->edit();
  } 
  public function delete($id)
  {
    RepositoryLoader::get('School')->removeSchoolById($id);
    header('Location: ' . BASE_HREF . 'school');
  }
  public function edit($id = 0, $record = null, $error = null)
  {
  	   
  	if (!$record) 
  	{
    	$viewData['record'] = RepositoryLoader::get('School')->getSchoolByID($id);
  	}
  	else
  	{
  		$viewData['record'] = $record;
  		$viewData['error'] = $error;
  	}

    $this->view->apply('school_edit.php', $viewData);
  }
  
  public function save($id = 0)
  {
    $record['school_name'] = $_POST['school_name'];
    
    if (!RepositoryLoader::get('School')->saveSchool($id, $record))
    {
    	$this->edit(0, $record, 'Szkoła o takiej nazwie już istnieje!');
    	return;
    }

    
    $this->index_page();
  }
  
  public function getURIMethods()
  {
      return array('add','edit','delete','save');
  }
  public function notFound()
  {
    $this->view->apply('not_found.php');
  }
}