<?php
class TeacherController extends Controller
{
    
  public function index_page()
  {
    $viewData = array();
    $records = RepositoryLoader::get('Teacher')->getAllTeachers();
    
    $viewData['records'] = $records;
    $this->view->apply('teacher_list.php', $viewData);
  }
  
  public function add()
  {
    $this->edit();
  } 
  public function delete($id)
  {
    RepositoryLoader::get('Teacher')->removeTeacherById($id);
    header('Location: ' . BASE_HREF . 'teacher');
  }
  public function edit($id = 0, $record = null, $error = null)
  {   
  	if (!$record) 
  	{
    	$viewData['record'] = RepositoryLoader::get('Teacher')->getTeacherById($id);
  	}
  	else
  	{
  		$viewData['record'] = $record;
  		$viewData['error'] = $error;
  	}
  	
    $viewData['school_has_room_list'] = RepositoryLoader::get('School')->getAllSchoolsWithRooms();
    $viewData['room_list'] = RepositoryLoader::get('Room')->getAllRooms();

    $this->view->apply('teacher_edit.php', $viewData);
  }
  
  public function save($id = 0)
  {
    
    $record = array();
    $record['room_id'] = $_POST['room_id'];
    $record['username'] = $_POST['username'];
    $record['password'] = $_POST['password'];
    $record['room_id'] = $_POST['room_id'];
    $record['school_id'] = $_POST['school_id'];
    
    if(!$this->validateUserName($record['username']))
    {
    	$this->edit(0, $record, 'Nieprawidłowe znaki w nazwie nauczyciela. Dozwolone to: alfanumeryczne (bez polskich znaków) oraz znak "." i "_"');
    	return;
    }
    
    if (!RepositoryLoader::get('Teacher')->saveTeacher($id, $record))
    {
    	$this->edit(0, $record, 'Nauczyciel o takiej nazwie już istnieje');
    	return;
    }
    
   
    $this->index_page();

  }
  
  public function getURIMethods()
  {
      return array('add','edit','delete','save');
  }
  public function notFound()
  {
    $this->view->apply('not_found.php');
  }
}