<?php
class UserController extends Controller
{
    
  public function index_page()
  {
    $viewData = array();
    $records = RepositoryLoader::get('User')->getAllUsers();
    
    $viewData['records'] = $records;
    $this->view->apply('user_list.php', $viewData);
  }
  
  public function add()
  {
    $id = RepositoryLoader::get('User')->addNewUser();
    header('Location: ' . BASE_HREF . 'user/edit/' . $id);
  } 
  public function delete($id)
  {
    RepositoryLoader::get('User')->removeUserById($id);
    header('Location: ' . BASE_HREF . 'user');
  }
  
  public function edit($id = 0, $record = null, $error = null)
  {   
  	if (!$record) 
  	{
    	$viewData['record'] = RepositoryLoader::get('User')->getUserById($id);
  	}
  	else
  	{
  		$viewData['record'] = $record;
  		$viewData['error'] = $error;
  	}
  	
    $viewData['school_has_room_list'] = RepositoryLoader::get('School')->getAllSchoolsWithRooms();
    
    $this->view->apply('user_edit.php', $viewData);
  }
  
  public function save($id = 0)
  {
    
    $record = array();
    $record['username'] = $_POST['username'];
    $record['password'] = $_POST['password'];
    $record['room_id'] = $_POST['room_id'];
    $record['school_id'] = $_POST['school_id'];
    
    if(!$this->validateUserName($record['username']))
    {
    	$this->edit(0, $record, 'Nieprawidłowe znaki w nazwie użytkownika. Dozwolone to: alfanumeryczne (bez polskich znaków) oraz znak "." i "_"');
    	return;
    }
    
    if (!RepositoryLoader::get('User')->saveUser($id, $record))
    {
    	$this->edit(0, $record, 'Użytkownik o takiej nazwie już istnieje');
    	return;
    }

    $this->index_page();

  }
  
  public function getURIMethods()
  {
      return array('add','edit','delete','save');
  }
  public function notFound()
  {
    $this->view->apply('not_found.php');
  }
}