<?php
/**
 * Provide school table CRUD functionality
 */
class SchoolRepository extends PDORepository
{
  /**
   * @return school record
   */
  public function getAllSchools()
  {
    $q = $this->connection->prepare('SELECT ID, school_name FROM schools');
    $q->execute();
    return $q->fetchAll(PDO::FETCH_OBJ);
  } 
  
  /**
   * Get school by id
   * @param int $id
   * @return object school record
   */
  public function getSchoolByID($id)
  {
    $q = $this->connection->prepare('SELECT ID, school_name FROM schools WHERE ID = :id');
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    $q->execute();
    return $q->fetch(PDO::FETCH_ASSOC);
  }
  
  public function saveSchool($id = 0, $record)
  {
  	$q = $this->connection->prepare('SELECT 1 FROM schools WHERE school_name = :school_name');
    $q->bindValue(':school_name', $record['school_name'], PDO::PARAM_STR);
  	$q->execute();
  	
	if($q->fetch())
		return false;
  	
    if($id) return $this->updateSchool($id, $record);
    return $this->insertSchool($record);   
  }
  
  protected function updateSchool($id, $record)
  {
    $q = $this->connection->prepare('UPDATE schools SET school_name = :name WHERE ID = :id');
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    $q->bindValue(':name', $record['school_name'], PDO::PARAM_STR);
    return $q->execute();
  }
  protected function insertSchool($record)
  {
    $q = $this->connection->prepare('INSERT INTO schools(ID,school_name) VALUES(DEFAULT,:school_name)');
    $q->bindValue(':school_name', $record['school_name'], PDO::PARAM_STR);
    return $q->execute();
  }
  public function removeSchoolById($id)
  {
    $q = $this->connection->prepare('DELETE FROM schools WHERE ID = :id');
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    return $q->execute();
  }
  
  /**
   * School_name": {
     "key" : $i,
     "defaultvalue" : 0,
     "values" : {
           "room name": rooom_id,
           "potato": 111,
           "asparagus": 112
           }
   */
  public function getAllSchoolsWithRooms()
  {
    $q = $this->connection->prepare('SELECT
      s.school_name, r.room_name, r.ID as room_id, s.ID as school_id
      FROM schools s
      LEFT JOIN rooms r ON
        r.school_id = s.ID
    ');
    $q->execute();
    
    //build rows
    $rows = array();
    while ($r = $q->fetch(PDO::FETCH_ASSOC))
    {
      $rows[$r['school_name']]['key'] = $r['school_id'];
      $rows[$r['school_name']]['default_value'] = 0;
      $rows[$r['school_name']]['values'][$r['room_name']] = $r['room_id'];
    }
    return $rows;
  }
}