<?php
/**
 * Provide school table CRUD functionality
 */
class TeacherRepository extends PDORepository
{
  /**
   * @return teacher records
   */
  public function getAllTeachers()
  {
    $q = $this->connection->prepare('SELECT 
        t.ID, 
        r.room_name, 
        t.username, 
        t.password 
      FROM teachers t
      LEFT JOIN rooms r ON 
        r.ID = t.room_id
    ');
    $q->execute();
    return $q->fetchAll(PDO::FETCH_OBJ);
  } 
  
  /**
   * get teacher by id
   * @param int $id
   * @return array
   */
  public function getTeacherById($id)
  {
    $q = $this->connection->prepare('SELECT 
        t.ID, 
        t.room_id, 
        t.username, 
        t.password 
      FROM teachers t
      WHERE
        t.ID = :id
    ');
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    $q->execute();

    return $q->fetch(PDO::FETCH_ASSOC);
  }
  
  /**
   * 
   */
  public function saveTeacher($id, $hash)
  {
  	$q = $this->connection->prepare('SELECT 1 FROM teachers WHERE username = :username');
  	$q->bindValue(':username', $hash['username'], PDO::PARAM_STR);
  	$q->execute();
  	
  	if($q->fetch())
  		return false;
  	
    if ($id) return $this->updateTeacher($id, $hash);
    return $this->insertTeacher($hash);
  }
  
  protected function updateTeacher($id, $hash)
  {
    $q = $this->connection->prepare('UPDATE teachers SET room_id = :room_id, username = :username, password = :password WHERE ID = :id');
    $q->bindValue(':room_id', $hash['room_id'], PDO::PARAM_INT);
    $q->bindValue(':username', $hash['username'], PDO::PARAM_STR);
    $q->bindValue(':password', $hash['password'], PDO::PARAM_STR);
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    return $q->execute();
  }
  
  protected function insertTeacher($hash)
  {
    $q = $this->connection->prepare('INSERT INTO teachers SET room_id = :room_id, username = :username, password = :password');
    $q->bindValue(':room_id', $hash['room_id'], PDO::PARAM_INT);
    $q->bindValue(':username', $hash['username'], PDO::PARAM_STR);
    $q->bindValue(':password', $hash['password'], PDO::PARAM_STR);
    return $q->execute();
  }
 
  
  public function addNewTeacher()
  {
     $q = $this->connection->prepare('INSERT INTO teachers(ID,username) VALUES(DEFAULT,"")');
     $q->execute();
     return $this->connection->lastInsertId();
  }
  
  public function removeTeacherById($id)
  {
    $q = $this->connection->prepare('DELETE FROM teachers WHERE ID = :id');
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    return $q->execute();
  }
}