$('.DataGrid > tbody > tr').mouseover(function () {
  $(this).addClass('ui-state-active');
});

$('.DataGrid > tbody > tr').mouseout(function () {
  $(this).removeClass('ui-state-active');
});

/* data grid search functionality */
$('.DataGrid .LightSearch .search').keyup(function(){
  var search = $.trim($(this).val().toLowerCase());
  if(!search)//no search terms
  {
    $('.DataGrid tbody tr').each(function(){ $(this).show() });
  }
  else//search for term
  {
    $('.DataGrid tbody tr').each(function(){
      var found = false;
      $(this).find('td.Searchable').each(function(){
        if($.trim($(this).html().toLowerCase()).indexOf(search)>-1) found = true;
      });
      if(found) $(this).show();
      else $(this).hide();
    });
    
  }
});

/* provide data grid sorting */
var _sortOrder = 'asc';
$('.DataGrid > thead > tr > th.Sortable').append('<span class="ui-icon" style="float:left; visibility: hidden"></span>');
$('.DataGrid > thead > tr > th.Sortable').click(function() {
  $('.DataGrid > thead > tr > th.Sortable > span.ui-icon').css('visibility', 'hidden');
  
  var columnName = $(this).attr('class').replace('Sortable','').replace(/\s/gim,'').replace('asc','').replace('desc','');  
  $(".DataGrid > tbody > tr").tsort("td." + columnName,{'order':_sortOrder});

  if(_sortOrder == 'asc') {
    _sortOrder = 'desc';
    $(this).children('span.ui-icon').removeClass('ui-icon-triangle-1-s');
    $(this).children('span.ui-icon').addClass('ui-icon-triangle-1-n');
  } else {
    _sortOrder = 'asc';
    $(this).children('span.ui-icon').removeClass('ui-icon-triangle-1-n');
    $(this).children('span.ui-icon').addClass('ui-icon-triangle-1-s');
  }
  $(this).children('span.ui-icon').css('visibility', 'visible');
});
