var JS = (function()
{
  return {
    /**
     * JS.Class(classData)
     *
     * provide class construct mechanism
     * 
     * @param Object classData - object defining class body
     * @return function - object constructor
     */
    Class: function (classBody)
    {
      var classBody = classBody;
      return function()
      {
        //define classScope
        var classScope = this;
        
        //provide classBody
        JS.extend(this, classBody);
        
        /**
         * var BaseClass = new JS.Class({construct: function});
         * 
         * provide simple constructor for a class
         */
        if(this.construct !== undefined && typeof this.construct === 'function')
        {
          this.construct.apply(this, arguments);
        }
        
        /**
         * var BaseClass = new JS.Class({inherits: InheritedClass});
         * 
         * inherit all methods and properties from InheritedClass
         */
        if(this.inherits !== undefined && typeof this.inherits === 'function')
        {
          JS.extend(this, new this.inherits());
        } 
      };
    },
    /**
     * JS.extend(target, extensions)
     *
     * provide simple extension mechanism
     *
     * @param Object target - object to extend
     * @param Object extensions - object which will be extending the target
     * @return Object - extended object
     */
    extend: function(target, extensions)
    {
      extensions = extensions || {};
      for(var property in extensions)
      {
        if(target[property] !== extensions[property])
        {
          target[property] = extensions[property];
        }
      }
      return target;
    }
  };
})();

/**
 * Additional Libaries
 * EventDispatcher, 
 */
(function(){
  JS.EventDispatcher = new JS.Class({
    listeners : new Array(),
    addEventListener : function(event, fn) 
    {
      if(!this.listeners[event] instanceof Array)
      {
        this.listeners[event] = new Array();
      }
      this.listeners[event].push(fn);
    },
    dispatchEvent : function(event)
    {
      
    },
    hasEventListener : function(event)
    {
    },
    removeEventListener : function(event)
    {
    }
  });
})();