<?php
class ConfigurationException extends Exception { }

/**
 * Configuration reader class
 * @todo: implement write methods
 * @package system
 */
class Configuration
{
    protected $configFilename;
    private $writeable = false;
    private $configData = array();

    public function __construct ($config)
    {
    //print_r($_CONFIG);
       $this->configData = $config;
    }

    public function __get ($name)
    {
        return $this->configData[$name];
    }
    
    public function __sleep ()
    {
        return array('configFilename');
    }

    public function __wakeup ()
    {
        $this->parseConfig($this->configFilename);
    }
    
    /**
     *  Is config writeable
     * @return bool 
     */
    public function isWritable ()
    {
        return $this->writeable;
    }
    
    /**
     * Parse config
     */
    private function parseConfig ()
    {

    }
}