<?php
/**
 * Plugin registry class
 * Register events and plugins to be dispatched
 */
class PluginRegistryException extends Exception {}
class PluginRegistry
{
    const HIGH_PRIORITY = 0;
    const LOW_PRIORITY = 2;
    const NORMAL_PRIORITY = 1;
    
    private static $pluginRepository = array();
    private static $instancedPlugins = array();
    
    /**
     * Initialize plugin registry
     * @return type 
     */
    public static function init()
    {
        $pluginDir = APPLICATION_DIR . '/protected/plugins/';
        if (!file_exists($pluginDir))
        {
            return;
        }
        $pluginDir = new DirectoryIterator($pluginDir);
        foreach ($pluginDir as $fnfo)
        {
            if ($fnfo->isFile() && $fnfo->isReadable())
            {
                require_once $fnfo->getRealPath();
            }
        }
    }
    
    /**
     * Run event and pass context
     * @param string $event 
     * @param mixed $object context
     * @throws PluginRegistryException
     */
    public static function run($event, $object)
    {
        if (!key_exists($event, self::$pluginRepository)) return;
        ksort(self::$pluginRepository[$event]);
        foreach (self::$pluginRepository[$event] as &$priorities)
        {
            ksort($priorities);
            foreach ($priorities as $plugin)
            {
                if(is_string($plugin) && function_exists($plugin)) 
                {
                    call_user_func($plugin, $object);
                }
                else
                {
                    throw new PluginRegistryException('Plugin must be instance of Closure or proper function name');
                }
            }
        }
    }
    
    /**
     * Register plugin
     * @param string $event
     * @param \Closure $plugin
     * @param int $priority 
     */
    public static function register($event, $plugin, $priority = self::NORMAL_PRIORITY)
    {
        //build path
        self::$pluginRepository[$event][$priority][] = $plugin;
    }
}