/* 
* Initializion point:
* 
* this function is called as soon as the extension
* is loaded in the server.
* 
* You can add here all the initialization code
* 
*/
var dbase;
var interval;

function init()
{
	//trace("Extension initialized")
	
	connectDB();
	
	var sql = "SELECT room_name, max_users, school_id FROM class";
	
	var queryRes = dbase.executeQuery(sql);
	var tempRow;
	var roomObj;
	var newRoom;
	
	for (i = 0; i < queryRes.size(); i++)
	{
		tempRow = queryRes.get(i);
		
		roomObj = { }
		
		if (String(tempRow.getItem("room_name")) == "WaitingRoom")
		{
			roomObj.name = tempRow.getItem("room_name");
		}
		else
		{
			roomObj.name = String(tempRow.getItem("school_id")) + "_" + tempRow.getItem("room_name");
		}	
		
		roomObj.maxU = tempRow.getItem("max_users");

		newRoom = _server.createRoom(roomObj, null)
	}	
	
	waitingRoomObj = {}
	waitingRoomObj.name = "WaitingRoom"
	waitingRoomObj.maxU = 99999;

	newRoom = _server.createRoom(waitingRoomObj, null)
}


/*
* This method is called by the server when an extension
* is being removed / destroyed.
* 
* Always make sure to release resources like setInterval(s)
* open files etc in this method.
* 
* In this case we delete the reference to the databaseManager
*/
function destroy()
{
	//trace("Extension destroyed")
	delete dbase;
}


/*
* 
* Handle Client Requests
* 
* cmd 		= a string with the client command to execute 
* params 	= list of parameters expected from the client
* user 		= the User object representing the sender
* fromRoom 	= the id of the room where the request was generated
* 
*/
function handleRequest(cmd, params, user, fromRoom)
{
	if (cmd == "restoreData")
	{
		var sql = "SELECT * FROM student WHERE id = " + _server.escapeQuotes(params.userId);
		
		var queryRes = dbase.executeQuery(sql);
		
		var responseObject = { };
		responseObject._cmd = cmd;
		
		var tempRow;
		
		if (queryRes != null && queryRes != undefined && queryRes.size() > 0)
		{
			tempRow = queryRes.get(0);
			
			responseObject.cash = tempRow.getItem("cash");
			responseObject.loan = tempRow.getItem("loan");
			responseObject.loanRate = tempRow.getItem("loan_rate");
			responseObject.loanLength = tempRow.getItem("loan_length");
			responseObject.fieldSizeX = tempRow.getItem("field_size_x");
			responseObject.fieldSizeY = tempRow.getItem("field_size_y");
		}
		
		sql = "SELECT building_id,product_id,amount,progress FROM products_in_progress WHERE owner = " + _server.escapeQuotes(params.userId);
		
		queryRes = dbase.executeQuery(sql);
		
		if (queryRes != null && queryRes != undefined && queryRes.size() > 0)
		{
			responseObject.buildingProducts = [];
			
			for (i = 0; i < queryRes.size(); i++)
			{
				tempRow = queryRes.get(i);
				
				var item = {};
				
				item.id = tempRow.getItem("product_id");
				item.amount = tempRow.getItem("amount");
				item.buildingId = tempRow.getItem("building_id");
				item.progress = tempRow.getItem("progress");
				
				responseObject.buildingProducts.push(item);
			}
		}
		
		sql = "SELECT product_id,type,amount FROM products_in_warehouse WHERE owner = " + _server.escapeQuotes(params.userId);
		
		queryRes = dbase.executeQuery(sql);
		
		if (queryRes != null && queryRes != undefined && queryRes.size() > 0)
		{
			responseObject.warehouseProducts = [];
			
			for (i = 0; i < queryRes.size(); i++)
			{
				tempRow = queryRes.get(i);
				
				var item = {};
				
				item.id = tempRow.getItem("product_id");
				item.amount = tempRow.getItem("amount");
				item.type = tempRow.getItem("type");
				
				responseObject.warehouseProducts.push(item);
			}
		}
		
		sql = "SELECT ID,product_id,amount,price FROM products_on_marketplace WHERE owner = " + _server.escapeQuotes(params.userId);
		
		queryRes = dbase.executeQuery(sql);
		
		if (queryRes != null && queryRes != undefined && queryRes.size() > 0)
		{
			responseObject.marketplaceProducts = [];
			
			for (i = 0; i < queryRes.size(); i++)
			{
				tempRow = queryRes.get(i);
				
				var item = {};
				
				item.dbId = tempRow.getItem("ID");
				item.id = tempRow.getItem("product_id");
				item.amount = tempRow.getItem("amount");
				item.price = tempRow.getItem("price");
				
				responseObject.marketplaceProducts.push(item);
			}
		}
		
		sql = "SELECT ID, type_id, x, y, level, upgrade_progress FROM user_has_buildings WHERE owner = " + _server.escapeQuotes(params.userId);
		
		queryRes = dbase.executeQuery(sql);
		
		if (queryRes != null && queryRes != undefined && queryRes.size() > 0)
		{
			responseObject.buildings = [];
			
			for (i = 0; i < queryRes.size(); i++)
			{
				tempRow = queryRes.get(i);
				
				var item = {};
				
				item.dbId = tempRow.getItem("ID");
				item.typeId = tempRow.getItem("type_id");
				item.x = tempRow.getItem("x");
				item.y = tempRow.getItem("y");
				item.level = tempRow.getItem("level");
				item.progress = tempRow.getItem("upgrade_progress");
				
				responseObject.buildings.push(item);
			}
		}
		
		_server.sendResponse(responseObject, -1, null, [user])
	}
	else if (cmd == "createNewRoom")
	{
		var sql = "SELECT room_name, max_users, school_id FROM class";
	
		var queryRes = dbase.executeQuery(sql);
		var tempRow;
		var roomObj;
		var newRoom;
		
		var zone = _server.instance.getZone("eduFarma");
		var rooms = zone.getRooms();
		var roomCount = rooms.length;
				
		for (i = 0; i < queryRes.size(); i++)
		{
			tempRow = queryRes.get(i);
			var correct = true;		
			
			for (var j = 0; j < roomCount; j++)
			{
				if (String(rooms[j].getName()) ==  String(String(tempRow.getItem("school_id")) + "_" + tempRow.getItem("room_name")))
				{
					correct = false;
					break;
				}
			}
			
			if (!correct) continue;
			
			roomObj = {}
			roomObj.name = String(String(tempRow.getItem("school_id")) + "_" + tempRow.getItem("room_name"));
			roomObj.maxU = tempRow.getItem("max_users");

			newRoom = _server.createRoom(roomObj, null)
		}
	}
	else if (cmd == "removeRoom")
	{
		var sql = "SELECT room_name, school_id FROM class";
		
		var queryRes = dbase.executeQuery(sql);
		var tempRow;
		var roomObj;
		
		var zone = _server.instance.getZone("eduFarma");
		var rooms = zone.getRooms();
		var roomCount = rooms.length;
		
		var roomNames = [];
		
		for (i = 0; i < queryRes.size(); i++)
		{
			tempRow = queryRes.get(i);
			roomNames.push(String(String(tempRow.getItem("school_id")) + "_" + tempRow.getItem("room_name")));
		}
		
		var namesCount = roomNames.length;
		
		for (var i = 0; i < roomCount; i++)
		{
			var correct = false;
			
			for (var j = 0; j < namesCount; j++)
			{
				if (String(rooms[i].getName()) ==  String(roomNames[j]))
				{
					correct = true;
					break;
				}
			}
			
			if (correct) continue;
			
			_server.destroyRoom(zone, rooms[i].getId());
		}	
	}
	
}

function connectDB()
{
   var driverName = "org.gjt.mm.mysql.Driver"
   //var connString = "jdbc:mysql://localhost/edufarma"
   //var usrName = "root"
   //var pword = "17qW1"
   var connString = "jdbc:mysql://localhost:3306/EduFarma"
   var usrName = "edufarma"
   var pword = "edu.farma.test.OVH#456!"
   var connName = "myDbConnection"
   var maxActive = 10
   var maxIdle = 10
   var exhaustedAction = "fail"
   var blockTime = 5000
   
   dbase = new __db.DbManager(   
						   driverName,
                           connString,
                           usrName,
                           pword,
                           connName,
                           maxActive,
                           maxIdle,
                           exhaustedAction,
                           blockTime
                       )   
					   
	// Get a reference to the Zone where the target extension is running
	var zone = _server.instance.getZone("eduFarma");	
	
	var item = { };
	item.dbManager = dbase;
	
	// Get a reference to the Extension we want to call
	var targetExtension = zone.getExtension("usersExt");
	
	targetExtension.handleInternalRequest(item)
	
	// Get a reference to the Extension we want to call
	targetExtension = zone.getExtension("warehouseExt");
	
	targetExtension.handleInternalRequest(item)
	
	// Get a reference to the Extension we want to call
	targetExtension = zone.getExtension("buildingsExt");
	
	targetExtension.handleInternalRequest(item)
	
	// Get a reference to the Extension we want to call
	targetExtension = zone.getExtension("productionExt");
	
	targetExtension.handleInternalRequest(item)
	
	// Get a reference to the Extension we want to call
	targetExtension = zone.getExtension("financesExt");
	
	targetExtension.handleInternalRequest(item) 
	
	// Get a reference to the Extension we want to call
	targetExtension = zone.getExtension("shopExt");
	
	targetExtension.handleInternalRequest(item)	
	
	// Get a reference to the Extension we want to call
	targetExtension = zone.getExtension("historyExt");
	
	targetExtension.handleInternalRequest(item)	
}


/*
* This method handles internal events
* Internal events are dispactched by the Zone or Room where the extension is attached to
* 
* the (evt) object
*/
function handleInternalEvent(evt)
{
	// Add your code here
}
