/* 
* Initializion point:
* 
* this function is called as soon as the extension
* is loaded in the server.
* 
* You can add here all the initialization code
* 
*/
var dbase;

function init()
{
	//trace("Extension initialized")
}


/*
* This method is called by the server when an extension
* is being removed / destroyed.
* 
* Always make sure to release resources like setInterval(s)
* open files etc in this method.
* 
* In this case we delete the reference to the databaseManager
*/
function destroy()
{
	//trace("Extension destroyed")
	delete dbase;
}


/*
* 
* Handle Client Requests
* 
* cmd 		= a string with the client command to execute 
* params 	= list of parameters expected from the client
* user 		= the User object representing the sender
* fromRoom 	= the id of the room where the request was generated
* 
*/
function handleRequest(cmd, params, user, fromRoom)
{	
	var sql;
	var queryRes;
	var response = {};
	
	response._cmd = cmd;
	
	if (cmd == "setRoundHistory")
	{
		if (params.round == 1)
		{
			sql = "INSERT INTO rounds (round_number, room_id) VALUES (";
			sql += params.round + ", ";
			sql += params.room + ")";
		}
		else
		{
			sql = "UPDATE rounds SET round_number = ";
			sql += params.round + " WHERE room_id = ";
			sql += params.room;
		}
		
		//trace("ROUND SQL: " + sql);
		
		queryRes = dbase.executeCommand(sql);				
	}
	else if (cmd == "setFinancesHistory")
	{
		sql = "INSERT INTO finances_history (user_id, round_number, money, income, loan, buildings_cost, upgrades_cost, expand_cost, production_cost, paid_loan_rate) VALUES (";
		sql += params.userId + ", ";
		sql += params.roundNumber + ", ";
		sql += params.money + ", ";
		sql += params.income + ", ";
		sql += params.loan + ", ";
		sql += params.buildingsCost + ", ";
		sql += params.upgradesCost + ", ";
		sql += params.expandCost + ", ";
		sql += params.productionCost + ", ";
		sql += params.paidLoanRate + ")";
		
		//trace("FINANCES SQL: " + sql);
		
		queryRes = dbase.executeCommand(sql);
		
		sql = "SELECT LAST_INSERT_ID() AS id FROM rounds"
		
		queryRes = dbase.executeQuery(sql);
								
		var tempRow = queryRes.get(0);
		response.financesId = tempRow.getItem("id");
	}
	else if (cmd == "setOfferHistory")
	{
		sql = "INSERT INTO offer_history (round_number, room_id, user_id, product_id, offer_amount, offer_price, bought_amount) VALUES (";
		sql += params.roundNumber + ", ";
		sql += params.roomId + ", ";
		sql += params.userId + ", ";
		sql += params.productId + ", ";
		sql += params.amount + ", ";
		sql += params.price + ", ";
		sql += params.boughtAmount + ")";
		
		//trace("OFFER SQL: " + sql);
		
		queryRes = dbase.executeCommand(sql);
		
		sql = "SELECT LAST_INSERT_ID() AS id FROM rounds"
		
		queryRes = dbase.executeQuery(sql);
								
		var tempRow = queryRes.get(0);
		response.financesId = tempRow.getItem("id");
	}
	if (cmd == "getRoundHistory")
	{
		sql = "SELECT ID, round_number FROM rounds WHERE room_id = ";
		sql += params.roomId;
		
		//trace("ROUND SQL: " + sql);
		
		queryRes = dbase.executeQuery(sql);
				
		if (queryRes && queryRes.size() > 0)
		{			
			tempRow = queryRes.get(0);
			response.rounds = {roundId:tempRow.getItem("ID"), roundNumber:tempRow.getItem("round_number")};			
		}		
	}
	else if (cmd == "getFinancesHistory")
	{
		sql = "SELECT round_number, money, income, loan, buildings_cost, upgrades_cost, expand_cost, production_cost, paid_loan_rate FROM finances_history WHERE user_id = ";
		sql += params.userId;
		
		queryRes = dbase.executeQuery(sql);
				
		if (queryRes && queryRes.size() > 0)
		{
			var tempRow;
			response.finances = [];
					
			for (var i = 0; i < queryRes.size(); i++)
			{
				tempRow = queryRes.get(i);
				response.finances.push( { roundNumber: tempRow.getItem("round_number"),
										  money: tempRow.getItem("money"),
										  income: tempRow.getItem("income"),
										  loan: tempRow.getItem("loan"),
										  buildingsCost: tempRow.getItem("buildings_cost"),
										  upgradesCost: tempRow.getItem("upgrades_cost"),
										  expandCost: tempRow.getItem("expand_cost"),
										  productionCost: tempRow.getItem("production_cost"),
										  paidLoanRate: tempRow.getItem("paid_loan_rate") });
			}
		}
	}
	else if (cmd == "getOfferHistory")
	{
		sql = "SELECT round_number, product_id, offer_amount, offer_price, bought_amount FROM offer_history WHERE offer_history.room_id = ";
		sql += params.roomId + " AND user_id = ";
		sql += params.userId + " ORDER BY round_number DESC";
		
		queryRes = dbase.executeQuery(sql);
								
		if (queryRes && queryRes.size() > 0)
		{
			var tempRow;
			response.offers = [];
			
			for (var i = 0; i < queryRes.size(); i++)
			{
				tempRow = queryRes.get(i);
				response.offers.push( { roundNumber: tempRow.getItem("round_number"),
										productId: tempRow.getItem("product_id"),
										offerAmount: tempRow.getItem("offer_amount"),
										offerPrice: tempRow.getItem("offer_price"),
										boughtAmount: tempRow.getItem("bought_amount") });
			}
		}
	}
	else if (cmd == "getFullOfferHistory")
	{
		sql = "SELECT round_number, user_id, product_id, offer_amount, offer_price, bought_amount FROM offer_history WHERE offer_history.room_id = ";
		sql += params.roomId + " ORDER BY round_number DESC";
		
		queryRes = dbase.executeQuery(sql);
								
		if (queryRes && queryRes.size() > 0)
		{
			var tempRow;
			response.offers = [];
			
			for (var i = 0; i < queryRes.size(); i++)
			{
				tempRow = queryRes.get(i);
				response.offers.push( { roundNumber: tempRow.getItem("round_number"),
										userId: tempRow.getItem("user_id"),
										productId: tempRow.getItem("product_id"),
										offerAmount: tempRow.getItem("offer_amount"),
										offerPrice: tempRow.getItem("offer_price"),
										boughtAmount: tempRow.getItem("bought_amount") });
			}
		}
	}
	
	_server.sendResponse(response, -1, null, [user])
}

function handleInternalRequest(evt)
{
	if (evt.dbManager)
	{
		dbase = __db.DbManager(evt.dbManager);
	}
}

/*
* This method handles internal events
* Internal events are dispactched by the Zone or Room where the extension is attached to
* 
* the (evt) object
*/
function handleInternalEvent(evt)
{
	// Add your code here
}