/* 
* Initializion point:
* 
* this function is called as soon as the extension
* is loaded in the server.
* 
* You can add here all the initialization code
* 
*/

var dbase;
var paramsObject
var processCount
var interval
var terminate = false;

function init()
{
	//trace("Extension initialized")
	
	paramsObject = new Object();
	processCount = 0;
	interval = 0;
}


/*
* This method is called by the server when an extension
* is being removed / destroyed.
* 
* Always make sure to release resources like setInterval(s)
* open files etc in this method.
* 
* In this case we delete the reference to the databaseManager
*/
function destroy()
{
	//trace("Extension destroyed")
	delete dbase;
}


/*
* 
* Handle Client Requests
* 
* cmd 		= a string with the client command to execute 
* params 	= list of parameters expected from the client
* user 		= the User object representing the sender
* fromRoom 	= the id of the room where the request was generated
* 
*/
function handleRequest(cmd, params, user, fromRoom)
{
	if (cmd == "terminateProcess")
	{
		terminate = true;
	}
	else
	{
		//trace(params.structureID + " " + params.amount + " " + params.totalTime);
		
		params.processLength = params.totalTime;
		params.userServerId = user.getUserId();
		
		if (paramsObject["values"] == null || paramsObject["values"] == undefined) paramsObject["values"] = [];
		paramsObject["values"].push(params);
		processCount++;
		
		var sql;
				
		sql = "SELECT ID FROM products_in_progress "
		sql += " WHERE building_id = " + params.dbId;
		sql += " AND owner = " + params.userId;
		
		//trace(sql);
		
		var queryRes = dbase.executeQuery(sql);
		
		if (queryRes && queryRes.size() > 0)
		{			
			sql = "UPDATE products_in_progress SET amount = "
			sql += "'" + _server.escapeQuotes(params.amount) + "', progress = 1"
			sql += " WHERE building_id = " + params.dbId;
			sql += " AND owner = " + params.userId;
		}
		else
		{
			sql = "INSERT INTO products_in_progress (owner, building_id, product_id, amount, progress) VALUES ("
			sql += "'" + _server.escapeQuotes(params.userId) + "', "
			sql += "'" + _server.escapeQuotes(params.dbId) + "', "
			sql += "'" + _server.escapeQuotes(params.productId) + "', "
			sql += "'" + _server.escapeQuotes(params.amount) + "', "
			sql += "1)"
		}
		
		//trace(sql);

		var res = dbase.executeCommand(sql);
		
		//trace("QUERY: " + res);
		
		if (interval == 0) interval = (setInterval("processUpdate", 1000));
	}
}

function processUpdate()
{
	var toRemove = [];
	
	for (i = 0; i < processCount; i++)
	{	
		if (paramsObject["values"][i].totalTime <= 0 || terminate)
		{		
			if (terminate)
			{
				var sql = "UPDATE products_in_progress SET progress = "
				sql += "'" + _server.escapeQuotes(Math.round((parseInt(paramsObject["values"][i].totalTime) / parseInt(paramsObject["values"][i].processLength)) * 100)) + "'"
				sql += " WHERE building_id = " + paramsObject["values"][i].dbId;
				sql += " AND owner = " + paramsObject["values"][i].userId;
				
				dbase.executeCommand(sql);
			}
			else
			{
				var sql = "UPDATE products_in_progress SET progress = 0, amount = " + paramsObject["values"][i].amount
				sql += " WHERE building_id = " + paramsObject["values"][i].dbId;
				sql += " AND owner = " + paramsObject["values"][i].userId;
				
				dbase.executeCommand(sql);
			}
			
			//paramsObject["values"].splice(i, 1);
			
			toRemove.push(i);
			processCount--;
		}
		else
		{
			paramsObject["values"][i].totalTime--;
		}
	}
	
	for (i = 0; i < toRemove.length; i++)
	{
		paramsObject["values"].splice(toRemove[i], 1);
		
		for (var j = i; j < toRemove.length; j++)
		{
			if (toRemove[j] > toRemove[i])
			{
				toRemove[j]--;
			}
		}
	}
	
	if (processCount == 0)
	{
		clearInterval(interval);
		interval = 0;
		paramsObject["values"] = null;
	}
}

function handleInternalRequest(evt)
{
	if (evt.dbManager)
	{
		dbase = __db.DbManager(evt.dbManager);
	}
	else if (evt.cmd == "terminateProcess")
	{
		var toRemove = [];
		
		for (i = 0; i < processCount; i++)
		{	
			if (parseInt(paramsObject["values"][i].userServerId) == parseInt(evt.userServerId))
			{
				toRemove.push(i);
				processCount--;
			}
		}
		
		if (toRemove.length == 0) return;
		
		for (i = 0; i < toRemove.length; i++)
		{
			paramsObject["values"].splice(toRemove[i], 1);
			
			for (var j = i; j < toRemove.length; j++)
			{
				if (toRemove[j] > toRemove[i])
				{
					toRemove[j]--;
				}
			}
		}
	}
}

/*
* This method handles internal events
* Internal events are dispactched by the Zone or Room where the extension is attached to
* 
* the (evt) object
*/
function handleInternalEvent(evt)
{
	// Add your code here
}

