/* 
* Initializion point:
* 
* this function is called as soon as the extension
* is loaded in the server.
* 
* You can add here all the initialization code
* 
*/
var dbase;
var globalUser;
var _shops;
var _players;
var transportAmount = 100;
var transportCost = 0;
var xmlDoc;

function init()
{
	//trace("Extension initialized")
	
	// Read xml file from disk
	//var xmlData = _server.readFile("xml/shopConfig.xml")
	////trace(xmlData);
	//
	// Create an XML object
	//xmlObj = new XML(xmlData)
	nanoxml = Packages.net.n3.nanoxml
        
    readTheXmlFile()
}

/*
* Read and parse the XML file
*/
function readTheXmlFile()
{
        // Setup the xml parser object
        var xmlParser = nanoxml.XMLParserFactory.createDefaultXMLParser()
        
        // This is the XML Reader:
        // You can use a fileReader, to read the XML from a file
        // or the StringReader, to read the XML from a string
        var xmlReader = nanoxml.StdXMLReader.fileReader("sfsExtensions/data/shopConfig.xml")
        
        // Assign the reader to the parser
        xmlParser.setReader(xmlReader)
        
        // Finally parse the XML
        xmlDoc = xmlParser.parse()
		
		populateShops();
}

function populateShops()
{
        //Get the tag called <collectionOwner></collectionOwner>
        var node;
        
        //book is a java.util.Enumeration object
        var shopsList = xmlDoc.enumerateChildren()
        
        //Cycle through each element in the Enumeration
        
		_shops = [];
		
        while (shopsList.hasMoreElements())
        {
			var shop = shopsList.nextElement()
			
			var shopInstance = { };
			shopInstance.name = shop.getFirstChildNamed("name").getContent();
			shopInstance.productsList = {};
			shopInstance.purchaseList = [];
			
			//Get the tag called <collectionOwner></collectionOwner>
			node = shop.getFirstChildNamed("demands")
			
			//book is a java.util.Enumeration object
			var products = node.enumerateChildren()
			
			//Cycle through each element in the Enumeration
			
			while (products.hasMoreElements())
			{
				var product = products.nextElement()
				
				shopInstance.productsList[product.getFirstChildNamed("productId").getContent()] = { productName:product.getFirstChildNamed("productName").getContent(),
																									demand:parseInt(product.getFirstChildNamed("demand").getContent()),
																									maxPrice:parseInt(product.getFirstChildNamed("maxPrice").getContent()),
																									id:product.getFirstChildNamed("productId").getContent() };
			}
			
			_shops.push(shopInstance);
        }
		
}


/*
* This method is called by the server when an extension
* is being removed / destroyed.
* 
* Always make sure to release resources like setInterval(s)
* open files etc in this method.
* 
* In this case we delete the reference to the databaseManager
*/
function destroy()
{
	//trace("Extension destroyed")
	delete dbase;
}


/*
* 
* Handle Client Requests
* 
* cmd 		= a string with the client command to execute 
* params 	= list of parameters expected from the client
* user 		= the User object representing the sender
* fromRoom 	= the id of the room where the request was generated
* 
*/
function handleRequest(cmd, params, user, fromRoom)
{
	
}

function AI(shops, players, users, room, roomName) 
{		
	_shops = shops;
	_players = players;
	
	//shuffleVector(_shops);
		
	var limiter = _shops.length;
	
	for (var i = 0; i < limiter; i++)
	{
		buyAllProducts(_shops[i]);
	}
	
	sql = "SELECT id FROM class WHERE room_name = '" + _server.escapeQuotes(roomName.split("_")[1]) + "' AND school_id = " + _server.escapeQuotes(roomName.split("_")[0]);
		
	
	var queryRes = dbase.executeQuery(sql);
	
	var tempRow = queryRes.get(0);
	var dbRoomId = tempRow.getItem("id");
	
	//trace("DB ROOM ID: " + dbRoomId);
	
	sql = "SELECT ID, round_number FROM rounds WHERE room_id = " + dbRoomId + " LIMIT 1";
		
	queryRes = dbase.executeQuery(sql);
	
	tempRow = queryRes.get(0);
	
	var value = tempRow.getItem("round_number");
	
	//trace("ROUND NUMBER: " + value);
	
	var roundNumber = parseInt(value);	
		
	var zone = _server.instance.getZone("eduFarma");
	var targetExtension = zone.getExtension("usersExt");
	
	var item = {};
	item.cmd = "endSimulation";
	item.roundId = tempRow.getItem("ID");
	item.roundNumber = roundNumber;
	item.players = _players;
	item.recipients = users;
	item.room = room;
		
	targetExtension.handleInternalRequest(item);
}
		
function shuffleVector(vec)
{
	if (vec.length > 1)
	{
		var i = vec.length - 1;
		while (i > 0)
		{
			var s = Math.random()*vec.length;
			var temp = vec[s];
			vec[s] = vec[i];
			vec[i] = temp;
			i--;
		}
	}			
}
		
function buyProduct(currentShop,shopProduct)
{
	var profitArray = [];
		
	//each players in game
	var limiter = _players.length;
	
	for (var i = 0; i < limiter; i++ )
	{	
		if (_players[i].productsList == undefined) continue;
		
		for (var j in _players[i].productsList)
		{			
			if (_players[i].productsList[j].typeId != parseInt(shopProduct.id)) continue;
			//trace("### LOL: " + _players[i].productsList[j].typeId + ", " + parseInt(shopProduct.id));
			
			//info about profit in player
			var info = calculateProductProfit(currentShop, shopProduct, _players[i], _players[i].productsList[j]);
			
			if (_players[i].productsList[j] == undefined)
			{
				//trace("Ziomek nie ma nic na sprzedaż");
			}
			else
			{
				//trace(currentShop.name + " chce kupic od gracza: " + _players[i].name + " produkt o id: " + _players[i].productsList[j].id + " w ilosci: " + shopProduct.demand + " w cenie: " + _players[i].productsList[j].price);
			}
			
			//save result to array
			if (info.transactionStatus == "ok")
			{
				//trace("## PUSH TO ARRAY: " + info.profit);
				profitArray.push(info);
			}
		}
	}
	
	//losowe wybieranie jak jest taka sama cena sprzedaży dla kilku graczy	
	var shopDemand = shopProduct.demand;
	
	if(profitArray.length > 0)
	{
		//sort by profits
		//profitArray.sortOn("profit", 2 | 16);
		
		quickSort(profitArray, profitArray.length - 1, 0);
		
		for (var k in profitArray)
		{
			//trace("INDEX: " + k + ", " +profitArray[k].profit)
		}
		
		var profit = profitArray.shift();
		shopDemand -= profit.amount;
					
		buy(currentShop, profit.player, profit.player.productsList[profit.productDbId], profit.amount, profit.price, profit.transportCost, profit.transportLeft);
		sell(profit.player, profit.productDbId, profit.amount);
		
		var sql = "UPDATE student SET cash = cash + " + _server.escapeQuotes(profit.amount * profit.price) + " WHERE student.id = " + _server.escapeQuotes(profit.player.id);
		
		dbase.executeCommand(sql);
		
		/*UPDATE CASH!*/
				
		var zoneF = _server.instance.getZone("eduFarma");
		var targetExtensionF = zoneF.getExtension("financesExt");

		var itemF = {};
		itemF.cmd = "syncCash"
		itemF.userId = _server.escapeQuotes(profit.player.id);

		targetExtensionF.handleInternalRequest(itemF);		
				
		if (profit.playerAmount <= 0)
		{
			sql = "DELETE FROM products_on_marketplace WHERE owner = '" + _server.escapeQuotes(profit.player.id) + "' AND ID = '" + _server.escapeQuotes(profit.productDbId) + "'";
		}
		else
		{	
			sql = "UPDATE products_on_marketplace SET amount = " + _server.escapeQuotes(profit.playerAmount) + " WHERE owner = '" + _server.escapeQuotes(profit.player.id) + "' AND ID = '" + _server.escapeQuotes(profit.productDbId) + "'";
		}
		
		dbase.executeCommand(sql);
		
		//trace("SQL: " + sql);
	}
		
	//shop need more products
	if (shopDemand > 0 && profitArray.length > 0)
	{
		//trace("## SHOP DEMAND LEFT: " + shopDemand + ", " + currentShop.name + ", " + shopProduct.productName);
		buyProduct(currentShop,shopProduct);
	}
}

function quickSort(arrayInput, left, right)
{
	var i = left;
	var j = right;
	
	pivotPoint = parseInt(arrayInput[Math.round((left + right) * .5)].profit);
	
	// Loop
	while (i <= j)
	{
		while (parseInt(arrayInput[i].profit) < pivotPoint)
		{
			i++;
		}
		
		while (parseInt(arrayInput[i].profit) > pivotPoint)
		{
			j--;
		}
		
		if (i <= j) 
		{
			tempStore = arrayInput[i];
			arrayInput[i] = arrayInput[j];
			i++;
			arrayInput[j] = tempStore;
			j--;
		}
	}
	
	// Swap
	if (left < j) 
	{
		quickSort(arrayInput, left, j);
	}

	if (i < right)
	{
		quickSort(arrayInput, i, right);
	}	
} 

function buy(currentShop, _player, _product, _amount, _price, _transportCost, _transportLeft)
{
	var limiter = currentShop.purchaseList.length;
	
	for (var i = 0; i < limiter; i++)
	{
		if(currentShop.purchaseList[i].player.id == _player.id)
		{
			currentShop.purchaseList[i].transportLeft = 0;
		}
	}
	
	currentShop.purchaseList.push( { player:_player, product:_product, amount:_amount, price:_price, transportCost:_transportCost, transportLeft:_transportLeft } );
	
	//trace("");
	//trace(currentShop.name + " kupil od gracza: " + _player.name + " produkt o id: " + _product.id + " w ilosci: " + _amount + " w cenie: " + _price + " placac za transport: " + _transportCost);
	
	getProductById(currentShop, _product.typeId).demand -= _amount;
}

function getProductById(shop, id)
{	
	for (var i in shop.productsList)
	{
		if (parseInt(shop.productsList[i].id) == id)
		{
			return shop.productsList[i];
		}
	}
	
	return {productName:"none", productGroup:"none", demand:-1, maxPrice:-1};
}

function sell(player, id, amount)
{	
	if (player.productsList[id] && player.productsList[id] != undefined)
	{
		player.productsList[id].amount -= amount;
	}
	
	//for (var i in player.productsList)
	//{
		//if(player.productsList[i].id == id)
		//{
			//player.productsList[i].amount -= amount;
			//break;
		//}
	//}	
}
		
function buyAllProducts(currentShop)
{
	//each products in shop
	
	var limiter = currentShop.productsList.length;
	
	for (var i in currentShop.productsList)
	{
		buyProduct(currentShop,currentShop.productsList[i]);
	}
}
				
function calculateProductProfit(shop,shopProduct,player,playerProduct)
{	
	var info = { };
	
	if(playerProduct == undefined || playerProduct.amount == 0 || parseInt(shopProduct.demand) == 0)
	{		
		info.transactionStatus = "no_in_store";
		return info;
	}
	
	info.transactionStatus = "ok";
	
	var amount = 0;
	var demand = 0;
	var playerAmount = 0;
	
	demand = parseInt(shopProduct.demand);
	playerAmount = parseInt(playerProduct.amount);
		
	if(demand > playerAmount)
	{
		amount = playerAmount;
	}
	else
	{
		amount = demand;
	}
		
	var transportLeft = getTransportLeftFromPlayer(shop,player);
		
	var transportTotalCost = 0;//Math.ceil((amount-transportLeft)/transportAmount)*transportCost;
	
	if(transportTotalCost < 0)
		transportTotalCost = 0;
		
	//info.profit = parseInt(shopProduct.maxPrice) * amount - (parseInt(playerProduct.price) * amount + transportTotalCost);
	
	info.profit = parseInt(shopProduct.maxPrice) - parseInt(playerProduct.price);
	
	//trace("### PROFIT: " + parseInt(info.profit) + ", PLAYER: " + parseInt(player.id) + ", MAX PRICE: " + parseInt(shopProduct.maxPrice) + ", PRICE: " + parseInt(playerProduct.price));
	
	if (parseInt(info.profit) < 0)
	{
		info.transactionStatus = "no_profit";
		return info;
	}
	
	info.transportLeft = Math.ceil((amount)/transportAmount)*transportAmount - amount;
	info.player = player;
	info.amount = amount;
	info.playerAmount = playerAmount - amount;
	info.price = parseInt(playerProduct.price);
	info.transportCost = transportTotalCost;
	info.productDbId = playerProduct.id;
	
	shopProduct.dbId = playerProduct.id;
	
	return info;
}

function getTransportLeftFromPlayer(shop, player)
{
	var limiter = shop.purchaseList.length;
	
	for (var i = 0; i < limiter; i++)
	{
		if(shop.purchaseList[i].player.id == player.id && shop.purchaseList[i].transportLeft != 0)
		{
			return shop.purchaseList[i].transportLeft;
		}
	}
	
	return 0;
}

function handleInternalRequest(evt)
{	
	if (evt.cmd == "beginSimulation")
	{		
		_players = [];
		
		var sql = "SELECT student.id AS uid, pom.ID AS pid, student.name, pom.product_id, pom.amount, pom.price";
		sql += " FROM student LEFT JOIN products_on_marketplace pom ON student.id = pom.owner ORDER BY uid ASC ";
		
		//var queryRes = dbase.executeQuery(sql);
		
		var queryRes = dbase.executeQuery(sql, _server.QUERY_INT_KEYS);
		
		var item = { };
		var limiter = evt.userList.length;
		
		//trace("Event users list: "+evt.userList.length);
 
		if (queryRes != null)
		{			

			//trace("Query is not NULL, size: "+queryRes.size())
			for (var i = 0; i < queryRes.size(); i++)
			{			
				tempRow = queryRes.get(i);
				
				var correctUser = false;
				
				//check if active on server
				for (var j = 0; j < limiter; j++)
				{
					
					var userObj = evt.userList[j];
					var userName = userObj.getName();
					var splitedName = userName.split("_");
					var userID = parseInt(splitedName[1]);
	
					//trace("User index:"+j);
					//trace("User to check:"+evt.userList[j].getName());
					//trace("check: "+userID+" vs "+parseInt(tempRow.getItem(1)));

					if (userID == parseInt(tempRow.getItem(1)))
					{
						correctUser = true;
						break;
					}
				}
				
				if (!correctUser) 
					continue;
				
					
				//trace("GOT correct user of ID")	
				if (parseInt(item.id) != parseInt(tempRow.getItem(1)))
				{
					if (item.id != undefined)
					{
						//trace('pushuje nowet playera o id: '+tempRow.getItem(1));
						_players.push(item);
					}
					
					item = { };
					item.id = tempRow.getItem(1);
					item.name = tempRow.getItem(3);
					item.productsList = [];
					
					//trace('nowy player, nowy itemek: '+tempRow.getItem(2));
					item.productsList[tempRow.getItem(2)] = { id:tempRow.getItem(2), typeId:tempRow.getItem(4), amount:tempRow.getItem(5), price:tempRow.getItem(6) };

				}
				else
				{
					//trace('wrzucam do istniejacego playera nowy itemek: '+tempRow.getItem(2));
					item.productsList[tempRow.getItem(2)] = { id:tempRow.getItem(2), typeId:tempRow.getItem(4), amount:tempRow.getItem(5), price:tempRow.getItem(6) };
				}
				
			}
			
			//if (_players.length > 1)
			//{
				//trace('wrzucam na koniec jeszcze jedengo playera o id: ' + item.id);
				_players.push(item);
			//}
		}
		
		populateShops();
		
		AI(_shops, _players, evt.userList, evt.room, evt.roomName);
	}
	else if (evt.dbManager)
	{
		dbase = __db.DbManager(evt.dbManager);
	}
}

/*
* This method handles internal events
* Internal events are dispactched by the Zone or Room where the extension is attached to
* 
* the (evt) object
*/
function handleInternalEvent(evt)
{
	// Add your code here
}
