/* 
* Initializion point:
* 
* this function is called as soon as the extension
* is loaded in the server.
* 
* You can add here all the initialization code
* 
*/
var dbase;

function init()
{
	//trace("Extension initialized")
}


/*
* This method is called by the server when an extension
* is being removed / destroyed.
* 
* Always make sure to release resources like setInterval(s)
* open files etc in this method.
* 
* In this case we delete the reference to the databaseManager
*/
function destroy()
{
	//trace("Extension destroyed")
	delete dbase;
}


/*
* 
* Handle Client Requests
* 
* cmd 		= a string with the client command to execute 
* params 	= list of parameters expected from the client
* user 		= the User object representing the sender
* fromRoom 	= the id of the room where the request was generated
* 
*/
function handleRequest(cmd, params, user, fromRoom)
{
	// Get a reference to the Zone where the target extension is running
	var zone = _server.instance.getZone("eduFarma");

	// Get a reference to the Extension we want to call
	var targetExtension = zone.getExtension("databaseExt");
	
	// Add your code here
	if (cmd == "addProduct")
	{
		var sql = "SELECT ID FROM products_in_warehouse WHERE owner = '" + _server.escapeQuotes(params.userDbId) + "' AND product_id = '" + _server.escapeQuotes(params.productId) + "'";
		
		//trace(sql);
		
		var queryRes = dbase.executeQuery(sql);
		
		if (queryRes && queryRes.size() > 0)
		{
			sql = "UPDATE products_in_warehouse SET amount = "
			sql += "amount + " + _server.escapeQuotes(params.amount)
			sql += " WHERE owner = '" + _server.escapeQuotes(params.userDbId) + "' AND product_id = '" + _server.escapeQuotes(params.productId) + "'";
			
			//trace(sql);
			
			queryRes = dbase.executeCommand(sql);
			//trace(queryRes);
		}
		else
		{
			sql = "INSERT INTO products_in_warehouse (owner, product_id, type, amount) VALUES ("
			sql += _server.escapeQuotes(params.userDbId) + ","
			sql += _server.escapeQuotes(params.productId) + ","
			sql += "'" + _server.escapeQuotes(params.type) + "',"
			sql += _server.escapeQuotes(params.amount) + ")";
			
			//trace(sql);
			
			queryRes = dbase.executeCommand(sql);
			//trace(queryRes);
		}		
	}	
	else if (cmd == "removeProduct")
	{
		var sql = "SELECT amount FROM products_in_warehouse WHERE owner = '" + _server.escapeQuotes(params.userDbId) + "' AND product_id = '" + _server.escapeQuotes(params.productId) + "'";
		
		//trace(sql);
			
		var queryRes = dbase.executeQuery(sql);
		
		if (queryRes && queryRes.size() > 0)
		{
			var tempRow = queryRes.get(0);
			var amount = tempRow.getItem("amount");
			
			amount = amount - params.amount;
			
			if (amount <= 0)
			{
				sql = "DELETE FROM products_in_warehouse WHERE owner = '" + _server.escapeQuotes(params.userDbId) + "' AND product_id = '" + _server.escapeQuotes(params.productId) + "'";
			}
			else
			{
				sql = "UPDATE products_in_warehouse SET amount = " + amount + " WHERE owner = '" + _server.escapeQuotes(params.userDbId) + "' AND product_id = '" + _server.escapeQuotes(params.productId) + "'";
			}
			
			dbase.executeCommand(sql);
		}		
	}
	else if (cmd == "toMarketplace")
	{
		var sql = "SELECT ID, price FROM products_on_marketplace WHERE owner = '" + _server.escapeQuotes(params.userDbId) + "' AND product_id = '" + _server.escapeQuotes(params.productId) + "'";
		
		//trace(sql);
		
		var queryRes = dbase.executeQuery(sql);
		
		if (queryRes && queryRes.size() > 0 && queryRes.get(0).getItem("price") == params.price)
		{			
			sql = "UPDATE products_on_marketplace SET amount = "
			sql += "amount + " + _server.escapeQuotes(params.amount)
			sql += " WHERE owner = '" + _server.escapeQuotes(params.userDbId) + "' AND product_id = '" + _server.escapeQuotes(params.productId) + "'";
			
			//trace(sql);
			
			queryRes = dbase.executeCommand(sql);
			//trace(queryRes);
		}
		else
		{
			sql = "INSERT INTO products_on_marketplace (owner, product_id, amount, price) VALUES ("
			sql += "'" + _server.escapeQuotes(params.userDbId) + "',"
			sql += "'" + _server.escapeQuotes(params.productId) + "',"
			sql += "'" + _server.escapeQuotes(params.amount) + "',"
			sql += "'" + _server.escapeQuotes(params.price) + "')"
						
			queryRes = dbase.executeCommand(sql);
			//trace(queryRes);
			
			sql = "SELECT LAST_INSERT_ID() AS id FROM products_on_marketplace"
		
			queryRes = dbase.executeQuery(sql);
			
			var response = { };
			
			response._cmd = cmd;
							
			var tempRow = queryRes.get(0);
			response.db = tempRow.getItem("id");
			response.id = params.storeId;
			
			_server.sendResponse(response, -1, null, [user]);
		}				
	}
	else if (cmd == "removeFromMarketplace")
	{
		var sql = "SELECT amount FROM products_on_marketplace WHERE owner = '" + _server.escapeQuotes(params.userDbId) + "' AND ID = '" + _server.escapeQuotes(params.productDbId) + "'";
		
		var queryRes = dbase.executeQuery(sql);
		
		if (queryRes && queryRes.size() > 0)
		{
			var tempRow = queryRes.get(0);
			var amount = tempRow.getItem("amount");
				
			params.amount = amount;
			
			handleRequest("addProduct", params, user, fromRoom);
			
			sql = "DELETE FROM products_on_marketplace WHERE owner = '" + _server.escapeQuotes(params.userDbId) + "' AND ID = '" + _server.escapeQuotes(params.productDbId) + "'";
			
			dbase.executeCommand(sql);
		}
	}
}

function handleInternalRequest(evt)
{
	if (evt.dbManager)
	{
		dbase = __db.DbManager(evt.dbManager);
	}
}

/*
* This method handles internal events
* Internal events are dispactched by the Zone or Room where the extension is attached to
* 
* the (evt) object
*/
function handleInternalEvent(evt)
{
	// Add your code here
}